/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.client;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.FutureMessageResult;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.ServiceException;
import org.mule.api.security.Credentials;
import org.mule.api.service.Service;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.ReceiveException;
import org.mule.client.DefaultLocalMuleClient;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.module.client.RemoteDispatcher;
import org.mule.module.client.i18n.ClientMessages;
import org.mule.security.MuleCredentials;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.session.DefaultMuleSession;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.NullPayload;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleClient
implements Disposable {
    protected static final Log logger = LogFactory.getLog(MuleClient.class);
    private MuleContext muleContext;
    private List dispatchers = new ArrayList();
    private MuleCredentials user;
    private DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
    private ConcurrentMap inboundEndpointCache = new ConcurrentHashMap();
    private ConcurrentMap outboundEndpointCache = new ConcurrentHashMap();

    protected MuleClient() throws MuleException {
        this(true);
    }

    public MuleClient(boolean startContext) throws MuleException {
        this.init(startContext);
    }

    public MuleClient(MuleContext context) throws MuleException {
        this.muleContext = context;
        this.init(false);
    }

    public MuleClient(String configResources) throws MuleException {
        this(configResources, (ConfigurationBuilder)new SpringXmlConfigurationBuilder(configResources));
    }

    public MuleClient(String user, String password) throws MuleException {
        this.init(true);
        this.user = new MuleCredentials(user, password.toCharArray());
    }

    public MuleClient(String configResources, ConfigurationBuilder builder) throws ConfigurationException, InitialisationException {
        if (builder == null) {
            logger.info((Object)("Builder passed in was null, using default builder: " + SpringXmlConfigurationBuilder.class.getName()));
            builder = new SpringXmlConfigurationBuilder(configResources);
        }
        logger.info((Object)"Initializing Mule...");
        this.muleContext = this.muleContextFactory.createMuleContext(builder);
    }

    public MuleClient(String configResources, ConfigurationBuilder builder, String user, String password) throws ConfigurationException, InitialisationException {
        this(configResources, builder);
        this.user = new MuleCredentials(user, password.toCharArray());
    }

    private void init(boolean startManager) throws MuleException {
        if (this.muleContext == null) {
            logger.info((Object)"No existing ManagementContext found, creating a new Mule instance");
            DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
            DefaultMuleConfiguration config = new DefaultMuleConfiguration();
            config.setClientMode(true);
            contextBuilder.setMuleConfiguration((MuleConfiguration)config);
            this.muleContext = this.muleContextFactory.createMuleContext((MuleContextBuilder)contextBuilder);
        } else {
            logger.info((Object)("Using existing MuleContext: " + this.muleContext));
        }
        if (!this.muleContext.isStarted() && startManager) {
            logger.info((Object)"Starting Mule...");
            this.muleContext.start();
        }
    }

    public void dispatch(String url, Object payload, Map messageProperties) throws MuleException {
        this.dispatch(url, (MuleMessage)new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    public void dispatch(String url, MuleMessage message) throws MuleException {
        OutboundEndpoint endpoint = this.getOutboundEndpoint(url, MessageExchangePattern.ONE_WAY, null);
        MuleEvent event = this.getEvent(message, endpoint);
        try {
            endpoint.process(event);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(ClientMessages.failedToDispatchClientEvent(), event, (MessageProcessor)endpoint, (Throwable)e);
        }
    }

    public MuleMessage sendDirect(String component, String transformers, Object payload, Map messageProperties) throws MuleException {
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties, this.muleContext);
        return this.sendDirect(component, transformers, (MuleMessage)message);
    }

    public MuleMessage sendDirect(String componentName, String transformers, MuleMessage message) throws MuleException {
        MuleEvent resultEvent;
        MuleMessage result;
        Service service = this.muleContext.getRegistry().lookupService(componentName);
        if (service == null) {
            throw new ServiceException(CoreMessages.objectNotRegistered((String)"Service", (String)componentName));
        }
        List trans = null;
        if (transformers != null) {
            trans = TransformerUtils.getTransformers((String)transformers, (MuleContext)this.muleContext);
        }
        DefaultMuleSession session = new DefaultMuleSession((FlowConstruct)service, this.muleContext);
        ImmutableEndpoint endpoint = this.getDefaultClientEndpoint(service, message.getPayload(), true);
        DefaultMuleEvent event = new DefaultMuleEvent(message, endpoint, (MuleSession)session);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleClient sending event direct to: " + componentName + ". MuleEvent is: " + event));
        }
        MuleMessage muleMessage = result = (resultEvent = service.sendEvent((MuleEvent)event)) == null ? null : resultEvent.getMessage();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result of MuleClient sendDirect is: " + (result == null ? "null" : result.getPayload())));
        }
        if (result != null && trans != null) {
            result.applyTransformers(resultEvent, trans);
        }
        return result;
    }

    public void dispatchDirect(String component, Object payload, Map messageProperties) throws MuleException {
        this.dispatchDirect(component, (MuleMessage)new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    public void dispatchDirect(String componentName, MuleMessage message) throws MuleException {
        Service service = this.muleContext.getRegistry().lookupService(componentName);
        if (service == null) {
            throw new ServiceException(CoreMessages.objectNotRegistered((String)"Service", (String)componentName));
        }
        DefaultMuleSession session = new DefaultMuleSession((FlowConstruct)service, this.muleContext);
        ImmutableEndpoint endpoint = this.getDefaultClientEndpoint(service, message.getPayload(), false);
        DefaultMuleEvent event = new DefaultMuleEvent(message, endpoint, (MuleSession)session);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleClient dispatching event direct to: " + componentName + ". MuleEvent is: " + event));
        }
        service.dispatchEvent((MuleEvent)event);
    }

    public FutureMessageResult sendAsync(String url, Object payload, Map messageProperties) throws MuleException {
        return this.sendAsync(url, payload, messageProperties, 0);
    }

    public FutureMessageResult sendAsync(String url, MuleMessage message) throws MuleException {
        return this.sendAsync(url, message, Integer.MIN_VALUE);
    }

    public FutureMessageResult sendAsync(String url, Object payload, Map messageProperties, int timeout) throws MuleException {
        return this.sendAsync(url, (MuleMessage)new DefaultMuleMessage(payload, messageProperties, this.muleContext), timeout);
    }

    public FutureMessageResult sendAsync(final String url, final MuleMessage message, final int timeout) throws MuleException {
        Callable call = new Callable(){

            public Object call() throws Exception {
                return MuleClient.this.send(url, message, timeout);
            }
        };
        FutureMessageResult result = new FutureMessageResult(call, this.muleContext);
        if (this.muleContext.getWorkManager() != null) {
            result.setExecutor((Executor)this.muleContext.getWorkManager());
        }
        result.execute();
        return result;
    }

    public FutureMessageResult sendDirectAsync(String component, String transformers, Object payload, Map messageProperties) throws MuleException {
        return this.sendDirectAsync(component, transformers, (MuleMessage)new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    public FutureMessageResult sendDirectAsync(final String component, String transformers, final MuleMessage message) throws MuleException {
        Callable call = new Callable(){

            public Object call() throws Exception {
                return MuleClient.this.sendDirect(component, null, message);
            }
        };
        FutureMessageResult result = new FutureMessageResult(call, this.muleContext);
        if (this.muleContext.getWorkManager() != null) {
            result.setExecutor((Executor)this.muleContext.getWorkManager());
        }
        if (StringUtils.isNotBlank((String)transformers)) {
            result.setTransformers(TransformerUtils.getTransformers((String)transformers, (MuleContext)this.muleContext));
        }
        result.execute();
        return result;
    }

    public MuleMessage send(String url, Object payload, Map messageProperties) throws MuleException {
        return this.send(url, payload, messageProperties, Integer.MIN_VALUE);
    }

    public MuleMessage send(String url, MuleMessage message) throws MuleException {
        return this.send(url, message, Integer.MIN_VALUE);
    }

    public MuleMessage send(String url, Object payload, Map messageProperties, int timeout) throws MuleException {
        if (messageProperties == null) {
            messageProperties = new HashMap<String, String>();
        }
        if (messageProperties.get("MULE_REMOTE_SYNC") == null) {
            messageProperties = new HashMap(messageProperties);
            messageProperties.put("MULE_REMOTE_SYNC", "true");
        }
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties, this.muleContext);
        return this.send(url, (MuleMessage)message, timeout);
    }

    public MuleMessage send(String url, MuleMessage message, int timeout) throws MuleException {
        OutboundEndpoint endpoint = this.getOutboundEndpoint(url, MessageExchangePattern.REQUEST_RESPONSE, timeout);
        MuleEvent event = this.getEvent(message, endpoint);
        event.setTimeout(timeout);
        MuleEvent response = endpoint.process(event);
        if (response != null) {
            return response.getMessage();
        }
        return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.muleContext);
    }

    public MuleMessage request(String url, long timeout) throws MuleException {
        InboundEndpoint endpoint = this.getInboundEndpoint(url);
        try {
            return endpoint.request(timeout);
        }
        catch (Exception e) {
            throw new ReceiveException((ImmutableEndpoint)endpoint, timeout, (Throwable)e);
        }
    }

    public MuleMessage request(String url, String transformers, long timeout) throws MuleException {
        return this.request(url, TransformerUtils.getTransformers((String)transformers, (MuleContext)this.muleContext), timeout);
    }

    public MuleMessage request(String url, List transformers, long timeout) throws MuleException {
        return this.request(url, timeout);
    }

    protected MuleEvent getEvent(MuleMessage message, OutboundEndpoint endpoint) throws MuleException {
        try {
            DefaultMuleSession session = new DefaultMuleSession((FlowConstruct)new DefaultLocalMuleClient.MuleClientFlowConstruct(this.muleContext), this.muleContext);
            if (this.user != null) {
                message.setOutboundProperty("MULE_USER", (Object)MuleCredentials.createHeader((String)this.user.getUsername(), (char[])this.user.getPassword()));
            }
            return new DefaultMuleEvent(message, (ImmutableEndpoint)endpoint, (MuleSession)session);
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToCreate((String)"Client event"), message, (MessageProcessor)endpoint, (Throwable)e);
        }
    }

    protected InboundEndpoint getInboundEndpoint(String uri) throws MuleException {
        InboundEndpoint concurrentlyAddedEndpoint;
        InboundEndpoint endpoint = (InboundEndpoint)this.inboundEndpointCache.get((Object)uri);
        if (endpoint == null && (concurrentlyAddedEndpoint = (InboundEndpoint)this.inboundEndpointCache.putIfAbsent((Object)uri, (Object)(endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(uri)))) != null) {
            return concurrentlyAddedEndpoint;
        }
        return endpoint;
    }

    protected OutboundEndpoint getOutboundEndpoint(String uri, MessageExchangePattern exchangePattern, Integer responseTimeout) throws MuleException {
        String key = String.format("%1s:%2s:%3s", uri, exchangePattern, responseTimeout);
        OutboundEndpoint endpoint = (OutboundEndpoint)this.outboundEndpointCache.get((Object)key);
        if (endpoint == null) {
            OutboundEndpoint concurrentlyAddedEndpoint;
            EndpointBuilder endpointBuilder = this.muleContext.getRegistry().lookupEndpointFactory().getEndpointBuilder(uri);
            endpointBuilder.setExchangePattern(exchangePattern);
            if (responseTimeout != null && responseTimeout > 0) {
                endpointBuilder.setResponseTimeout(responseTimeout.intValue());
            }
            if ((concurrentlyAddedEndpoint = (OutboundEndpoint)this.outboundEndpointCache.putIfAbsent((Object)key, (Object)(endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointBuilder)))) != null) {
                return concurrentlyAddedEndpoint;
            }
        }
        return endpoint;
    }

    protected ImmutableEndpoint getDefaultClientEndpoint(Service service, Object payload, boolean sync) throws MuleException {
        if (!(service.getMessageSource() instanceof ServiceCompositeMessageSource)) {
            throw new IllegalStateException("Only 'CompositeMessageSource' is supported with MuleClient.sendDirect() and MuleClient.dispatchDirect()");
        }
        ImmutableEndpoint endpoint = (ImmutableEndpoint)((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoints().get(0);
        if (endpoint != null) {
            if (endpoint.getTransformers() != null) {
                if (TransformerUtils.isSourceTypeSupportedByFirst((List)endpoint.getTransformers(), payload.getClass())) {
                    return endpoint;
                }
                EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder(endpoint);
                builder.setTransformers(new LinkedList());
                builder.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
                return this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
            }
            return endpoint;
        }
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("vm://mule.client", this.muleContext);
        builder.setName("muleClientProvider");
        endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
        return endpoint;
    }

    public void sendNoReceive(String url, Object payload, Map<String, Object> messageProperties) throws MuleException {
        if (messageProperties == null) {
            messageProperties = new HashMap<String, Object>();
        }
        messageProperties.put("MULE_REMOTE_SYNC", "false");
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties, this.muleContext);
        OutboundEndpoint endpoint = this.getOutboundEndpoint(url, MessageExchangePattern.REQUEST_RESPONSE, null);
        MuleEvent event = this.getEvent((MuleMessage)message, endpoint);
        try {
            endpoint.process(event);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(ClientMessages.failedToDispatchClientEvent(), event, (MessageProcessor)endpoint, (Throwable)e);
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Deprecated
    public void registerComponent(Object component, String name, EndpointURI listenerEndpoint) throws MuleException {
        throw new UnsupportedOperationException("registerComponent");
    }

    @Deprecated
    public void registerComponent(Object component, String name, MuleEndpointURI listenerEndpoint, MuleEndpointURI sendEndpoint) throws MuleException {
        throw new UnsupportedOperationException("registerComponent");
    }

    @Deprecated
    public void unregisterComponent(String name) throws MuleException {
        throw new UnsupportedOperationException("registerComponent");
    }

    public RemoteDispatcher getRemoteDispatcher(String serverEndpoint) throws MuleException {
        RemoteDispatcher rd = new RemoteDispatcher(serverEndpoint, this.muleContext);
        rd.setExecutor((Executor)this.muleContext.getWorkManager());
        this.dispatchers.add(rd);
        return rd;
    }

    public RemoteDispatcher getRemoteDispatcher(String serverEndpoint, String user, String password) throws MuleException {
        RemoteDispatcher rd = new RemoteDispatcher(serverEndpoint, (Credentials)new MuleCredentials(user, password.toCharArray()), this.muleContext);
        rd.setExecutor((Executor)this.muleContext.getWorkManager());
        this.dispatchers.add(rd);
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.dispatchers;
        synchronized (list) {
            for (RemoteDispatcher remoteDispatcher : this.dispatchers) {
                remoteDispatcher.dispose();
                Object var3_3 = null;
            }
            this.dispatchers.clear();
        }
        if (this.muleContext.getConfiguration().isClientMode()) {
            logger.info((Object)"Stopping Mule...");
            this.muleContext.dispose();
        }
    }

    public void setProperty(String key, Object value) {
        try {
            this.muleContext.getRegistry().registerObject(key, value);
        }
        catch (RegistrationException e) {
            logger.error((Object)e);
        }
    }

    public Object getProperty(String key) {
        return this.muleContext.getRegistry().lookupObject(key);
    }

    public MuleConfiguration getConfiguration() {
        return this.muleContext.getConfiguration();
    }
}

