/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.client.remoting;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.api.service.Service;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.component.SimpleCallableJavaComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.message.DefaultExceptionPayload;
import org.mule.model.seda.SedaService;
import org.mule.module.client.remoting.ServerHandshake;
import org.mule.module.client.remoting.notification.RemoteDispatcherNotification;
import org.mule.object.PrototypeObjectFactory;
import org.mule.transport.AbstractConnector;
import org.mule.transport.NullPayload;
import org.mule.util.MapUtils;

public class RemoteDispatcherComponent
implements Callable,
Initialisable {
    protected static final Log logger = LogFactory.getLog(RemoteDispatcherComponent.class);
    public static final String MANAGER_COMPONENT_NAME = "_muleManagerComponent";
    protected WireFormat wireFormat;
    protected String encoding;
    protected int synchronousEventTimeout = 5000;
    protected MuleContext muleContext;

    public void initialise() throws InitialisationException {
        if (this.wireFormat == null) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"wireFormat"), (Initialisable)this);
        }
    }

    public Object onCall(MuleEventContext context) throws Exception {
        this.muleContext = context.getMuleContext();
        if (context.transformMessageToString().equals("MULE_CLIENT_HANDSHAKE")) {
            return this.doHandshake(context);
        }
        logger.debug((Object)"Message received by RemoteDispatcherComponent");
        ByteArrayInputStream in = new ByteArrayInputStream(context.transformMessageToBytes());
        RemoteDispatcherNotification action = (RemoteDispatcherNotification)((Object)((MuleMessage)this.wireFormat.read((InputStream)in)).getPayload());
        if (action.getMessage() != null) {
            Method m = action.getMessage().getClass().getDeclaredMethod("initAfterDeserialisation", MuleContext.class);
            m.setAccessible(true);
            m.invoke((Object)action.getMessage(), this.muleContext);
        }
        Object result = 604 == action.getAction() ? this.invokeAction(action, context) : (603 == action.getAction() || 602 == action.getAction() ? this.sendAction(action, context) : (601 == action.getAction() ? this.receiveAction(action, context) : this.handleException(null, (Throwable)new DefaultMuleException(CoreMessages.eventTypeNotRecognised((String)("RemoteDispatcherNotification:" + action.getAction()))))));
        return result;
    }

    protected ServerHandshake doHandshake(MuleEventContext context) throws TransformerException {
        ServerHandshake handshake = new ServerHandshake();
        handshake.setWireFormatClass(this.wireFormat.getClass().getName());
        return handshake;
    }

    protected Object invokeAction(RemoteDispatcherNotification action, MuleEventContext context) throws MuleException {
        MuleMessage result = null;
        String endpoint = action.getResourceIdentifier();
        String destComponent = action.getResourceIdentifier().startsWith("mule:") ? endpoint.substring(endpoint.lastIndexOf("/") + 1) : endpoint;
        if (destComponent != null) {
            DefaultMuleSession session = new DefaultMuleSession(this.muleContext.getRegistry().lookupService(destComponent), this.muleContext);
            EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder(RequestContext.getEvent().getEndpoint());
            builder.setTransformers(new LinkedList());
            InboundEndpoint ep = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
            DefaultMuleEvent event = new DefaultMuleEvent(action.getMessage(), (ImmutableEndpoint)ep, context.getSession(), context.isSynchronous());
            event = RequestContext.setEvent((MuleEvent)event);
            if (context.isSynchronous()) {
                result = session.getService().sendEvent((MuleEvent)event);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.wireFormat.write((OutputStream)out, (Object)result, this.getEncoding());
                return out.toByteArray();
            }
            session.getService().dispatchEvent((MuleEvent)event);
            return null;
        }
        return this.handleException(result, (Throwable)new DefaultMuleException(CoreMessages.couldNotDetermineDestinationComponentFromEndpoint((String)endpoint)));
    }

    protected Object sendAction(RemoteDispatcherNotification action, MuleEventContext context) throws MuleException {
        MuleMessage result = null;
        OutboundEndpoint endpoint = null;
        MuleContext managementContext = context.getMuleContext();
        try {
            if (602 == action.getAction()) {
                endpoint = managementContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(action.getResourceIdentifier());
                context.dispatchEvent(action.getMessage(), endpoint);
                return null;
            }
            EndpointFactory endpointFactory = managementContext.getRegistry().lookupEndpointFactory();
            EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(action.getResourceIdentifier());
            endpointBuilder.setSynchronous(true);
            endpoint = managementContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointBuilder);
            result = context.sendEvent(action.getMessage(), endpoint);
            if (result == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.wireFormat.write((OutputStream)out, (Object)result, this.getEncoding());
            return out.toByteArray();
        }
        catch (Exception e) {
            return this.handleException(result, e);
        }
    }

    protected Object receiveAction(RemoteDispatcherNotification action, MuleEventContext context) throws MuleException {
        MuleMessage result = null;
        try {
            OutboundEndpoint endpoint = context.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(action.getResourceIdentifier());
            long timeout = MapUtils.getLongValue((Map)action.getProperties(), (Object)"MULE_EVENT_TIMEOUT", (long)this.getSynchronousEventTimeout());
            result = endpoint.getConnector().request(action.getResourceIdentifier(), timeout);
            if (result != null) {
                List transformers = ((AbstractConnector)endpoint.getConnector()).getDefaultInboundTransformers();
                if (transformers != null) {
                    result.applyTransformers(transformers);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.wireFormat.write((OutputStream)out, (Object)result, this.getEncoding());
                return out.toByteArray();
            }
            return null;
        }
        catch (Exception e) {
            return this.handleException(result, e);
        }
    }

    public static Service getSerivce(InboundEndpoint endpoint, WireFormat wireFormat, String encoding, int eventTimeout, MuleContext muleContext) throws MuleException {
        try {
            SedaService service = new SedaService();
            service.setName(MANAGER_COMPONENT_NAME);
            service.setModel(muleContext.getRegistry().lookupSystemModel());
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("wireFormat", wireFormat);
            props.put("encoding", encoding);
            props.put("synchronousEventTimeout", new Integer(eventTimeout));
            service.setComponent((Component)new SimpleCallableJavaComponent((ObjectFactory)new PrototypeObjectFactory(RemoteDispatcherComponent.class, props)));
            service.setMuleContext(muleContext);
            service.getInboundRouter().addEndpoint(endpoint);
            return service;
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, null);
        }
    }

    protected Object handleException(MuleMessage result, Throwable e) {
        logger.error((Object)("Failed to process admin request: " + e.getMessage()), e);
        if (result == null) {
            result = new DefaultMuleMessage((Object)NullPayload.getInstance(), (Map)null, this.muleContext);
        }
        result.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload(e));
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.wireFormat.write((OutputStream)out, (Object)result, this.getEncoding());
            return out.toByteArray();
        }
        catch (Exception e1) {
            logger.error((Object)("Failed to format message, using direct string (details at debug level): " + e1.getMessage()));
            logger.debug((Object)e1.toString(), (Throwable)e1);
            return e.getMessage();
        }
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getSynchronousEventTimeout() {
        return this.synchronousEventTimeout;
    }

    public void setSynchronousEventTimeout(int synchronousEventTimeout) {
        this.synchronousEventTimeout = synchronousEventTimeout;
    }
}

