/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.config.ConfigResource;
import org.mule.config.spring.MuleApplicationContext;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class WebappMuleXmlConfigurationBuilder
extends SpringXmlConfigurationBuilder {
    public static final String MULE_CONTEXT_ATTRIBUTE = "org.mule.MuleContext";
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ServletContext context;

    public WebappMuleXmlConfigurationBuilder(ServletContext servletContext, String configResources) throws ConfigurationException {
        super(configResources);
        this.context = servletContext;
    }

    public WebappMuleXmlConfigurationBuilder(ServletContext servletContext, String[] configResources) throws ConfigurationException {
        super(configResources);
        this.context = servletContext;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        if (this.getParentContext() == null) {
            this.setParentContext(this.loadParentContext(this.context));
        }
        super.doConfigure(muleContext);
    }

    protected ConfigResource[] loadConfigResources(String[] configs) throws ConfigurationException {
        try {
            this.configResources = new ConfigResource[configs.length];
            for (int i = 0; i < configs.length; ++i) {
                this.configResources[i] = new ServletContextOrClassPathConfigResource(configs[i]);
            }
            return this.configResources;
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected ApplicationContext createApplicationContext(MuleContext muleContext, ConfigResource[] configResources) {
        Resource[] servletContextResources = new Resource[configResources.length];
        for (int i = 0; i < configResources.length; ++i) {
            servletContextResources[i] = new ServletContextOrClassPathResource(this.context, configResources[i].getResourceName());
        }
        return new MuleApplicationContext(muleContext, servletContextResources);
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        ApplicationContext parentContext = null;
        String locatorFactorySelector = servletContext.getInitParameter("locatorFactorySelector");
        String parentContextKey = servletContext.getInitParameter("parentContextKey");
        if (parentContextKey != null) {
            BeanFactoryLocator locator = ContextSingletonBeanFactoryLocator.getInstance((String)locatorFactorySelector);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting parent context definition: using parent context key of '" + parentContextKey + "' with BeanFactoryLocator"));
            }
            parentContext = (ApplicationContext)locator.useBeanFactory(parentContextKey).getFactory();
        }
        return parentContext;
    }

    class ServletContextOrClassPathResource
    extends AbstractResource {
        private final ServletContext servletContext;
        private final String path;

        public ServletContextOrClassPathResource(ServletContext servletContext, String path) {
            Assert.notNull((Object)servletContext, (String)"Cannot resolve ServletContextResource without ServletContext");
            this.servletContext = servletContext;
            Assert.notNull((Object)path, (String)"path is required");
            this.path = StringUtils.cleanPath((String)path);
        }

        public InputStream getInputStream() throws IOException {
            InputStream is = this.getServletContextInputStream();
            if (is == null) {
                is = this.getClasspathInputStream();
            }
            if (is == null) {
                throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
            }
            return is;
        }

        protected InputStream getServletContextInputStream() {
            String servletContextPath = this.path;
            if (!servletContextPath.startsWith("/")) {
                servletContextPath = "/" + servletContextPath;
            }
            return this.servletContext.getResourceAsStream(servletContextPath);
        }

        protected InputStream getClasspathInputStream() {
            String classpathPath = this.path;
            if (classpathPath.startsWith("/")) {
                classpathPath = classpathPath.substring(1);
            }
            return ClassUtils.getDefaultClassLoader().getResourceAsStream(classpathPath);
        }

        public String getDescription() {
            return this.path;
        }
    }

    class ServletContextOrClassPathConfigResource
    extends ConfigResource {
        public ServletContextOrClassPathConfigResource(String resourceName) throws IOException {
            super(resourceName, null);
        }
    }
}

