/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.builders.WebappMuleXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class MuleXmlBuilderContextListener
implements ServletContextListener {
    public static final String INIT_PARAMETER_MULE_CONFIG = "org.mule.config";
    private MuleContext muleContext;
    protected final transient Log logger = LogFactory.getLog(MuleXmlBuilderContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        this.initialize(event.getServletContext());
    }

    public void initialize(ServletContext context) {
        String config = context.getInitParameter(INIT_PARAMETER_MULE_CONFIG);
        if (config == null) {
            config = this.getDefaultConfigResource();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No Mule config file(s) specified, using default: " + config));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Mule config file(s): " + config));
        }
        try {
            this.muleContext = this.createMuleContext(config, context);
            this.muleContext.start();
        }
        catch (MuleException ex) {
            context.log(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        catch (Error error) {
            context.log(error.getMessage(), (Throwable)error);
            error.printStackTrace();
            throw error;
        }
    }

    protected MuleContext createMuleContext(String configResource, ServletContext context) throws ConfigurationException, InitialisationException {
        WebappMuleXmlConfigurationBuilder builder = new WebappMuleXmlConfigurationBuilder(context, configResource);
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        ApplicationContext parentContext = (ApplicationContext)context.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (parentContext != null) {
            builder.setParentContext(parentContext);
        }
        return muleContextFactory.createMuleContext((ConfigurationBuilder)builder);
    }

    protected String getDefaultConfigResource() {
        return "mule-config.xml";
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.destroy();
    }

    public void destroy() {
        if (!(this.muleContext == null || this.muleContext.isDisposing() && this.muleContext.isDisposed())) {
            this.muleContext.dispose();
        }
    }
}

