/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.mule.MuleServer;
import org.mule.modules.boot.DefaultMuleClassPathConfig;
import org.mule.modules.boot.LibraryDownloader;
import org.mule.util.ClassUtils;
import org.mule.util.SystemUtils;
import org.tanukisoftware.wrapper.WrapperSimpleApp;

public class MuleBootstrap {
    private MuleBootstrap() {
    }

    public static void main(String[] args) throws Exception {
        String mainClassName;
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("")) {
            muleHome = new File(muleHomeVar);
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either MULE_HOME is not set or does not contain a valid directory.");
        }
        DefaultMuleClassPathConfig classPath = new DefaultMuleClassPathConfig(muleHome);
        MuleBootstrap.addLibrariesToClasspath(classPath.getURLs());
        if (!ClassUtils.isClassOnPath((String)"javax.activation.DataSource", (Class)MuleBootstrap.class)) {
            LibraryDownloader downloader = new LibraryDownloader(muleHome);
            MuleBootstrap.addLibrariesToClasspath(downloader.downloadLibraries());
        }
        if ((mainClassName = SystemUtils.getCommandLineOption((String)"-main", (String[])args)) == null) {
            mainClassName = MuleServer.class.getName();
        }
        String[] appArgs = new String[args.length + 1];
        appArgs[0] = mainClassName;
        System.arraycopy(args, 0, appArgs, 1, args.length);
        WrapperSimpleApp.main((String[])appArgs);
    }

    private static void addLibrariesToClasspath(List urls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader sys = ClassLoader.getSystemClassLoader();
        if (!(sys instanceof URLClassLoader)) {
            throw new IllegalArgumentException("PANIC: Mule has been started with an unsupported classloader: " + sys.getClass().getName() + ". " + "Please report this error to user<at>mule<dot>codehaus<dot>org");
        }
        URLClassLoader sysCl = (URLClassLoader)sys;
        Class refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }
}

