/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.atom.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.activation.DataHandler;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Person;
import org.apache.abdera.parser.stax.FOMWriterOptions;
import org.apache.abdera.writer.WriterOptions;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.transformers.AbstractExpressionTransformer;
import org.mule.expression.transformers.ExpressionArgument;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.StringUtils;

public class AtomEntryBuilderTransformer
extends AbstractExpressionTransformer {
    private static final DataType<Entry> TYPE_ENTRY = DataTypeFactory.create(Entry.class);
    private static final DataType<OutputHandler> TYPE_OUTPUT_HANDLER = DataTypeFactory.create(OutputHandler.class);

    public AtomEntryBuilderTransformer() {
        this.setReturnDataType(TYPE_OUTPUT_HANDLER);
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Factory factory = Abdera.getInstance().getFactory();
        Entry entry = factory.newEntry();
        for (ExpressionArgument arg : this.arguments) {
            Object author;
            Object date;
            if (arg.getName().equals("title")) {
                entry.setTitle(StringUtils.trimToEmpty((String)((String)arg.evaluate(message))));
                continue;
            }
            if (arg.getName().equals("id")) {
                entry.setId(StringUtils.trimToEmpty((String)((String)arg.evaluate(message))));
                continue;
            }
            if (arg.getName().equals("summary")) {
                entry.setSummary(StringUtils.trimToEmpty((String)((String)arg.evaluate(message))));
                continue;
            }
            if (arg.getName().equals("content")) {
                Object content = arg.evaluate(message);
                if (content instanceof DataHandler) {
                    entry.setContent((DataHandler)content);
                }
                if (content instanceof Element) {
                    entry.setContent((Element)content);
                }
                if (content instanceof String) {
                    entry.setContent((String)content);
                }
                if (!(content instanceof InputStream)) continue;
                entry.setContent((InputStream)content);
                continue;
            }
            if (arg.getName().equals("updated")) {
                date = arg.evaluate(message);
                if (date instanceof Date) {
                    entry.setUpdated((Date)date);
                    continue;
                }
                entry.setUpdated(date.toString());
                continue;
            }
            if (arg.getName().equals("edited")) {
                date = arg.evaluate(message);
                if (date instanceof Date) {
                    entry.setEdited((Date)date);
                    continue;
                }
                entry.setEdited(date.toString());
                continue;
            }
            if (arg.getName().equals("published")) {
                date = arg.evaluate(message);
                if (date instanceof Date) {
                    entry.setPublished((Date)date);
                    continue;
                }
                entry.setPublished(date.toString());
                continue;
            }
            if (arg.getName().equals("rights")) {
                entry.setRights((String)arg.evaluate(message));
                continue;
            }
            if (arg.getName().equals("draft")) {
                entry.setDraft(((Boolean)arg.evaluate(message)).booleanValue());
                continue;
            }
            if (arg.getName().equals("author")) {
                author = arg.evaluate(message);
                if (author instanceof Person) {
                    entry.addAuthor((Person)author);
                    continue;
                }
                entry.addAuthor(author.toString());
                continue;
            }
            if (arg.getName().equals("category")) {
                Object category = arg.evaluate(message);
                if (category instanceof Category) {
                    entry.addCategory((Category)category);
                    continue;
                }
                entry.addCategory(category.toString());
                continue;
            }
            if (arg.getName().equals("contributor")) {
                author = arg.evaluate(message);
                if (author instanceof Person) {
                    entry.addContributor((Person)author);
                    continue;
                }
                entry.addContributor(author.toString());
                continue;
            }
            if (arg.getName().equals("link")) {
                Object link = arg.evaluate(message);
                if (link instanceof Link) {
                    entry.addLink((Link)link);
                    continue;
                }
                entry.addLink(link.toString());
                continue;
            }
            throw new TransformerException(CoreMessages.propertyHasInvalidValue((String)"entry-property.name", (Object)arg.getName()), (Transformer)this);
        }
        if (TYPE_ENTRY.equals((Object)this.getReturnDataType())) {
            return entry;
        }
        if (TYPE_OUTPUT_HANDLER.equals((Object)this.getReturnDataType())) {
            final Entry e = entry;
            return new OutputHandler(){

                public void write(MuleEvent event, OutputStream out) throws IOException {
                    FOMWriterOptions opts = new FOMWriterOptions();
                    opts.setCharset(event.getEncoding());
                    e.writeTo(out, (WriterOptions)opts);
                }
            };
        }
        return entry.toString();
    }
}

