/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.endpoint;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mule.api.EndpointAnnotationParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.annotations.meta.Channel;
import org.mule.api.config.ConfigurationException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.config.endpoint.AnnotatedEndpointData;
import org.mule.config.endpoint.AnnotatedEndpointHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.StringUtils;

public abstract class AbstractEndpointAnnotationParser
implements EndpointAnnotationParser,
MuleContextAware {
    public static final String ENDPOINT_BUILDER_POSTFIX = ".builder";
    protected MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected AnnotatedEndpointHelper getEndpointHelper() throws MuleException {
        AnnotatedEndpointHelper helper = (AnnotatedEndpointHelper)this.muleContext.getRegistry().lookupObject(AnnotatedEndpointHelper.class);
        if (helper == null) {
            helper = new AnnotatedEndpointHelper(this.muleContext);
        }
        return helper;
    }

    @Override
    public OutboundEndpoint parseOutboundEndpoint(Annotation annotation, Map metaInfo) throws MuleException {
        return (OutboundEndpoint)this.getEndpointHelper().processEndpoint(this.createEndpointData(annotation));
    }

    @Override
    public InboundEndpoint parseInboundEndpoint(Annotation annotation, Map metaInfo) throws MuleException {
        return (InboundEndpoint)this.getEndpointHelper().processEndpoint(this.createEndpointData(annotation));
    }

    @Override
    public boolean supports(Annotation annotation, Class clazz, Member member) {
        Channel channel = annotation.annotationType().getAnnotation(Channel.class);
        return channel != null && channel.identifer().equals(this.getIdentifier());
    }

    protected Properties convertProperties(String[] properties) {
        if (properties == null || properties.length == 0) {
            return null;
        }
        Properties props = new Properties();
        for (String property : properties) {
            StringTokenizer st = new StringTokenizer(property, "=");
            if (!st.hasMoreTokens()) continue;
            props.setProperty(st.nextToken().trim(), st.nextToken().trim());
        }
        return props;
    }

    protected <T> T lookupConfig(String location, Class<T> type) throws ConfigurationException {
        if (StringUtils.isEmpty((String)location)) {
            return null;
        }
        Object o = this.muleContext.getRegistry().lookupObject(location + ENDPOINT_BUILDER_POSTFIX);
        if (o == null && (o = this.muleContext.getRegistry().lookupObject(location)) == null) {
            return null;
        }
        if (type.isInstance(o)) {
            return (T)o;
        }
        throw new ConfigurationException(CoreMessages.objectNotOfCorrectType(o.getClass(), type));
    }

    protected abstract String getIdentifier();

    protected abstract AnnotatedEndpointData createEndpointData(Annotation var1) throws MuleException;
}

