/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.model.Model;
import org.mule.api.service.Service;
import org.mule.impl.annotations.AnnotatedServiceBuilder;
import org.mule.impl.model.resolvers.AnnotatedEntryPointResolver;
import org.mule.model.resolvers.DefaultEntryPointResolverSet;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class AnnotatedServiceFactoryBean
extends AbstractFactoryBean
implements MuleContextAware {
    private Model model;
    private String name;
    private MuleContext muleContext;
    private Service service;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
        DefaultEntryPointResolverSet resolverSet = new DefaultEntryPointResolverSet();
        resolverSet.getEntryPointResolvers().clear();
        resolverSet.addEntryPointResolver((EntryPointResolver)new AnnotatedEntryPointResolver());
        this.model.setEntryPointResolverSet((EntryPointResolverSet)resolverSet);
    }

    protected Object createInstance() throws Exception {
        AnnotatedServiceBuilder builder = new AnnotatedServiceBuilder(this.muleContext);
        builder.setModel(this.getModel());
        this.service = builder.createService(null);
        return this.service;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class getObjectType() {
        return Service.class;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.service.initialise();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

