/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Map;
import org.mule.api.EndpointAnnotationParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.config.annotations.converters.PropertiesConverter;
import org.mule.config.annotations.endpoints.Channel;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.endpoint.AnnotatedEndpointBuilder;
import org.mule.impl.endpoint.AnnotatedEndpointData;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndpointAnnotationParser
implements EndpointAnnotationParser,
MuleContextAware {
    protected MuleContext muleContext;
    private PropertiesConverter converter = new PropertiesConverter();

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected AnnotatedEndpointBuilder getEndpointBuilder() throws MuleException {
        assert (this.muleContext != null);
        return new AnnotatedEndpointBuilder(this.muleContext);
    }

    @Override
    public OutboundEndpoint parseOutboundEndpoint(Annotation annotation, Map metaInfo) throws MuleException {
        return (OutboundEndpoint)this.getEndpointBuilder().processEndpoint(this.createEndpointData(annotation));
    }

    @Override
    public InboundEndpoint parseInboundEndpoint(Annotation annotation, Map metaInfo) throws MuleException {
        return (InboundEndpoint)this.getEndpointBuilder().processEndpoint(this.createEndpointData(annotation));
    }

    @Override
    public boolean supports(Annotation annotation, Class clazz, Member member) {
        Channel channel = annotation.annotationType().getAnnotation(Channel.class);
        return channel != null && channel.identifer().equals(this.getIdentifier());
    }

    protected Map convertProperties(String properties) {
        return (Map)this.converter.convert(properties, this.muleContext);
    }

    protected <T> T lookupConfig(String location, Class<T> type) throws ConfigurationException {
        if (StringUtils.isEmpty((String)location)) {
            return null;
        }
        Object o = this.muleContext.getRegistry().lookupObject(location + ".builder");
        if (o == null && (o = this.muleContext.getRegistry().lookupObject(location)) == null) {
            return null;
        }
        if (type.isInstance(o)) {
            return (T)o;
        }
        throw new ConfigurationException(CoreMessages.objectNotOfCorrectType(o.getClass(), type));
    }

    protected abstract String getIdentifier();

    protected abstract AnnotatedEndpointData createEndpointData(Annotation var1) throws MuleException;
}

