/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parser.specific;

import org.mule.config.annotations.Service;
import org.mule.config.spring.factories.ScopedObjectFactory;
import org.mule.config.spring.parsers.specific.ObjectFactoryDefinitionParser;
import org.mule.util.ClassUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class AnnotatedPojoComponentDefinitionParser
extends ObjectFactoryDefinitionParser {
    public AnnotatedPojoComponentDefinitionParser() {
        super(ScopedObjectFactory.class, "serviceFactory");
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Class serviceClass;
        super.parseChild(element, parserContext, builder);
        String serviceName = ((Element)element.getParentNode()).getAttribute("name");
        builder.addDependsOn(serviceName);
        String temp = element.getAttribute("class");
        try {
            serviceClass = ClassUtils.loadClass((String)temp, ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException("failed to load annotate bean class", (Throwable)e);
        }
        builder.addPropertyValue("objectClass", (Object)serviceClass);
        this.getBeanAssembler(element, builder).extendBean("objectClass", (Object)serviceClass, false);
        if (serviceClass.isAnnotationPresent(Service.class)) {
            Service service = serviceClass.getAnnotation(Service.class);
            builder.addPropertyValue("scope", (Object)service.scope());
        }
    }
}

