/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.errorhandler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.api.MuleException;
import org.mule.example.errorhandler.ErrorMessage;
import org.mule.example.errorhandler.ExceptionHandler;
import org.mule.example.errorhandler.HandlerException;
import org.mule.example.errorhandler.LocaleMessage;
import org.mule.example.errorhandler.handlers.DefaultHandler;
import org.mule.example.errorhandler.handlers.FatalHandler;

public class ErrorManager {
    private static final Log logger = LogFactory.getLog(ErrorManager.class);
    private Map handlers = new HashMap();
    private ExceptionHandler defaultHandler = new DefaultHandler();

    public void setHandlers(List handlers) {
        for (ExceptionHandler handler : handlers) {
            this.addHandler(handler);
        }
    }

    public void addHandler(ExceptionHandler eh) {
        Iterator i = eh.getRegisteredClasses();
        while (i.hasNext()) {
            this.handlers.put(i.next(), eh);
        }
    }

    public ExceptionHandler getHandler(Class exceptionClass) {
        Object obj = this.handlers.get(exceptionClass);
        if (obj == null) {
            obj = this.handlers.get(Throwable.class);
        }
        return (ExceptionHandler)obj;
    }

    public void onException(ErrorMessage msg) throws MuleException {
        Class<?> eClass = null;
        ExceptionHandler eh = null;
        try {
            eClass = msg.getException().toException().getClass();
            eh = this.getHandler(eClass);
            eh.onException(msg);
        }
        catch (Exception e) {
            logger.error((Object)e);
            if (eh instanceof DefaultHandler) {
                logger.error((Object)LocaleMessage.defaultFatalHandling(FatalHandler.class));
                this.handleFatal(e);
            }
            if (eh instanceof FatalHandler) {
                logger.fatal((Object)LocaleMessage.fatalHandling(e));
                MuleServer.getMuleContext().dispose();
                System.exit(-1);
            }
            logger.error((Object)LocaleMessage.defaultHandling(DefaultHandler.class, eh, e));
            this.handleDefault(msg, e);
        }
    }

    private void handleDefault(ErrorMessage msg, Throwable t) {
        ErrorMessage nestedMsg = null;
        try {
            nestedMsg = new ErrorMessage(t);
        }
        catch (Exception e) {
            logger.fatal((Object)LocaleMessage.defaultException(e), (Throwable)e);
            this.handleFatal(e);
        }
        try {
            this.defaultHandler.onException(nestedMsg);
        }
        catch (HandlerException e) {
            logger.fatal((Object)LocaleMessage.defaultHandlerException(e), (Throwable)((Object)e));
            this.handleFatal((Throwable)((Object)e));
        }
    }

    private void handleFatal(Throwable t) {
        logger.fatal((Object)LocaleMessage.fatalException(t), t);
        MuleServer.getMuleContext().dispose();
        System.exit(-1);
    }
}

