/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.errorhandler;

import org.mule.util.ClassUtils;

public class ExceptionBean {
    private static boolean showRootStackOnly = true;
    private String detailMessage;
    private ExceptionBean cause = null;
    private String[] stackTrace;
    private String exceptionClass = null;
    private Throwable originalException = null;

    public ExceptionBean() {
    }

    public ExceptionBean(Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("The exception cannot be null");
        }
        this.originalException = exception;
        this.exceptionClass = exception.getClass().getName();
        this.setDetailMessage(exception.getMessage());
        this.setStackTrace(showRootStackOnly ? null : this.getStackAsString(exception.getStackTrace()));
        if (exception.getCause() != null) {
            this.setCause(new ExceptionBean(exception.getCause()));
        } else {
            this.setStackTrace(exception.getStackTrace());
        }
    }

    public Throwable toException() throws InstantiationException {
        if (this.originalException == null) {
            Throwable t = null;
            try {
                Class aClass = ClassUtils.loadClass((String)this.exceptionClass, this.getClass());
                t = this.cause == null ? (Throwable)ClassUtils.instanciateClass((Class)aClass, (Object[])new Object[]{this.getDetailMessage()}) : (Throwable)ClassUtils.instanciateClass((Class)aClass, (Object[])new Object[]{this.getDetailMessage(), this.cause.toException()});
                if (this.getStackTrace() != null) {
                    // empty if block
                }
                this.originalException = t;
            }
            catch (Exception e) {
                throw new InstantiationException("Failed to create Exception from ExceptionBean: " + e.getMessage());
            }
        }
        return this.originalException;
    }

    public String getDetailMessage() {
        return this.detailMessage;
    }

    public void setDetailMessage(String detailMessage) {
        this.detailMessage = detailMessage;
    }

    public ExceptionBean getCause() {
        return this.cause;
    }

    public void setCause(ExceptionBean cause) {
        this.cause = cause;
    }

    public String[] getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = this.getStackAsString(stackTrace);
    }

    public void setStackTrace(String[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getExceptionClass() {
        return this.exceptionClass;
    }

    public void setExceptionClass(String exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    protected String[] getStackAsString(StackTraceElement[] elements) {
        String[] trace = new String[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            trace[i] = elements[i].toString();
        }
        return trace;
    }
}

