/*
 * Decompiled with CFR 0.152.
 */
package org.mule.samples.errorhandler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.samples.errorhandler.ErrorMessage;
import org.mule.samples.errorhandler.ExceptionHandler;
import org.mule.samples.errorhandler.HandlerException;
import org.mule.samples.errorhandler.handlers.DefaultHandler;
import org.mule.samples.errorhandler.handlers.FatalHandler;
import org.mule.umo.UMOException;

public class ErrorManager {
    private static transient Log logger = LogFactory.getLog((Class)ErrorManager.class);
    private Map handlers = new HashMap();
    private ExceptionHandler defaultHandler = new DefaultHandler();

    public void setHandlers(ExceptionHandler[] eh) {
        for (int i = 0; i < eh.length; ++i) {
            this.addHandler(eh[i]);
        }
    }

    public void addHandler(ExceptionHandler eh) {
        Iterator i = eh.getRegisteredClasses();
        while (i.hasNext()) {
            this.handlers.put(i.next(), eh);
        }
    }

    public ExceptionHandler getHandler(Class exceptionClass) {
        Object obj = this.handlers.get(exceptionClass);
        if (obj == null) {
            obj = this.handlers.get(Throwable.class);
        }
        return (ExceptionHandler)obj;
    }

    public void onException(ErrorMessage msg) throws UMOException {
        Class<?> eClass = null;
        ExceptionHandler eh = null;
        try {
            eClass = msg.getException().toException().getClass();
            eh = this.getHandler(eClass);
            eh.onException(msg);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to handle Exception using handler: " + (eh != null ? eh.getClass().getName() + " : " + e : "null")));
            if (eh instanceof DefaultHandler) {
                logger.error((Object)("As the failure happened in the Default Exception handler, now using Fatal Behaviour " + FatalHandler.class.getName() + " which will cause the Exception Manager to shutdown"));
                this.handleFatal(e);
            }
            if (eh instanceof FatalHandler) {
                logger.fatal((Object)("Exception caught handling Fatal exception: " + e));
                ((MuleManager)MuleManager.getInstance()).shutdown((Throwable)e, false);
            }
            logger.error((Object)("Exception Handler resorting to Default Behaviour : " + DefaultHandler.class.getName() + ", due to exception in configured behavour : " + (eh != null ? eh.getClass().getName() + " : " + e : "null")));
            this.handleDefault(msg, e);
        }
    }

    private void handleDefault(ErrorMessage msg, Throwable t) {
        ErrorMessage nestedMsg = null;
        try {
            nestedMsg = new ErrorMessage(t);
        }
        catch (Exception e) {
            logger.fatal((Object)("Exception happened while handling and exception using the Default behaviour: " + e), (Throwable)e);
            this.handleFatal(e);
        }
        try {
            this.defaultHandler.onException(nestedMsg);
        }
        catch (HandlerException e) {
            logger.fatal((Object)("Exception happened while handling and exception using the Default behaviour: " + (Object)((Object)e)), (Throwable)((Object)e));
            this.handleFatal((Throwable)((Object)e));
        }
    }

    private void handleFatal(Throwable t) {
        logger.fatal((Object)"An exception has been caught be the Fatal Exception Behaviour");
        logger.fatal((Object)("Exception is: " + t), t);
        ((MuleManager)MuleManager.getInstance()).shutdown(t, false);
    }
}

