/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.bookstore.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.example.bookstore.Book;
import org.mule.example.bookstore.Bookstore;
import org.mule.example.bookstore.LocaleMessage;

public class BookstoreClient {
    protected static transient Log logger = LogFactory.getLog(BookstoreClient.class);
    protected static Bookstore bookstore;
    protected MuleContext muleContext;

    public BookstoreClient(String config) throws MuleException {
        this.muleContext = new DefaultMuleContextFactory().createMuleContext(config);
        this.muleContext.start();
        JaxWsProxyFactoryBean pf = new JaxWsProxyFactoryBean();
        pf.setServiceClass(Bookstore.class);
        pf.setAddress("http://localhost:8777/services/bookstore");
        bookstore = (Bookstore)pf.create();
        Book book = new Book(1L, "J.R.R. Tolkien", "The Lord of the Rings");
        bookstore.addBook(book);
    }

    public void close() {
        this.muleContext.dispose();
    }

    public static void main(String[] args) throws Exception {
        new BookstoreClient("bookstore.xml");
        int response = 0;
        System.out.println("\n" + LocaleMessage.getWelcomeMessage());
        while (response != 113) {
            System.out.println("\n" + LocaleMessage.getMenuOption1());
            System.out.println("\n" + LocaleMessage.getMenuOption2());
            System.out.println("\n" + LocaleMessage.getMenuOption3());
            System.out.println("\n" + LocaleMessage.getMenuOption4());
            System.out.println("\n" + LocaleMessage.getMenuOptionQuit());
            System.out.println("\n" + LocaleMessage.getMenuPromptMessage());
            response = BookstoreClient.getSelection();
            if (response == 49) {
                Book book = BookstoreClient.createBook();
                bookstore.addBook(book);
                System.out.println("Added Book");
                continue;
            }
            if (response == 50) {
                ArrayList<Book> books = new ArrayList<Book>();
                boolean isAddAnotherBook = true;
                while (isAddAnotherBook) {
                    Book book = BookstoreClient.createBook();
                    books.add(book);
                    System.out.println("\n" + LocaleMessage.getAddBooksMessagePrompt());
                    int result = BookstoreClient.getSelection();
                    if (result == 121) continue;
                    isAddAnotherBook = false;
                    bookstore.addBooks(books);
                    System.out.println("Added book list");
                }
                continue;
            }
            if (response == 51) {
                Collection<Book> books = bookstore.getBooks();
                System.out.println("Request returned " + books.size() + " book/s");
                for (Book book : books) {
                    System.out.println("Title: " + book.getTitle());
                    System.out.println("Author: " + book.getAuthor());
                    System.out.println("Id: " + book.getId());
                    System.out.println();
                }
                continue;
            }
            if (response == 52) {
                System.out.println("\n" + LocaleMessage.getOrderWelcomeMessage());
                System.out.println("\n" + LocaleMessage.getBookIdPrompt());
                long bookId = new Integer(BookstoreClient.getInput()).intValue();
                System.out.println("\n" + LocaleMessage.getHomeAddressPrompt());
                String homeAddress = BookstoreClient.getInput();
                System.out.println("\n" + LocaleMessage.getEmailAddressPrompt());
                String emailAddress = BookstoreClient.getInput();
                bookstore.orderBook(bookId, homeAddress, emailAddress);
                System.out.println("Book was ordered");
                continue;
            }
            if (response == 113) {
                System.out.println(LocaleMessage.getGoodbyeMessage());
                System.exit(0);
                continue;
            }
            System.out.println(LocaleMessage.getMenuErrorMessage());
        }
    }

    private static Book createBook() throws Exception {
        String title = "";
        String author = "";
        while (title.compareTo("") == 0) {
            System.out.println("\n" + LocaleMessage.getBookTitlePrompt());
            title = BookstoreClient.getInput();
        }
        while (author.compareTo("") == 0) {
            System.out.println("\n" + LocaleMessage.getAuthorNamePrompt());
            author = BookstoreClient.getInput();
        }
        return new Book(BookstoreClient.generateBookId(), title, author);
    }

    private static int getSelection() throws IOException {
        byte[] buf = new byte[16];
        System.in.read(buf);
        return buf[0];
    }

    private static String getInput() throws IOException {
        BufferedReader request = new BufferedReader(new InputStreamReader(System.in));
        return request.readLine();
    }

    private static long generateBookId() {
        Random randomGenerator = new Random();
        return randomGenerator.nextInt(5000);
    }
}

