/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import org.msgpack.jackson.dataformat.MessagePackGenerator;

@JsonSerialize(using=Serializer.class)
public class MessagePackExtensionType {
    private final byte type;
    private final byte[] data;

    public MessagePackExtensionType(byte by, byte[] byArray) {
        this.type = by;
        this.data = byArray;
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public static class Serializer
    extends JsonSerializer<MessagePackExtensionType> {
        public void serialize(MessagePackExtensionType messagePackExtensionType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (!(jsonGenerator instanceof MessagePackGenerator)) {
                throw new IllegalStateException("'gen' is expected to be MessagePackGenerator but it's " + jsonGenerator.getClass());
            }
            MessagePackGenerator messagePackGenerator = (MessagePackGenerator)jsonGenerator;
            messagePackGenerator.writeExtensionType(messagePackExtensionType);
        }
    }
}

