/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.DupDetector;
import com.fasterxml.jackson.core.json.JsonReadContext;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.InputStreamBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;
import org.msgpack.jackson.dataformat.Tuple;
import org.msgpack.value.ExtensionValue;
import org.msgpack.value.IntegerValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;
import org.msgpack.value.Variable;

public class MessagePackParser
extends ParserMinimalBase {
    private static final ThreadLocal<Tuple<Object, MessageUnpacker>> messageUnpackerHolder = new ThreadLocal();
    private ObjectCodec codec;
    private JsonReadContext parsingContext;
    private final LinkedList<StackItem> stack = new LinkedList();
    private Value value = ValueFactory.newNil();
    private Variable var = new Variable();
    private boolean isClosed;
    private long tokenPosition;
    private long currentPosition;
    private final IOContext ioContext;

    public MessagePackParser(IOContext iOContext, int n, ObjectCodec objectCodec, InputStream inputStream) throws IOException {
        this(iOContext, n, (MessageBufferInput)new InputStreamBufferInput(inputStream), objectCodec, inputStream);
    }

    public MessagePackParser(IOContext iOContext, int n, ObjectCodec objectCodec, byte[] byArray) throws IOException {
        this(iOContext, n, (MessageBufferInput)new ArrayBufferInput(byArray), objectCodec, byArray);
    }

    private MessagePackParser(IOContext iOContext, int n, MessageBufferInput messageBufferInput, ObjectCodec objectCodec, Object object) throws IOException {
        super(n);
        MessageUnpacker messageUnpacker;
        this.codec = objectCodec;
        this.ioContext = iOContext;
        DupDetector dupDetector = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n) ? DupDetector.rootDetector((JsonParser)this) : null;
        this.parsingContext = JsonReadContext.createRootContext((DupDetector)dupDetector);
        Tuple<Object, MessageUnpacker> tuple = messageUnpackerHolder.get();
        if (tuple == null) {
            messageUnpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)messageBufferInput);
        } else {
            if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE) || tuple.first() != object) {
                tuple.second().reset(messageBufferInput);
            }
            messageUnpacker = tuple.second();
        }
        messageUnpackerHolder.set(new Tuple<Object, MessageUnpacker>(object, messageUnpacker));
    }

    public ObjectCodec getCodec() {
        return this.codec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this.codec = objectCodec;
    }

    public Version version() {
        return null;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        MessageUnpacker messageUnpacker = this.getMessageUnpacker();
        this.tokenPosition = messageUnpacker.getTotalReadBytes();
        JsonToken jsonToken = null;
        if ((this.parsingContext.inObject() || this.parsingContext.inArray()) && this.stack.getFirst().isEmpty()) {
            this.stack.pop();
            this._currToken = this.parsingContext.inObject() ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
            this.parsingContext = this.parsingContext.getParent();
            return this._currToken;
        }
        if (!messageUnpacker.hasNext()) {
            return null;
        }
        ValueType valueType = messageUnpacker.getNextFormat().getValueType();
        StackItem stackItem = null;
        switch (valueType) {
            case NIL: {
                messageUnpacker.unpackNil();
                this.value = ValueFactory.newNil();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case BOOLEAN: {
                boolean bl = messageUnpacker.unpackBoolean();
                this.value = ValueFactory.newNil();
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(Boolean.toString(bl));
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = bl ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
                break;
            }
            case INTEGER: {
                this.value = messageUnpacker.unpackValue(this.var);
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(this.value.asIntegerValue().toString());
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case FLOAT: {
                this.value = messageUnpacker.unpackValue(this.var);
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(this.value.asFloatValue().toString());
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case STRING: {
                this.value = messageUnpacker.unpackValue(this.var);
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(this.value.asRawValue().toString());
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_STRING;
                break;
            }
            case BINARY: {
                this.value = messageUnpacker.unpackValue(this.var);
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(this.value.asRawValue().toString());
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                break;
            }
            case ARRAY: {
                this.value = ValueFactory.newNil();
                stackItem = new StackItemForArray(messageUnpacker.unpackArrayHeader());
                break;
            }
            case MAP: {
                this.value = ValueFactory.newNil();
                stackItem = new StackItemForObject(messageUnpacker.unpackMapHeader());
                break;
            }
            case EXTENSION: {
                this.value = messageUnpacker.unpackValue(this.var);
                jsonToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                break;
            }
            default: {
                throw new IllegalStateException("Shouldn't reach here");
            }
        }
        this.currentPosition = messageUnpacker.getTotalReadBytes();
        if (this.parsingContext.inObject() && jsonToken != JsonToken.FIELD_NAME || this.parsingContext.inArray()) {
            this.stack.getFirst().consume();
        }
        if (stackItem != null) {
            this.stack.push(stackItem);
            if (stackItem instanceof StackItemForArray) {
                jsonToken = JsonToken.START_ARRAY;
                this.parsingContext = this.parsingContext.createChildArrayContext(-1, -1);
            } else if (stackItem instanceof StackItemForObject) {
                jsonToken = JsonToken.START_OBJECT;
                this.parsingContext = this.parsingContext.createChildObjectContext(-1, -1);
            }
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    protected void _handleEOF() throws JsonParseException {
    }

    public String getText() throws IOException, JsonParseException {
        if (this.value.isRawValue()) {
            return this.value.asRawValue().toString();
        }
        return this.value.toString();
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this.getText().toCharArray();
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public int getTextLength() throws IOException, JsonParseException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        return this.value.asRawValue().asByteArray();
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        if (this.value.isIntegerValue()) {
            IntegerValue integerValue = this.value.asIntegerValue();
            if (integerValue.isInIntRange()) {
                return integerValue.toInt();
            }
            if (integerValue.isInLongRange()) {
                return integerValue.toLong();
            }
            return integerValue.toBigInteger();
        }
        return this.value.asNumberValue().toDouble();
    }

    public int getIntValue() throws IOException, JsonParseException {
        return this.value.asNumberValue().toInt();
    }

    public long getLongValue() throws IOException, JsonParseException {
        return this.value.asNumberValue().toLong();
    }

    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        return this.value.asNumberValue().toBigInteger();
    }

    public float getFloatValue() throws IOException, JsonParseException {
        return this.value.asNumberValue().toFloat();
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        return this.value.asNumberValue().toDouble();
    }

    public BigDecimal getDecimalValue() throws IOException {
        if (this.value.isIntegerValue()) {
            IntegerValue integerValue = this.value.asIntegerValue();
            if (integerValue.isInLongRange()) {
                return BigDecimal.valueOf(integerValue.toLong());
            }
            return new BigDecimal(integerValue.toBigInteger());
        }
        if (this.value.isFloatValue()) {
            return BigDecimal.valueOf(this.value.asFloatValue().toDouble());
        }
        throw new UnsupportedOperationException("Couldn't parse value as BigDecimal. " + this.value);
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        if (this.value.isBinaryValue()) {
            return this.value.asBinaryValue().asByteArray();
        }
        if (this.value.isExtensionValue()) {
            ExtensionValue extensionValue = this.value.asExtensionValue();
            return new MessagePackExtensionType(extensionValue.getType(), extensionValue.getData());
        }
        throw new UnsupportedOperationException();
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        if (this.value.isIntegerValue()) {
            IntegerValue integerValue = this.value.asIntegerValue();
            if (integerValue.isInIntRange()) {
                return JsonParser.NumberType.INT;
            }
            if (integerValue.isInLongRange()) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        this.value.asNumberValue();
        return JsonParser.NumberType.DOUBLE;
    }

    public void close() throws IOException {
        try {
            if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                MessageUnpacker messageUnpacker = this.getMessageUnpacker();
                messageUnpacker.close();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public JsonStreamContext getParsingContext() {
        return this.parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return new JsonLocation(this.ioContext.getSourceReference(), this.tokenPosition, -1L, -1, (int)this.tokenPosition);
    }

    public JsonLocation getCurrentLocation() {
        return new JsonLocation(this.ioContext.getSourceReference(), this.currentPosition, -1L, -1, (int)this.currentPosition);
    }

    public void overrideCurrentName(String string) {
        try {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                JsonReadContext jsonReadContext = this.parsingContext.getParent();
                jsonReadContext.setCurrentName(string);
            } else {
                this.parsingContext.setCurrentName(string);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalStateException(jsonProcessingException);
        }
    }

    public String getCurrentName() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            JsonReadContext jsonReadContext = this.parsingContext.getParent();
            return jsonReadContext.getCurrentName();
        }
        return this.parsingContext.getCurrentName();
    }

    private MessageUnpacker getMessageUnpacker() {
        Tuple<Object, MessageUnpacker> tuple = messageUnpackerHolder.get();
        if (tuple == null) {
            throw new IllegalStateException("messageUnpacker is null");
        }
        return tuple.second();
    }

    private static class StackItemForArray
    extends StackItem {
        StackItemForArray(long l) {
            super(l);
        }
    }

    private static class StackItemForObject
    extends StackItem {
        StackItemForObject(long l) {
            super(l);
        }
    }

    private static abstract class StackItem {
        private long numOfElements;

        protected StackItem(long l) {
            this.numOfElements = l;
        }

        public void consume() {
            --this.numOfElements;
        }

        public boolean isEmpty() {
            return this.numOfElements == 0L;
        }
    }
}

