/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import org.mp4parser.streaming.SampleExtension;
import org.mp4parser.streaming.StreamingSample;

public class StreamingSampleImpl
implements StreamingSample {
    private ByteBuffer s;
    private long duration;
    private HashMap<Class<? extends SampleExtension>, SampleExtension> sampleExtensions = new HashMap();

    public StreamingSampleImpl(ByteBuffer s, long duration) {
        this.s = s.duplicate();
        this.duration = duration;
    }

    public StreamingSampleImpl(byte[] sample, long duration) {
        this.duration = duration;
        this.s = ByteBuffer.wrap(sample);
    }

    public StreamingSampleImpl(List<ByteBuffer> nals, long duration) {
        this.duration = duration;
        int size = 0;
        for (ByteBuffer nal : nals) {
            size += 4;
            size += nal.limit();
        }
        this.s = ByteBuffer.allocate(size);
        for (ByteBuffer nal : nals) {
            this.s.put((byte)((nal.limit() & 0xFF000000) >> 24));
            this.s.put((byte)((nal.limit() & 0xFF0000) >> 16));
            this.s.put((byte)((nal.limit() & 0xFF00) >> 8));
            this.s.put((byte)(nal.limit() & 0xFF));
            this.s.put((ByteBuffer)((Buffer)nal).rewind());
        }
    }

    @Override
    public ByteBuffer getContent() {
        return this.s;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public <T extends SampleExtension> T getSampleExtension(Class<T> clazz) {
        return (T)this.sampleExtensions.get(clazz);
    }

    @Override
    public void addSampleExtension(SampleExtension sampleExtension) {
        this.sampleExtensions.put(sampleExtension.getClass(), sampleExtension);
    }

    @Override
    public <T extends SampleExtension> T removeSampleExtension(Class<T> clazz) {
        return (T)this.sampleExtensions.remove(clazz);
    }
}

