/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.output.mp4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mp4parser.Box;
import org.mp4parser.IsoFile;
import org.mp4parser.boxes.iso14496.part12.MediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.boxes.iso14496.part12.MovieExtendsBox;
import org.mp4parser.boxes.iso14496.part12.MovieExtendsHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentRandomAccessBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentRandomAccessOffsetBox;
import org.mp4parser.boxes.iso14496.part12.MovieHeaderBox;
import org.mp4parser.boxes.iso14496.part12.SampleFlags;
import org.mp4parser.boxes.iso14496.part12.TrackExtendsBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentBaseMediaDecodeTimeBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentHeaderBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox;
import org.mp4parser.boxes.iso14496.part12.TrackRunBox;
import org.mp4parser.streaming.StreamingSample;
import org.mp4parser.streaming.StreamingTrack;
import org.mp4parser.streaming.extensions.CencEncryptTrackExtension;
import org.mp4parser.streaming.extensions.CompositionTimeSampleExtension;
import org.mp4parser.streaming.extensions.CompositionTimeTrackExtension;
import org.mp4parser.streaming.extensions.DefaultSampleFlagsTrackExtension;
import org.mp4parser.streaming.extensions.SampleFlagsSampleExtension;
import org.mp4parser.streaming.extensions.TrackIdTrackExtension;
import org.mp4parser.streaming.output.SampleSink;
import org.mp4parser.streaming.output.mp4.DefaultBoxes;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeWriter;
import org.mp4parser.tools.Mp4Arrays;
import org.mp4parser.tools.Mp4Math;

public class FragmentedMp4Writer
extends DefaultBoxes
implements SampleSink {
    public static final Object OBJ = new Object();
    private static final Logger LOG = Logger.getLogger(FragmentedMp4Writer.class.getName());
    protected final WritableByteChannel sink;
    protected List<StreamingTrack> source;
    protected Date creationTime;
    protected long sequenceNumber = 1L;
    protected Map<StreamingTrack, CountDownLatch> congestionControl = new ConcurrentHashMap<StreamingTrack, CountDownLatch>();
    protected Map<StreamingTrack, Long> nextFragmentCreateStartTime = new ConcurrentHashMap<StreamingTrack, Long>();
    protected Map<StreamingTrack, Long> nextFragmentWriteStartTime = new ConcurrentHashMap<StreamingTrack, Long>();
    protected Map<StreamingTrack, Long> nextSampleStartTime = new HashMap<StreamingTrack, Long>();
    protected Map<StreamingTrack, List<StreamingSample>> sampleBuffers = new HashMap<StreamingTrack, List<StreamingSample>>();
    protected Map<StreamingTrack, Queue<FragmentContainer>> fragmentBuffers = new ConcurrentHashMap<StreamingTrack, Queue<FragmentContainer>>();
    protected Map<StreamingTrack, long[]> tfraOffsets = new HashMap<StreamingTrack, long[]>();
    protected Map<StreamingTrack, long[]> tfraTimes = new HashMap<StreamingTrack, long[]>();
    long bytesWritten = 0L;
    volatile boolean headerWritten = false;

    public FragmentedMp4Writer(List<StreamingTrack> source, WritableByteChannel sink) throws IOException {
        this.source = new LinkedList<StreamingTrack>(source);
        this.sink = sink;
        this.creationTime = new Date();
        HashSet<Long> trackIds = new HashSet<Long>();
        for (StreamingTrack streamingTrack : source) {
            streamingTrack.setSampleSink(this);
            this.sampleBuffers.put(streamingTrack, new ArrayList());
            this.fragmentBuffers.put(streamingTrack, new LinkedList());
            this.nextFragmentCreateStartTime.put(streamingTrack, 0L);
            this.nextFragmentWriteStartTime.put(streamingTrack, 0L);
            this.nextSampleStartTime.put(streamingTrack, 0L);
            this.congestionControl.put(streamingTrack, new CountDownLatch(0));
            if (streamingTrack.getTrackExtension(TrackIdTrackExtension.class) == null) continue;
            TrackIdTrackExtension trackIdTrackExtension = streamingTrack.getTrackExtension(TrackIdTrackExtension.class);
            assert (trackIdTrackExtension != null);
            if (!trackIds.contains(trackIdTrackExtension.getTrackId())) continue;
            throw new IOException("There may not be two tracks with the same trackID within one file");
        }
        for (StreamingTrack streamingTrack : source) {
            if (streamingTrack.getTrackExtension(TrackIdTrackExtension.class) != null) continue;
            long maxTrackId = 0L;
            for (Long trackId : trackIds) {
                maxTrackId = Math.max(trackId, maxTrackId);
            }
            TrackIdTrackExtension tiExt = new TrackIdTrackExtension(maxTrackId + 1L);
            trackIds.add(tiExt.getTrackId());
            streamingTrack.addTrackExtension(tiExt);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        for (StreamingTrack streamingTrack : this.source) {
            this.writeFragment(this.createFragment(streamingTrack, this.sampleBuffers.get(streamingTrack)));
            streamingTrack.close();
        }
        this.writeFooter(this.createFooter());
    }

    protected void write(WritableByteChannel out, Box ... boxes) throws IOException {
        for (Box box1 : boxes) {
            box1.getBox(out);
            this.bytesWritten += box1.getSize();
        }
    }

    @Override
    protected Box createMdhd(StreamingTrack streamingTrack) {
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(this.creationTime);
        mdhd.setModificationTime(this.creationTime);
        mdhd.setDuration(0L);
        mdhd.setTimescale(streamingTrack.getTimescale());
        mdhd.setLanguage(streamingTrack.getLanguage());
        return mdhd;
    }

    protected Box createMvex() {
        MovieExtendsBox mvex = new MovieExtendsBox();
        MovieExtendsHeaderBox mved = new MovieExtendsHeaderBox();
        mved.setVersion(1);
        mved.setFragmentDuration(0L);
        mvex.addBox((Box)mved);
        for (StreamingTrack streamingTrack : this.source) {
            mvex.addBox(this.createTrex(streamingTrack));
        }
        return mvex;
    }

    protected Box createTrex(StreamingTrack streamingTrack) {
        TrackExtendsBox trex = new TrackExtendsBox();
        trex.setTrackId(streamingTrack.getTrackExtension(TrackIdTrackExtension.class).getTrackId());
        trex.setDefaultSampleDescriptionIndex(1L);
        trex.setDefaultSampleDuration(0L);
        trex.setDefaultSampleSize(0L);
        SampleFlags sf = new SampleFlags();
        trex.setDefaultSampleFlags(sf);
        return trex;
    }

    @Override
    protected Box createMvhd() {
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setVersion(1);
        mvhd.setCreationTime(this.creationTime);
        mvhd.setModificationTime(this.creationTime);
        mvhd.setDuration(0L);
        long[] timescales = new long[]{};
        long maxTrackId = 0L;
        for (StreamingTrack streamingTrack : this.source) {
            timescales = Mp4Arrays.copyOfAndAppend((long[])timescales, (long[])new long[]{streamingTrack.getTimescale()});
            maxTrackId = Math.max(streamingTrack.getTrackExtension(TrackIdTrackExtension.class).getTrackId(), maxTrackId);
        }
        mvhd.setTimescale(Mp4Math.lcm((long[])timescales));
        mvhd.setNextTrackId(maxTrackId + 1L);
        return mvhd;
    }

    protected Box createMoov() {
        MovieBox movieBox = new MovieBox();
        movieBox.addBox(this.createMvhd());
        for (StreamingTrack streamingTrack : this.source) {
            movieBox.addBox(this.createTrak(streamingTrack));
        }
        movieBox.addBox(this.createMvex());
        return movieBox;
    }

    protected Box[] createHeader() {
        return new Box[]{this.createFtyp(), this.createMoov()};
    }

    private void sortTracks() {
        Collections.sort(this.source, new Comparator<StreamingTrack>(){

            @Override
            public int compare(StreamingTrack o1, StreamingTrack o2) {
                long a = FragmentedMp4Writer.this.nextFragmentWriteStartTime.get(o1) * o2.getTimescale();
                long b = FragmentedMp4Writer.this.nextFragmentWriteStartTime.get(o2) * o1.getTimescale();
                double d = Math.signum(a - b);
                return (int)d;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptSample(StreamingSample streamingSample, StreamingTrack streamingTrack) throws IOException {
        Object object = OBJ;
        synchronized (object) {
            if (!this.headerWritten) {
                boolean allTracksAtLeastOneSample = true;
                for (StreamingTrack track : this.source) {
                    allTracksAtLeastOneSample &= this.nextSampleStartTime.get(track) > 0L || track == streamingTrack;
                }
                if (allTracksAtLeastOneSample) {
                    this.writeHeader(this.createHeader());
                    this.headerWritten = true;
                }
            }
        }
        try {
            CountDownLatch cdl = this.congestionControl.get(streamingTrack);
            if (cdl.getCount() > 0L) {
                cdl.await();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.isFragmentReady(streamingTrack, streamingSample)) {
            FragmentContainer fragmentContainer = this.createFragmentContainer(streamingTrack);
            this.sampleBuffers.get(streamingTrack).clear();
            this.nextFragmentCreateStartTime.put(streamingTrack, this.nextFragmentCreateStartTime.get(streamingTrack) + fragmentContainer.duration);
            Queue<FragmentContainer> fragmentQueue = this.fragmentBuffers.get(streamingTrack);
            fragmentQueue.add(fragmentContainer);
            Object object2 = OBJ;
            synchronized (object2) {
                if (this.headerWritten && this.source.get(0) == streamingTrack) {
                    StreamingTrack currentStreamingTrack;
                    Queue<FragmentContainer> tracksFragmentQueue;
                    while (!(tracksFragmentQueue = this.fragmentBuffers.get(currentStreamingTrack = this.source.get(0))).isEmpty()) {
                        FragmentContainer currentFragmentContainer = tracksFragmentQueue.remove();
                        this.writeFragment(currentFragmentContainer.fragmentContent);
                        this.congestionControl.get(currentStreamingTrack).countDown();
                        long ts = this.nextFragmentWriteStartTime.get(currentStreamingTrack) + currentFragmentContainer.duration;
                        this.nextFragmentWriteStartTime.put(currentStreamingTrack, ts);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine(currentStreamingTrack + " advanced to " + (double)ts / (double)currentStreamingTrack.getTimescale());
                        }
                        this.sortTracks();
                    }
                } else if (fragmentQueue.size() > 10) {
                    this.congestionControl.put(streamingTrack, new CountDownLatch(fragmentQueue.size()));
                }
            }
        }
        this.sampleBuffers.get(streamingTrack).add(streamingSample);
        this.nextSampleStartTime.put(streamingTrack, this.nextSampleStartTime.get(streamingTrack) + streamingSample.getDuration());
    }

    protected boolean isFragmentReady(StreamingTrack streamingTrack, StreamingSample next) {
        SampleFlagsSampleExtension sfExt;
        long cfst;
        long ts = this.nextSampleStartTime.get(streamingTrack);
        return ts > (cfst = this.nextFragmentCreateStartTime.get(streamingTrack).longValue()) + 3L * streamingTrack.getTimescale() && ((sfExt = next.getSampleExtension(SampleFlagsSampleExtension.class)) == null || sfExt.isSyncSample());
    }

    protected Box[] createFragment(StreamingTrack streamingTrack, List<StreamingSample> samples) {
        this.nextFragmentCreateStartTime.get(streamingTrack);
        this.tfraOffsets.put(streamingTrack, Mp4Arrays.copyOfAndAppend((long[])this.tfraOffsets.get(streamingTrack), (long[])new long[]{this.bytesWritten}));
        this.tfraTimes.put(streamingTrack, Mp4Arrays.copyOfAndAppend((long[])this.tfraTimes.get(streamingTrack), (long[])new long[]{this.nextFragmentCreateStartTime.get(streamingTrack)}));
        LOG.finest("Container created");
        Box moof = this.createMoof(streamingTrack, samples);
        LOG.finest("moof created");
        Box mdat = this.createMdat(samples);
        LOG.finest("mdat created");
        if (LOG.isLoggable(Level.FINE)) {
            double duration = this.nextSampleStartTime.get(streamingTrack) - this.nextFragmentCreateStartTime.get(streamingTrack);
            LOG.fine("created fragment for " + streamingTrack + " of " + duration / (double)streamingTrack.getTimescale() + " seconds");
        }
        return new Box[]{moof, mdat};
    }

    private FragmentContainer createFragmentContainer(StreamingTrack streamingTrack) {
        FragmentContainer fragmentContainer = new FragmentContainer();
        ArrayList<StreamingSample> samples = new ArrayList<StreamingSample>((Collection)this.sampleBuffers.get(streamingTrack));
        fragmentContainer.fragmentContent = this.createFragment(streamingTrack, samples);
        fragmentContainer.duration = this.nextSampleStartTime.get(streamingTrack) - this.nextFragmentCreateStartTime.get(streamingTrack);
        return fragmentContainer;
    }

    protected void writeHeader(Box ... boxes) throws IOException {
        this.write(this.sink, boxes);
    }

    protected void writeFragment(Box ... boxes) throws IOException {
        this.write(this.sink, boxes);
    }

    protected void writeFooter(Box ... boxes) throws IOException {
        this.write(this.sink, boxes);
    }

    private Box createMoof(StreamingTrack streamingTrack, List<StreamingSample> samples) {
        MovieFragmentBox moof = new MovieFragmentBox();
        this.createMfhd(this.sequenceNumber, moof);
        this.createTraf(streamingTrack, moof, samples);
        TrackRunBox firstTrun = (TrackRunBox)moof.getTrackRunBoxes().get(0);
        firstTrun.setDataOffset(1);
        firstTrun.setDataOffset((int)(8L + moof.getSize()));
        return moof;
    }

    protected void createTfhd(StreamingTrack streamingTrack, TrackFragmentBox parent) {
        TrackFragmentHeaderBox tfhd = new TrackFragmentHeaderBox();
        SampleFlags sf = new SampleFlags();
        DefaultSampleFlagsTrackExtension defaultSampleFlagsTrackExtension = streamingTrack.getTrackExtension(DefaultSampleFlagsTrackExtension.class);
        if (defaultSampleFlagsTrackExtension != null) {
            sf.setIsLeading(defaultSampleFlagsTrackExtension.getIsLeading());
            sf.setSampleIsDependedOn((int)defaultSampleFlagsTrackExtension.getSampleIsDependedOn());
            sf.setSampleDependsOn((int)defaultSampleFlagsTrackExtension.getSampleDependsOn());
            sf.setSampleHasRedundancy((int)defaultSampleFlagsTrackExtension.getSampleHasRedundancy());
            sf.setSampleIsDifferenceSample(defaultSampleFlagsTrackExtension.isSampleIsNonSyncSample());
            sf.setSamplePaddingValue((int)defaultSampleFlagsTrackExtension.getSamplePaddingValue());
            sf.setSampleDegradationPriority(defaultSampleFlagsTrackExtension.getSampleDegradationPriority());
        }
        tfhd.setDefaultSampleFlags(sf);
        tfhd.setBaseDataOffset(-1L);
        tfhd.setTrackId(streamingTrack.getTrackExtension(TrackIdTrackExtension.class).getTrackId());
        tfhd.setDefaultBaseIsMoof(true);
        parent.addBox((Box)tfhd);
    }

    protected void createTfdt(StreamingTrack streamingTrack, TrackFragmentBox parent) {
        TrackFragmentBaseMediaDecodeTimeBox tfdt = new TrackFragmentBaseMediaDecodeTimeBox();
        tfdt.setVersion(1);
        tfdt.setBaseMediaDecodeTime(this.nextFragmentCreateStartTime.get(streamingTrack).longValue());
        parent.addBox((Box)tfdt);
    }

    protected void createTrun(StreamingTrack streamingTrack, TrackFragmentBox parent, List<StreamingSample> samples) {
        TrackRunBox trun = new TrackRunBox();
        trun.setVersion(1);
        trun.setSampleDurationPresent(true);
        trun.setSampleSizePresent(true);
        ArrayList<TrackRunBox.Entry> entries = new ArrayList<TrackRunBox.Entry>(samples.size());
        trun.setSampleCompositionTimeOffsetPresent(streamingTrack.getTrackExtension(CompositionTimeTrackExtension.class) != null);
        DefaultSampleFlagsTrackExtension defaultSampleFlagsTrackExtension = streamingTrack.getTrackExtension(DefaultSampleFlagsTrackExtension.class);
        trun.setSampleFlagsPresent(defaultSampleFlagsTrackExtension == null);
        for (StreamingSample streamingSample : samples) {
            TrackRunBox.Entry entry = new TrackRunBox.Entry();
            entry.setSampleSize((long)streamingSample.getContent().remaining());
            if (defaultSampleFlagsTrackExtension == null) {
                SampleFlagsSampleExtension sampleFlagsSampleExtension = streamingSample.getSampleExtension(SampleFlagsSampleExtension.class);
                assert (sampleFlagsSampleExtension != null) : "SampleDependencySampleExtension missing even though SampleDependencyTrackExtension was present";
                SampleFlags sflags = new SampleFlags();
                sflags.setIsLeading(sampleFlagsSampleExtension.getIsLeading());
                sflags.setSampleIsDependedOn((int)sampleFlagsSampleExtension.getSampleIsDependedOn());
                sflags.setSampleDependsOn((int)sampleFlagsSampleExtension.getSampleDependsOn());
                sflags.setSampleHasRedundancy((int)sampleFlagsSampleExtension.getSampleHasRedundancy());
                sflags.setSampleIsDifferenceSample(sampleFlagsSampleExtension.isSampleIsNonSyncSample());
                sflags.setSamplePaddingValue((int)sampleFlagsSampleExtension.getSamplePaddingValue());
                sflags.setSampleDegradationPriority(sampleFlagsSampleExtension.getSampleDegradationPriority());
                entry.setSampleFlags(sflags);
            }
            entry.setSampleDuration(streamingSample.getDuration());
            if (trun.isSampleCompositionTimeOffsetPresent()) {
                CompositionTimeSampleExtension compositionTimeSampleExtension = streamingSample.getSampleExtension(CompositionTimeSampleExtension.class);
                assert (compositionTimeSampleExtension != null) : "CompositionTimeSampleExtension missing even though CompositionTimeTrackExtension was present";
                entry.setSampleCompositionTimeOffset(CastUtils.l2i((long)compositionTimeSampleExtension.getCompositionTimeOffset()));
            }
            entries.add(entry);
        }
        trun.setEntries(entries);
        parent.addBox((Box)trun);
    }

    private void createTraf(StreamingTrack streamingTrack, MovieFragmentBox moof, List<StreamingSample> samples) {
        TrackFragmentBox traf = new TrackFragmentBox();
        moof.addBox((Box)traf);
        this.createTfhd(streamingTrack, traf);
        this.createTfdt(streamingTrack, traf);
        this.createTrun(streamingTrack, traf, samples);
        if (streamingTrack.getTrackExtension(CencEncryptTrackExtension.class) != null) {
            // empty if block
        }
    }

    protected Box[] createFooter() {
        MovieFragmentRandomAccessBox mfra = new MovieFragmentRandomAccessBox();
        for (StreamingTrack track : this.source) {
            mfra.addBox(this.createTfra(track));
        }
        MovieFragmentRandomAccessOffsetBox mfro = new MovieFragmentRandomAccessOffsetBox();
        mfra.addBox((Box)mfro);
        mfro.setMfraSize(mfra.getSize());
        return new Box[]{mfra};
    }

    protected Box createTfra(StreamingTrack track) {
        TrackFragmentRandomAccessBox tfra = new TrackFragmentRandomAccessBox();
        tfra.setVersion(1);
        long[] offsets = this.tfraOffsets.get(track);
        long[] times = this.tfraTimes.get(track);
        ArrayList<TrackFragmentRandomAccessBox.Entry> entries = new ArrayList<TrackFragmentRandomAccessBox.Entry>(times.length);
        for (int i = 0; i < times.length; ++i) {
            entries.add(new TrackFragmentRandomAccessBox.Entry(times[i], offsets[i], 1L, 1L, 1L));
        }
        tfra.setEntries(entries);
        tfra.setTrackId(track.getTrackExtension(TrackIdTrackExtension.class).getTrackId());
        return tfra;
    }

    private void createMfhd(long sequenceNumber, MovieFragmentBox moof) {
        MovieFragmentHeaderBox mfhd = new MovieFragmentHeaderBox();
        mfhd.setSequenceNumber(sequenceNumber);
        moof.addBox((Box)mfhd);
    }

    private Box createMdat(final List<StreamingSample> samples) {
        return new Box(){

            public String getType() {
                return "mdat";
            }

            public long getSize() {
                long l = 8L;
                for (StreamingSample streamingSample : samples) {
                    l += (long)streamingSample.getContent().limit();
                }
                return l;
            }

            public void getBox(WritableByteChannel writableByteChannel) throws IOException {
                long l = 8L;
                for (StreamingSample streamingSample : samples) {
                    ByteBuffer sampleContent = streamingSample.getContent();
                    l += (long)sampleContent.limit();
                }
                ByteBuffer bb = ByteBuffer.allocate(8);
                IsoTypeWriter.writeUInt32((ByteBuffer)bb, (long)l);
                bb.put(IsoFile.fourCCtoBytes((String)this.getType()));
                writableByteChannel.write((ByteBuffer)bb.rewind());
                for (StreamingSample streamingSample : samples) {
                    writableByteChannel.write((ByteBuffer)streamingSample.getContent().rewind());
                }
            }
        };
    }

    public class FragmentContainer {
        Box[] fragmentContent;
        long duration;
    }
}

