/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input.h264.spspps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mp4parser.streaming.input.h264.spspps.ByteBufferBitreader;
import org.mp4parser.streaming.input.h264.spspps.PictureParameterSet;
import org.mp4parser.streaming.input.h264.spspps.SeqParameterSet;

public class SliceHeader {
    public int first_mb_in_slice;
    public SliceType slice_type;
    public int pic_parameter_set_id;
    public int colour_plane_id;
    public int frame_num;
    public boolean field_pic_flag = false;
    public boolean bottom_field_flag = false;
    public int idr_pic_id = -1;
    public int pic_order_cnt_lsb;
    public int delta_pic_order_cnt_bottom;
    public int delta_pic_order_cnt_0;
    public int delta_pic_order_cnt_1;
    public PictureParameterSet pps;
    public SeqParameterSet sps;

    public SliceHeader(ByteBuffer in, Map<Integer, SeqParameterSet> spss, Map<Integer, PictureParameterSet> ppss, boolean IdrPicFlag) {
        try {
            in.position(1);
            ByteBufferBitreader reader = new ByteBufferBitreader(in);
            this.first_mb_in_slice = reader.readUE();
            int sliceTypeInt = reader.readUE();
            switch (sliceTypeInt) {
                case 0: 
                case 5: {
                    this.slice_type = SliceType.P;
                    break;
                }
                case 1: 
                case 6: {
                    this.slice_type = SliceType.B;
                    break;
                }
                case 2: 
                case 7: {
                    this.slice_type = SliceType.I;
                    break;
                }
                case 3: 
                case 8: {
                    this.slice_type = SliceType.SP;
                    break;
                }
                case 4: 
                case 9: {
                    this.slice_type = SliceType.SI;
                }
            }
            this.pic_parameter_set_id = reader.readUE();
            this.pps = ppss.get(this.pic_parameter_set_id);
            if (this.pps == null) {
                String ids = "";
                for (Integer integer : ppss.keySet()) {
                    ids = ids + integer + ", ";
                }
                throw new RuntimeException("PPS with ids " + ids + " available but not " + this.pic_parameter_set_id);
            }
            this.sps = spss.get(this.pps.seq_parameter_set_id);
            if (this.sps == null) {
                String ids = "";
                for (Integer integer : spss.keySet()) {
                    ids = ids + integer + ", ";
                }
                throw new RuntimeException("SPS with ids " + ids + " available but not " + this.pps.seq_parameter_set_id);
            }
            if (this.sps.residual_color_transform_flag) {
                this.colour_plane_id = (int)reader.readNBit(2);
            }
            this.frame_num = (int)reader.readNBit(this.sps.log2_max_frame_num_minus4 + 4);
            if (!this.sps.frame_mbs_only_flag) {
                this.field_pic_flag = reader.readBool();
                if (this.field_pic_flag) {
                    this.bottom_field_flag = reader.readBool();
                }
            }
            if (IdrPicFlag) {
                this.idr_pic_id = reader.readUE();
            }
            if (this.sps.pic_order_cnt_type == 0) {
                this.pic_order_cnt_lsb = (int)reader.readNBit(this.sps.log2_max_pic_order_cnt_lsb_minus4 + 4);
                if (this.pps.bottom_field_pic_order_in_frame_present_flag && !this.field_pic_flag) {
                    this.delta_pic_order_cnt_bottom = reader.readSE();
                }
            }
            if (this.sps.pic_order_cnt_type == 1 && !this.sps.delta_pic_order_always_zero_flag) {
                this.delta_pic_order_cnt_0 = reader.readSE();
                if (this.pps.bottom_field_pic_order_in_frame_present_flag && !this.field_pic_flag) {
                    this.delta_pic_order_cnt_1 = reader.readSE();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "SliceHeader{first_mb_in_slice=" + this.first_mb_in_slice + ", slice_type=" + (Object)((Object)this.slice_type) + ", pic_parameter_set_id=" + this.pic_parameter_set_id + ", colour_plane_id=" + this.colour_plane_id + ", frame_num=" + this.frame_num + ", field_pic_flag=" + this.field_pic_flag + ", bottom_field_flag=" + this.bottom_field_flag + ", idr_pic_id=" + this.idr_pic_id + ", pic_order_cnt_lsb=" + this.pic_order_cnt_lsb + ", delta_pic_order_cnt_bottom=" + this.delta_pic_order_cnt_bottom + '}';
    }

    public static enum SliceType {
        P,
        B,
        I,
        SP,
        SI;

    }
}

