/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part30;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.BoxParser;
import org.mp4parser.boxes.sampleentry.AbstractSampleEntry;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;
import org.mp4parser.tools.Mp4Arrays;
import org.mp4parser.tools.Utf8;

public class XMLSubtitleSampleEntry
extends AbstractSampleEntry {
    public static final String TYPE = "stpp";
    private String namespace = "";
    private String schemaLocation = "";
    private String auxiliaryMimeTypes = "";

    public XMLSubtitleSampleEntry() {
        super(TYPE);
    }

    @Override
    public long getSize() {
        long s = this.getContainerSize();
        long t = 8 + this.namespace.length() + this.schemaLocation.length() + this.auxiliaryMimeTypes.length() + 3;
        return s + t + (long)(this.largeBox || s + t + 8L >= 0x100000000L ? 16 : 8);
    }

    @Override
    public void parse(ReadableByteChannel dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        int read;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        dataSource.read(byteBuffer.rewind());
        byteBuffer.position(6);
        this.dataReferenceIndex = IsoTypeReader.readUInt16(byteBuffer);
        byte[] namespaceBytes = new byte[]{};
        while ((read = Channels.newInputStream(dataSource).read()) != 0) {
            namespaceBytes = Mp4Arrays.copyOfAndAppend(namespaceBytes, (byte)read);
        }
        this.namespace = Utf8.convert(namespaceBytes);
        byte[] schemaLocationBytes = new byte[]{};
        while ((read = Channels.newInputStream(dataSource).read()) != 0) {
            schemaLocationBytes = Mp4Arrays.copyOfAndAppend(schemaLocationBytes, (byte)read);
        }
        this.schemaLocation = Utf8.convert(schemaLocationBytes);
        byte[] auxiliaryMimeTypesBytes = new byte[]{};
        while ((read = Channels.newInputStream(dataSource).read()) != 0) {
            auxiliaryMimeTypesBytes = Mp4Arrays.copyOfAndAppend(auxiliaryMimeTypesBytes, (byte)read);
        }
        this.auxiliaryMimeTypes = Utf8.convert(auxiliaryMimeTypesBytes);
        this.initContainer(dataSource, contentSize - (long)(header.remaining() + this.namespace.length() + this.schemaLocation.length() + this.auxiliaryMimeTypes.length() + 3), boxParser);
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 + this.namespace.length() + this.schemaLocation.length() + this.auxiliaryMimeTypes.length() + 3);
        byteBuffer.position(6);
        IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.namespace);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.schemaLocation);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.auxiliaryMimeTypes);
        writableByteChannel.write(byteBuffer.rewind());
        this.writeContainer(writableByteChannel);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getAuxiliaryMimeTypes() {
        return this.auxiliaryMimeTypes;
    }

    public void setAuxiliaryMimeTypes(String auxiliaryMimeTypes) {
        this.auxiliaryMimeTypes = auxiliaryMimeTypes;
    }
}

