/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.mp4parser.aj.lang.JoinPoint;
import org.mp4parser.aj.lang.Signature;
import org.mp4parser.aj.runtime.reflect.Factory;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;

public class TimeToSampleBox
extends AbstractFullBox {
    public static final String TYPE = "stts";
    static Map<List<Entry>, SoftReference<long[]>> cache;
    List<Entry> entries = Collections.emptyList();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        TimeToSampleBox.ajc$preClinit();
        cache = new WeakHashMap<List<Entry>, SoftReference<long[]>>();
    }

    public TimeToSampleBox() {
        super(TYPE);
    }

    public static synchronized long[] blowupTimeToSamples(List<Entry> entries) {
        long[] cacheVal;
        SoftReference<long[]> cacheEntry = cache.get(entries);
        if (cacheEntry != null && (cacheVal = cacheEntry.get()) != null) {
            return cacheVal;
        }
        long numOfSamples = 0L;
        for (Entry entry : entries) {
            numOfSamples += entry.getCount();
        }
        assert (numOfSamples <= Integer.MAX_VALUE);
        long[] decodingTime = new long[(int)numOfSamples];
        int current = 0;
        for (Entry entry : entries) {
            int i = 0;
            while ((long)i < entry.getCount()) {
                decodingTime[current++] = entry.getDelta();
                ++i;
            }
        }
        cache.put(entries, new SoftReference<long[]>(decodingTime));
        return decodingTime;
    }

    @Override
    protected long getContentSize() {
        return 8 + this.entries.size() * 8;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        int entryCount = CastUtils.l2i(IsoTypeReader.readUInt32(content));
        this.entries = new ArrayList<Entry>(entryCount);
        int i = 0;
        while (i < entryCount) {
            this.entries.add(new Entry(IsoTypeReader.readUInt32(content), IsoTypeReader.readUInt32(content)));
            ++i;
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getCount());
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getDelta());
        }
    }

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        List<Entry> list = entries;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, list);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return "TimeToSampleBox[entryCount=" + this.entries.size() + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TimeToSampleBox.java", TimeToSampleBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "org.mp4parser.boxes.iso14496.part12.TimeToSampleBox", "", "", "", "java.util.List"), 111);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "org.mp4parser.boxes.iso14496.part12.TimeToSampleBox", "java.util.List", "entries", "", "void"), 115);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.mp4parser.boxes.iso14496.part12.TimeToSampleBox", "", "", "", "java.lang.String"), 119);
    }

    public static class Entry {
        long count;
        long delta;

        public Entry(long count, long delta) {
            this.count = count;
            this.delta = delta;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public long getDelta() {
            return this.delta;
        }

        public void setDelta(long delta) {
            this.delta = delta;
        }

        public String toString() {
            return "Entry{count=" + this.count + ", delta=" + this.delta + '}';
        }
    }
}

