/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.mp4parser.aj.lang.JoinPoint;
import org.mp4parser.aj.lang.Signature;
import org.mp4parser.aj.runtime.internal.Conversions;
import org.mp4parser.aj.runtime.reflect.Factory;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitReaderBuffer;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitWriterBuffer;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;

public class SegmentIndexBox
extends AbstractFullBox {
    public static final String TYPE = "sidx";
    List<Entry> entries = new ArrayList<Entry>();
    long referenceId;
    long timeScale;
    long earliestPresentationTime;
    long firstOffset;
    int reserved;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    public SegmentIndexBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long size = 4L;
        size += 4L;
        size += 4L;
        size += (long)(this.getVersion() == 0 ? 8 : 16);
        size += 2L;
        size += 2L;
        return size += (long)(this.entries.size() * 12);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.referenceId);
        IsoTypeWriter.writeUInt32(byteBuffer, this.timeScale);
        if (this.getVersion() == 0) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.earliestPresentationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.firstOffset);
        } else {
            IsoTypeWriter.writeUInt64(byteBuffer, this.earliestPresentationTime);
            IsoTypeWriter.writeUInt64(byteBuffer, this.firstOffset);
        }
        IsoTypeWriter.writeUInt16(byteBuffer, this.reserved);
        IsoTypeWriter.writeUInt16(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            BitWriterBuffer b = new BitWriterBuffer(byteBuffer);
            b.writeBits(entry.getReferenceType(), 1);
            b.writeBits(entry.getReferencedSize(), 31);
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getSubsegmentDuration());
            b = new BitWriterBuffer(byteBuffer);
            b.writeBits(entry.getStartsWithSap(), 1);
            b.writeBits(entry.getSapType(), 3);
            b.writeBits(entry.getSapDeltaTime(), 28);
        }
    }

    @Override
    protected void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.referenceId = IsoTypeReader.readUInt32(content);
        this.timeScale = IsoTypeReader.readUInt32(content);
        if (this.getVersion() == 0) {
            this.earliestPresentationTime = IsoTypeReader.readUInt32(content);
            this.firstOffset = IsoTypeReader.readUInt32(content);
        } else {
            this.earliestPresentationTime = IsoTypeReader.readUInt64(content);
            this.firstOffset = IsoTypeReader.readUInt64(content);
        }
        this.reserved = IsoTypeReader.readUInt16(content);
        int numEntries = IsoTypeReader.readUInt16(content);
        int i = 0;
        while (i < numEntries) {
            BitReaderBuffer b = new BitReaderBuffer(content);
            Entry e = new Entry();
            e.setReferenceType((byte)b.readBits(1));
            e.setReferencedSize(b.readBits(31));
            e.setSubsegmentDuration(IsoTypeReader.readUInt32(content));
            b = new BitReaderBuffer(content);
            e.setStartsWithSap((byte)b.readBits(1));
            e.setSapType((byte)b.readBits(3));
            e.setSapDeltaTime(b.readBits(28));
            this.entries.add(e);
            ++i;
        }
    }

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        List<Entry> list = entries;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, list);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    public long getReferenceId() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.referenceId;
    }

    public void setReferenceId(long referenceId) {
        long l = referenceId;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, Conversions.longObject(l));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.referenceId = referenceId;
    }

    public long getTimeScale() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.timeScale;
    }

    public void setTimeScale(long timeScale) {
        long l = timeScale;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, Conversions.longObject(l));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.timeScale = timeScale;
    }

    public long getEarliestPresentationTime() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.earliestPresentationTime;
    }

    public void setEarliestPresentationTime(long earliestPresentationTime) {
        long l = earliestPresentationTime;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, (Object)this, (Object)this, Conversions.longObject(l));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.earliestPresentationTime = earliestPresentationTime;
    }

    public long getFirstOffset() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.firstOffset;
    }

    public void setFirstOffset(long firstOffset) {
        long l = firstOffset;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, (Object)this, (Object)this, Conversions.longObject(l));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.firstOffset = firstOffset;
    }

    public int getReserved() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.reserved;
    }

    public void setReserved(int reserved) {
        int n = reserved;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.reserved = reserved;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_12, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return "SegmentIndexBox{entries=" + this.entries + ", referenceId=" + this.referenceId + ", timeScale=" + this.timeScale + ", earliestPresentationTime=" + this.earliestPresentationTime + ", firstOffset=" + this.firstOffset + ", reserved=" + this.reserved + '}';
    }

    static {
        SegmentIndexBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SegmentIndexBox.java", SegmentIndexBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "", "", "", "java.util.List"), 128);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "java.util.List", "entries", "", "void"), 132);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReserved", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "", "", "", "int"), 168);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setReserved", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "int", "reserved", "", "void"), 172);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "", "", "", "java.lang.String"), 177);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReferenceId", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "", "", "", "long"), 136);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setReferenceId", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "long", "referenceId", "", "void"), 140);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimeScale", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "", "", "", "long"), 144);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTimeScale", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "long", "timeScale", "", "void"), 148);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEarliestPresentationTime", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "", "", "", "long"), 152);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEarliestPresentationTime", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "long", "earliestPresentationTime", "", "void"), 156);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstOffset", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "", "", "", "long"), 160);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFirstOffset", "org.mp4parser.boxes.iso14496.part12.SegmentIndexBox", "long", "firstOffset", "", "void"), 164);
    }

    public static class Entry {
        byte referenceType;
        int referencedSize;
        long subsegmentDuration;
        byte startsWithSap;
        byte sapType;
        int sapDeltaTime;

        public Entry() {
        }

        public Entry(int referenceType, int referencedSize, long subsegmentDuration, boolean startsWithSap, int sapType, int sapDeltaTime) {
            this.referenceType = (byte)referenceType;
            this.referencedSize = referencedSize;
            this.subsegmentDuration = subsegmentDuration;
            this.startsWithSap = (byte)(startsWithSap ? 1 : 0);
            this.sapType = (byte)sapType;
            this.sapDeltaTime = sapDeltaTime;
        }

        public byte getReferenceType() {
            return this.referenceType;
        }

        public void setReferenceType(byte referenceType) {
            this.referenceType = referenceType;
        }

        public int getReferencedSize() {
            return this.referencedSize;
        }

        public void setReferencedSize(int referencedSize) {
            this.referencedSize = referencedSize;
        }

        public long getSubsegmentDuration() {
            return this.subsegmentDuration;
        }

        public void setSubsegmentDuration(long subsegmentDuration) {
            this.subsegmentDuration = subsegmentDuration;
        }

        public byte getStartsWithSap() {
            return this.startsWithSap;
        }

        public void setStartsWithSap(byte startsWithSap) {
            this.startsWithSap = startsWithSap;
        }

        public byte getSapType() {
            return this.sapType;
        }

        public void setSapType(byte sapType) {
            this.sapType = sapType;
        }

        public int getSapDeltaTime() {
            return this.sapDeltaTime;
        }

        public void setSapDeltaTime(int sapDeltaTime) {
            this.sapDeltaTime = sapDeltaTime;
        }

        public String toString() {
            return "Entry{referenceType=" + this.referenceType + ", referencedSize=" + this.referencedSize + ", subsegmentDuration=" + this.subsegmentDuration + ", startsWithSap=" + this.startsWithSap + ", sapType=" + this.sapType + ", sapDeltaTime=" + this.sapDeltaTime + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.referenceType != entry.referenceType) {
                return false;
            }
            if (this.referencedSize != entry.referencedSize) {
                return false;
            }
            if (this.sapDeltaTime != entry.sapDeltaTime) {
                return false;
            }
            if (this.sapType != entry.sapType) {
                return false;
            }
            if (this.startsWithSap != entry.startsWithSap) {
                return false;
            }
            return this.subsegmentDuration == entry.subsegmentDuration;
        }

        public int hashCode() {
            int result = this.referenceType;
            result = 31 * result + this.referencedSize;
            result = 31 * result + (int)(this.subsegmentDuration ^ this.subsegmentDuration >>> 32);
            result = 31 * result + this.startsWithSap;
            result = 31 * result + this.sapType;
            result = 31 * result + this.sapDeltaTime;
            return result;
        }
    }
}

