/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.jetty.rhttp.client.RHTTPRequest;
import org.mortbay.jetty.rhttp.server.ClientDelegate;

public class StandardClientDelegate
implements ClientDelegate {
    private final Logger logger = Log.getLogger((String)this.getClass().toString());
    private final Object lock = new Object();
    private final List<RHTTPRequest> requests = new ArrayList<RHTTPRequest>();
    private final String targetId;
    private volatile boolean firstFlush = true;
    private volatile long timeout;
    private volatile boolean closed;
    private Continuation continuation;

    public StandardClientDelegate(String targetId) {
        this.targetId = targetId;
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enqueue(RHTTPRequest request) {
        if (this.isClosed()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            this.requests.add(request);
            this.resume();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        Object object = this.lock;
        synchronized (object) {
            if (this.continuation != null) {
                this.continuation.resume();
                this.continuation = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RHTTPRequest> process(HttpServletRequest httpRequest) throws IOException {
        List<RHTTPRequest> result = Collections.emptyList();
        if (this.firstFlush) {
            this.firstFlush = false;
            this.logger.debug("Connect request (first) from device {}, delivering requests {}", new Object[]{this.targetId, result});
        } else {
            Object object = this.lock;
            synchronized (object) {
                int size = this.requests.size();
                if (size > 0) {
                    assert (this.continuation == null);
                    result = new ArrayList(size);
                    result.addAll(this.requests);
                    this.requests.clear();
                    this.logger.debug("Connect request (resumed) from device {}, delivering requests {}", new Object[]{this.targetId, result});
                } else if (this.continuation != null) {
                    this.continuation = null;
                    this.logger.debug("Connect request (expired) from device {}, delivering requests {}", new Object[]{this.targetId, result});
                } else if (this.isClosed()) {
                    this.logger.debug("Connect request (closed) from device {}, delivering requests {}", new Object[]{this.targetId, result});
                } else {
                    this.continuation = ContinuationSupport.getContinuation((ServletRequest)httpRequest);
                    this.continuation.setTimeout(this.getTimeout());
                    this.continuation.suspend();
                    result = null;
                    this.logger.debug("Connect request (suspended) from device {}", new Object[]{this.targetId});
                }
            }
        }
        return result;
    }

    @Override
    public void close() {
        this.closed = true;
        this.resume();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

