/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RHTTPResponse {
    private static final String CRLF = "\r\n";
    private static final byte[] CRLF_BYTES = "\r\n".getBytes();
    private final int id;
    private final byte[] responseBytes;
    private final byte[] frameBytes;
    private volatile int code;
    private volatile String message;
    private volatile Map<String, String> headers;
    private volatile byte[] body;

    public static RHTTPResponse fromFrameBytes(byte[] bytes) {
        int start;
        int end = start = 0;
        while (bytes[end] != 32) {
            ++end;
        }
        int responseId = Integer.parseInt(new String(bytes, start, end - start));
        start = end + 1;
        while (bytes[end] != 10) {
            ++end;
        }
        int length = Integer.parseInt(new String(bytes, start, end - start - 1));
        start = end + 1;
        byte[] responseBytes = new byte[length];
        System.arraycopy(bytes, start, responseBytes, 0, length);
        return RHTTPResponse.fromResponseBytes(responseId, responseBytes);
    }

    public static RHTTPResponse fromResponseBytes(int id, byte[] responseBytes) {
        return new RHTTPResponse(id, responseBytes);
    }

    public RHTTPResponse(int id, int code, String message, Map<String, String> headers, byte[] body) {
        this.id = id;
        this.code = code;
        this.message = message;
        this.headers = headers;
        this.body = body;
        this.responseBytes = this.toResponseBytes();
        this.frameBytes = this.toFrameBytes(this.responseBytes);
    }

    private RHTTPResponse(int id, byte[] responseBytes) {
        this.id = id;
        this.responseBytes = responseBytes;
        this.frameBytes = this.toFrameBytes(responseBytes);
    }

    private void initialize() {
        try {
            final ByteArrayOutputStream body = new ByteArrayOutputStream();
            HttpParser parser = new HttpParser((Buffer)new ByteArrayBuffer(this.responseBytes), new HttpParser.EventHandler(){

                public void startRequest(Buffer method, Buffer uri, Buffer httpVersion) throws IOException {
                }

                public void startResponse(Buffer httpVersion, int statusCode, Buffer statusMessage) throws IOException {
                    RHTTPResponse.this.code = statusCode;
                    RHTTPResponse.this.message = statusMessage.toString("UTF-8");
                    RHTTPResponse.this.headers = new LinkedHashMap();
                }

                public void parsedHeader(Buffer name, Buffer value) throws IOException {
                    RHTTPResponse.this.headers.put(name.toString("UTF-8"), value.toString("UTF-8"));
                }

                public void content(Buffer content) throws IOException {
                    content.writeTo((OutputStream)body);
                }
            });
            parser.parse();
            this.body = body.toByteArray();
        }
        catch (IOException x) {
            throw new AssertionError((Object)x);
        }
    }

    public int getId() {
        return this.id;
    }

    public byte[] getResponseBytes() {
        return this.responseBytes;
    }

    public byte[] getFrameBytes() {
        return this.frameBytes;
    }

    public int getStatusCode() {
        if (this.code == 0) {
            this.initialize();
        }
        return this.code;
    }

    public String getStatusMessage() {
        if (this.message == null) {
            this.initialize();
        }
        return this.message;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.initialize();
        }
        return this.headers;
    }

    public byte[] getBody() {
        if (this.body == null) {
            this.initialize();
        }
        return this.body;
    }

    private byte[] toResponseBytes() {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            bytes.write("HTTP/1.1".getBytes("UTF-8"));
            bytes.write(32);
            bytes.write(String.valueOf(this.code).getBytes("UTF-8"));
            bytes.write(32);
            bytes.write(this.message.getBytes("UTF-8"));
            bytes.write(CRLF_BYTES);
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                bytes.write(entry.getKey().getBytes("UTF-8"));
                bytes.write(58);
                bytes.write(32);
                bytes.write(entry.getValue().getBytes("UTF-8"));
                bytes.write(CRLF_BYTES);
            }
            bytes.write(CRLF_BYTES);
            bytes.write(this.body);
            bytes.close();
            return bytes.toByteArray();
        }
        catch (IOException x) {
            throw new AssertionError((Object)x);
        }
    }

    private byte[] toFrameBytes(byte[] responseBytes) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            bytes.write(String.valueOf(this.id).getBytes("UTF-8"));
            bytes.write(32);
            bytes.write(String.valueOf(responseBytes.length).getBytes("UTF-8"));
            bytes.write(CRLF_BYTES);
            bytes.write(responseBytes);
            return bytes.toByteArray();
        }
        catch (IOException x) {
            throw new AssertionError((Object)x);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append(" ");
        builder.append(this.code).append(" ");
        builder.append(this.message).append(" ");
        builder.append(this.responseBytes.length).append("/");
        builder.append(this.frameBytes.length);
        return builder.toString();
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append(" ");
        builder.append(this.getStatusCode()).append(" ");
        builder.append(this.getStatusMessage()).append(CRLF);
        for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
            builder.append(header.getKey()).append(": ").append(header.getValue()).append(CRLF);
        }
        builder.append(this.getBody().length).append(" body bytes").append(CRLF);
        return builder.toString();
    }
}

