/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ReadPreference;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadWriteBinding;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.session.ClientSession;
import com.mongodb.session.SessionContext;
import org.bson.assertions.Assertions;

class ClientSessionBinding
implements ReadWriteBinding {
    private final ReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    ClientSessionBinding(ClientSession session, boolean ownsSession, ReadWriteBinding wrapped) {
        this.wrapped = (ReadWriteBinding)Assertions.notNull((String)"wrapped", (Object)wrapped);
        this.ownsSession = ownsSession;
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
        this.sessionContext = new ClientSessionContext(session);
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public ReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    public void release() {
        this.wrapped.release();
        this.closeSessionIfCountIsZero();
    }

    private void closeSessionIfCountIsZero() {
        if (this.getCount() == 0 && this.ownsSession) {
            this.session.close();
        }
    }

    public ConnectionSource getReadConnectionSource() {
        return new SessionBindingConnectionSource(this.wrapped.getReadConnectionSource());
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ConnectionSource getWriteConnectionSource() {
        return new SessionBindingConnectionSource(this.wrapped.getWriteConnectionSource());
    }

    private class SessionBindingConnectionSource
    implements ConnectionSource {
        private ConnectionSource wrapped;

        SessionBindingConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        public Connection getConnection() {
            return this.wrapped.getConnection();
        }

        public ConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public void release() {
            this.wrapped.release();
            ClientSessionBinding.this.closeSessionIfCountIsZero();
        }
    }
}

