/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.util.JSON;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.bson.BasicBSONObject;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

public class BasicDBObject
extends BasicBSONObject
implements DBObject,
Bson {
    private static final long serialVersionUID = -4415279469780082174L;
    private boolean isPartialObject;

    public static BasicDBObject parse(String json) {
        return BasicDBObject.parse(json, (Decoder<BasicDBObject>)MongoClient.getDefaultCodecRegistry().get(BasicDBObject.class));
    }

    public static BasicDBObject parse(String json, Decoder<BasicDBObject> decoder) {
        return (BasicDBObject)decoder.decode((BsonReader)new JsonReader(json), DecoderContext.builder().build());
    }

    public BasicDBObject() {
    }

    public BasicDBObject(int size) {
        super(size);
    }

    public BasicDBObject(String key, Object value) {
        super(key, value);
    }

    public BasicDBObject(Map map) {
        super(map);
    }

    @Override
    public BasicDBObject append(String key, Object val) {
        this.put(key, val);
        return this;
    }

    @Override
    public boolean isPartialObject() {
        return this.isPartialObject;
    }

    public String toJson() {
        return this.toJson(new JsonWriterSettings());
    }

    public String toJson(JsonWriterSettings writerSettings) {
        return this.toJson(writerSettings, (Encoder<BasicDBObject>)MongoClient.getDefaultCodecRegistry().get(BasicDBObject.class));
    }

    public String toJson(Encoder<BasicDBObject> encoder) {
        return this.toJson(new JsonWriterSettings(), encoder);
    }

    public String toJson(JsonWriterSettings writerSettings, Encoder<BasicDBObject> encoder) {
        JsonWriter writer = new JsonWriter((Writer)new StringWriter(), writerSettings);
        encoder.encode((BsonWriter)writer, (Object)this, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
        return writer.getWriter().toString();
    }

    @Override
    public String toString() {
        return JSON.serialize(this);
    }

    @Override
    public void markAsPartialObject() {
        this.isPartialObject = true;
    }

    public Object copy() {
        BasicDBObject newCopy = new BasicDBObject(this.toMap());
        for (String field : this.keySet()) {
            Object val = this.get(field);
            if (val instanceof BasicDBObject) {
                newCopy.put(field, ((BasicDBObject)val).copy());
                continue;
            }
            if (!(val instanceof BasicDBList)) continue;
            newCopy.put(field, ((BasicDBList)val).copy());
        }
        return newCopy;
    }

    public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
        return new BsonDocumentWrapper((Object)this, (Encoder)codecRegistry.get(BasicDBObject.class));
    }
}

