/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBEncoder;
import com.mongodb.DBEncoderAdapter;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.Function;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.connection.BufferProvider;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.CommandReadOperation;
import com.mongodb.operation.CommandWriteOperation;
import com.mongodb.operation.CreateCollectionOperation;
import com.mongodb.operation.CreateUserOperation;
import com.mongodb.operation.DropUserOperation;
import com.mongodb.operation.ListCollectionsOperation;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.ReadOperation;
import com.mongodb.operation.UpdateUserOperation;
import com.mongodb.operation.UserExistsOperation;
import com.mongodb.operation.WriteOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.Encoder;

@ThreadSafe
public class DB {
    private final Mongo mongo;
    private final String name;
    private final OperationExecutor executor;
    private final ConcurrentHashMap<String, DBCollection> collectionCache;
    private final Bytes.OptionHolder optionHolder;
    private final Codec<DBObject> commandCodec;
    private volatile ReadPreference readPreference;
    private volatile WriteConcern writeConcern;
    private static final Set<String> OBEDIENT_COMMANDS = new HashSet<String>();

    DB(Mongo mongo, String name, OperationExecutor executor) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Invalid database name format. Database name is either empty or it contains spaces.");
        }
        this.mongo = mongo;
        this.name = name;
        this.executor = executor;
        this.collectionCache = new ConcurrentHashMap();
        this.optionHolder = new Bytes.OptionHolder(mongo.getOptionHolder());
        this.commandCodec = MongoClient.getCommandCodec();
    }

    public DB(Mongo mongo, String name) {
        this(mongo, name, mongo.createOperationExecutor());
    }

    public Mongo getMongo() {
        return this.mongo;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference != null ? this.readPreference : this.mongo.getReadPreference();
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern != null ? this.writeConcern : this.mongo.getWriteConcern();
    }

    protected DBCollection doGetCollection(String name) {
        return this.getCollection(name);
    }

    public DBCollection getCollection(String name) {
        DBCollection old;
        DBCollection collection = this.collectionCache.get(name);
        if (collection != null) {
            return collection;
        }
        collection = new DBCollection(name, this, this.executor);
        if (this.mongo.getMongoClientOptions().getDbDecoderFactory() != DefaultDBDecoder.FACTORY) {
            collection.setDBDecoderFactory(this.mongo.getMongoClientOptions().getDbDecoderFactory());
        }
        if (this.mongo.getMongoClientOptions().getDbEncoderFactory() != DefaultDBEncoder.FACTORY) {
            collection.setDBEncoderFactory(this.mongo.getMongoClientOptions().getDbEncoderFactory());
        }
        return (old = this.collectionCache.putIfAbsent(name, collection)) != null ? old : collection;
    }

    public void dropDatabase() {
        this.executeCommand(new BsonDocument("dropDatabase", (BsonValue)new BsonInt32(1)));
    }

    public DBCollection getCollectionFromString(String collectionName) {
        return this.getCollection(collectionName);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getCollectionNames() {
        List collectionNames = new OperationIterable<DBObject>((ReadOperation<BatchCursor<DBObject>>)new ListCollectionsOperation(this.name, this.commandCodec), ReadPreference.primary(), this.executor).map(new Function<DBObject, String>(){

            public String apply(DBObject result) {
                return (String)result.get("name");
            }
        }).into(new ArrayList());
        Collections.sort(collectionNames);
        return new LinkedHashSet<String>(collectionNames);
    }

    public DBCollection createCollection(String collectionName, DBObject options) {
        if (options != null) {
            this.executor.execute((WriteOperation)this.getCreateCollectionOperation(collectionName, options));
        }
        return this.getCollection(collectionName);
    }

    private CreateCollectionOperation getCreateCollectionOperation(String collectionName, DBObject options) {
        if (options.get("size") != null && !(options.get("size") instanceof Number)) {
            throw new IllegalArgumentException("'size' should be Number");
        }
        if (options.get("max") != null && !(options.get("max") instanceof Number)) {
            throw new IllegalArgumentException("'max' should be Number");
        }
        if (options.get("capped") != null && !(options.get("capped") instanceof Boolean)) {
            throw new IllegalArgumentException("'capped' should be Boolean");
        }
        if (options.get("autoIndexId") != null && !(options.get("capped") instanceof Boolean)) {
            throw new IllegalArgumentException("'capped' should be Boolean");
        }
        if (options.get("storageEngine") != null && !(options.get("storageEngine") instanceof DBObject)) {
            throw new IllegalArgumentException("storageEngine' should be DBObject");
        }
        boolean capped = false;
        boolean autoIndex = true;
        long sizeInBytes = 0L;
        long maxDocuments = 0L;
        Boolean usePowerOfTwoSizes = null;
        BsonDocument storageEngineOptions = null;
        if (options.get("capped") != null) {
            capped = (Boolean)options.get("capped");
        }
        if (options.get("size") != null) {
            sizeInBytes = ((Number)options.get("size")).longValue();
        }
        if (options.get("autoIndexId") != null) {
            autoIndex = (Boolean)options.get("autoIndexId");
        }
        if (options.get("max") != null) {
            maxDocuments = ((Number)options.get("max")).longValue();
        }
        if (options.get("usePowerOfTwoSizes") != null) {
            usePowerOfTwoSizes = (Boolean)options.get("usePowerOfTwoSizes");
        }
        if (options.get("storageEngine") != null) {
            storageEngineOptions = this.wrap((DBObject)options.get("storageEngine"));
        }
        return new CreateCollectionOperation(this.getName(), collectionName).capped(capped).sizeInBytes(sizeInBytes).autoIndex(autoIndex).maxDocuments(maxDocuments).usePowerOf2Sizes(usePowerOfTwoSizes).storageEngineOptions(storageEngineOptions);
    }

    public CommandResult command(String command) {
        return this.command((DBObject)new BasicDBObject(command, Boolean.TRUE), this.getReadPreference());
    }

    public CommandResult command(DBObject command) {
        return this.command(command, this.getReadPreference());
    }

    public CommandResult command(DBObject command, DBEncoder encoder) {
        return this.command(command, this.getReadPreference(), encoder);
    }

    public CommandResult command(DBObject command, ReadPreference readPreference, DBEncoder encoder) {
        try {
            return this.executeCommand(this.wrap(command, encoder), this.getCommandReadPreference(command, readPreference));
        }
        catch (MongoCommandException ex) {
            return new CommandResult(ex.getResponse(), ex.getServerAddress());
        }
    }

    public CommandResult command(DBObject command, ReadPreference readPreference) {
        return this.command(command, readPreference, null);
    }

    public CommandResult command(String command, ReadPreference readPreference) {
        return this.command((DBObject)new BasicDBObject(command, true), readPreference);
    }

    public DB getSisterDB(String name) {
        return this.mongo.getDB(name);
    }

    public boolean collectionExists(String collectionName) {
        Set<String> collectionNames = this.getCollectionNames();
        for (String name : collectionNames) {
            if (!name.equalsIgnoreCase(collectionName)) continue;
            return true;
        }
        return false;
    }

    public CommandResult doEval(String code, Object ... args) {
        BasicDBObject commandDocument = new BasicDBObject("$eval", code).append("args", Arrays.asList(args));
        return this.executeCommand(this.wrap(commandDocument));
    }

    public Object eval(String code, Object ... args) {
        CommandResult result = this.doEval(code, args);
        result.throwOnError();
        return result.get("retval");
    }

    public CommandResult getStats() {
        BsonDocument commandDocument = new BsonDocument("dbStats", (BsonValue)new BsonInt32(1)).append("scale", (BsonValue)new BsonInt32(1));
        return this.executeCommand(commandDocument);
    }

    @Deprecated
    public WriteResult addUser(String userName, char[] password) {
        return this.addUser(userName, password, false);
    }

    @Deprecated
    public WriteResult addUser(String userName, char[] password, boolean readOnly) {
        boolean userExists;
        MongoCredential credential;
        block3: {
            credential = MongoCredential.createMongoCRCredential((String)userName, (String)this.getName(), (char[])password);
            userExists = false;
            try {
                userExists = (Boolean)this.executor.execute((ReadOperation)new UserExistsOperation(this.getName(), userName), ReadPreference.primary());
            }
            catch (MongoCommandException e) {
                if (e.getCode() == 13) break block3;
                throw e;
            }
        }
        if (userExists) {
            this.executor.execute((WriteOperation)new UpdateUserOperation(credential, readOnly));
            return new WriteResult(1, true, null);
        }
        this.executor.execute((WriteOperation)new CreateUserOperation(credential, readOnly));
        return new WriteResult(1, false, null);
    }

    @Deprecated
    public WriteResult removeUser(String userName) {
        this.executor.execute((WriteOperation)new DropUserOperation(this.getName(), userName));
        return new WriteResult(1, true, null);
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this.optionHolder.add(option);
    }

    public void setOptions(int options) {
        this.optionHolder.set(options);
    }

    public void resetOptions() {
        this.optionHolder.reset();
    }

    public int getOptions() {
        return this.optionHolder.get();
    }

    public String toString() {
        return "DB{name='" + this.name + '\'' + '}';
    }

    CommandResult executeCommand(BsonDocument commandDocument) {
        return new CommandResult((BsonDocument)this.executor.execute((WriteOperation)new CommandWriteOperation(this.getName(), commandDocument, (Decoder)new BsonDocumentCodec())));
    }

    CommandResult executeCommand(BsonDocument commandDocument, ReadPreference readPreference) {
        return new CommandResult((BsonDocument)this.executor.execute((ReadOperation)new CommandReadOperation(this.getName(), commandDocument, (Decoder)new BsonDocumentCodec()), readPreference));
    }

    OperationExecutor getExecutor() {
        return this.executor;
    }

    Bytes.OptionHolder getOptionHolder() {
        return this.optionHolder;
    }

    BufferProvider getBufferPool() {
        return this.getMongo().getBufferProvider();
    }

    private boolean isValidName(String databaseName) {
        return databaseName.length() != 0 && !databaseName.contains(" ");
    }

    private BsonDocument wrap(DBObject document) {
        return new BsonDocumentWrapper((Object)document, this.commandCodec);
    }

    private BsonDocument wrap(DBObject document, DBEncoder encoder) {
        if (encoder == null) {
            return this.wrap(document);
        }
        return new BsonDocumentWrapper((Object)document, (Encoder)new DBEncoderAdapter(encoder));
    }

    ReadPreference getCommandReadPreference(DBObject command, ReadPreference requestedPreference) {
        boolean primaryRequired;
        String comString = command.keySet().iterator().next().toLowerCase();
        boolean bl = primaryRequired = !OBEDIENT_COMMANDS.contains(comString);
        if (primaryRequired) {
            return ReadPreference.primary();
        }
        if (requestedPreference == null) {
            return ReadPreference.primary();
        }
        return requestedPreference;
    }

    static {
        OBEDIENT_COMMANDS.add("aggregate");
        OBEDIENT_COMMANDS.add("collstats");
        OBEDIENT_COMMANDS.add("count");
        OBEDIENT_COMMANDS.add("dbstats");
        OBEDIENT_COMMANDS.add("distinct");
        OBEDIENT_COMMANDS.add("geonear");
        OBEDIENT_COMMANDS.add("geosearch");
        OBEDIENT_COMMANDS.add("geowalk");
        OBEDIENT_COMMANDS.add("group");
        OBEDIENT_COMMANDS.add("listcollections");
        OBEDIENT_COMMANDS.add("listindexes");
        OBEDIENT_COMMANDS.add("parallelcollectionscan");
        OBEDIENT_COMMANDS.add("text");
    }
}

