/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ServerAddress;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import java.util.List;

public class ReplicaSetStatus {
    private final Cluster cluster;

    ReplicaSetStatus(Cluster cluster) {
        this.cluster = cluster;
    }

    public String getName() {
        List any = this.getClusterDescription().getAnyPrimaryOrSecondary();
        return any.isEmpty() ? null : ((ServerDescription)any.get(0)).getSetName();
    }

    public ServerAddress getMaster() {
        List primaries = this.getClusterDescription().getPrimaries();
        return primaries.isEmpty() ? null : ((ServerDescription)primaries.get(0)).getAddress();
    }

    public boolean isMaster(ServerAddress serverAddress) {
        return this.getMaster().equals((Object)serverAddress);
    }

    public int getMaxBsonObjectSize() {
        List primaries = this.getClusterDescription().getPrimaries();
        return primaries.isEmpty() ? ServerDescription.getDefaultMaxDocumentSize() : ((ServerDescription)primaries.get(0)).getMaxDocumentSize();
    }

    private ClusterDescription getClusterDescription() {
        return this.cluster.getDescription();
    }

    public String toString() {
        return "ReplicaSetStatus{name=" + this.getName() + ", cluster=" + this.getClusterDescription() + '}';
    }
}

