/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MappingIterable;
import com.mongodb.MongoBatchCursorAdapter;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.ReadOperation;
import java.util.Collection;
import java.util.Iterator;

class OperationIterable<T>
implements MongoIterable<T> {
    private final ReadOperation<? extends BatchCursor<T>> operation;
    private final ReadPreference readPreference;
    private final OperationExecutor executor;

    OperationIterable(ReadOperation<? extends BatchCursor<T>> operation, ReadPreference readPreference, OperationExecutor executor) {
        this.operation = operation;
        this.readPreference = readPreference;
        this.executor = executor;
    }

    @Override
    public MongoCursor<T> iterator() {
        return new MongoBatchCursorAdapter((BatchCursor)this.executor.execute(this.operation, this.readPreference));
    }

    @Override
    public T first() {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return (T)iterator.next();
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super T> block) {
        Iterator cursor = this.iterator();
        while (cursor.hasNext()) {
            block.apply(cursor.next());
        }
    }

    @Override
    public <A extends Collection<? super T>> A into(final A target) {
        this.forEach((Block<? super T>)new Block<T>(){

            public void apply(T t) {
                target.add(t);
            }
        });
        return target;
    }

    @Override
    public MongoIterable<T> batchSize(int batchSize) {
        throw new UnsupportedOperationException();
    }
}

