/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientBulkWriteException;
import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoQueryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.RequestContext;
import com.mongodb.ServerApi;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoCluster;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.SynchronousContextProvider;
import com.mongodb.client.internal.ChangeStreamIterableImpl;
import com.mongodb.client.internal.ClientSessionBinding;
import com.mongodb.client.internal.ClientSessionImpl;
import com.mongodb.client.internal.Crypt;
import com.mongodb.client.internal.CryptBinding;
import com.mongodb.client.internal.ListDatabasesIterableImpl;
import com.mongodb.client.internal.MongoDatabaseImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.internal.IgnorableRequestContext;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ClusterBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ReadConcernAwareNoOpSessionContext;
import com.mongodb.internal.observability.micrometer.Span;
import com.mongodb.internal.observability.micrometer.TracingManager;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class MongoClusterImpl
implements MongoCluster {
    @Nullable
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final Cluster cluster;
    private final CodecRegistry codecRegistry;
    @Nullable
    private final SynchronousContextProvider contextProvider;
    @Nullable
    private final Crypt crypt;
    private final Object originator;
    private final OperationExecutor operationExecutor;
    private final ReadConcern readConcern;
    private final ReadPreference readPreference;
    private final boolean retryReads;
    private final boolean retryWrites;
    @Nullable
    private final ServerApi serverApi;
    private final ServerSessionPool serverSessionPool;
    private final TimeoutSettings timeoutSettings;
    private final UuidRepresentation uuidRepresentation;
    private final WriteConcern writeConcern;
    private final Operations<BsonDocument> operations;
    private final TracingManager tracingManager;

    MongoClusterImpl(@Nullable AutoEncryptionSettings autoEncryptionSettings, Cluster cluster, CodecRegistry codecRegistry, @Nullable SynchronousContextProvider contextProvider, @Nullable Crypt crypt, Object originator, @Nullable OperationExecutor operationExecutor, ReadConcern readConcern, ReadPreference readPreference, boolean retryReads, boolean retryWrites, @Nullable ServerApi serverApi, ServerSessionPool serverSessionPool, TimeoutSettings timeoutSettings, UuidRepresentation uuidRepresentation, WriteConcern writeConcern, TracingManager tracingManager) {
        this.autoEncryptionSettings = autoEncryptionSettings;
        this.cluster = cluster;
        this.codecRegistry = codecRegistry;
        this.contextProvider = contextProvider;
        this.crypt = crypt;
        this.originator = originator;
        this.operationExecutor = operationExecutor != null ? operationExecutor : new OperationExecutorImpl(timeoutSettings);
        this.readConcern = readConcern;
        this.readPreference = readPreference;
        this.retryReads = retryReads;
        this.retryWrites = retryWrites;
        this.serverApi = serverApi;
        this.serverSessionPool = serverSessionPool;
        this.timeoutSettings = timeoutSettings;
        this.uuidRepresentation = uuidRepresentation;
        this.writeConcern = writeConcern;
        this.tracingManager = tracingManager;
        this.operations = new Operations(null, BsonDocument.class, readPreference, codecRegistry, readConcern, writeConcern, retryWrites, retryReads, timeoutSettings);
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    @Nullable
    public Long getTimeout(TimeUnit timeUnit) {
        Long timeoutMS = this.timeoutSettings.getTimeoutMS();
        return timeoutMS == null ? null : Long.valueOf(timeUnit.convert(timeoutMS, TimeUnit.MILLISECONDS));
    }

    @Override
    public MongoCluster withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, this.writeConcern, this.tracingManager);
    }

    @Override
    public MongoCluster withReadPreference(ReadPreference readPreference) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, this.writeConcern, this.tracingManager);
    }

    @Override
    public MongoCluster withWriteConcern(WriteConcern writeConcern) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, writeConcern, this.tracingManager);
    }

    @Override
    public MongoCluster withReadConcern(ReadConcern readConcern) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, this.writeConcern, this.tracingManager);
    }

    @Override
    public MongoCluster withTimeout(long timeout, TimeUnit timeUnit) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings.withTimeout(Long.valueOf(timeout), timeUnit), this.uuidRepresentation, this.writeConcern, this.tracingManager);
    }

    @Override
    public MongoDatabase getDatabase(String databaseName) {
        return new MongoDatabaseImpl(databaseName, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.operationExecutor);
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    @Nullable
    public Crypt getCrypt() {
        return this.crypt;
    }

    public OperationExecutor getOperationExecutor() {
        return this.operationExecutor;
    }

    public ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    @Override
    public ClientSession startSession() {
        return this.startSession(ClientSessionOptions.builder().defaultTransactionOptions(TransactionOptions.builder().readConcern(this.readConcern).writeConcern(this.writeConcern).build()).build());
    }

    @Override
    public ClientSession startSession(ClientSessionOptions options) {
        Assertions.notNull((String)"options", (Object)options);
        ClientSessionOptions mergedOptions = ClientSessionOptions.builder((ClientSessionOptions)options).defaultTransactionOptions(TransactionOptions.merge((TransactionOptions)options.getDefaultTransactionOptions(), (TransactionOptions)TransactionOptions.builder().readConcern(this.readConcern).writeConcern(this.writeConcern).readPreference(this.readPreference).build())).build();
        return new ClientSessionImpl(this.serverSessionPool, this.originator, mergedOptions, this.operationExecutor, this.tracingManager);
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    @Override
    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, Document.class);
    }

    @Override
    public <TResult> ListDatabasesIterable<TResult> listDatabases(Class<TResult> clazz) {
        return this.createListDatabasesIterable(null, clazz);
    }

    @Override
    public <TResult> ListDatabasesIterable<TResult> listDatabases(ClientSession clientSession, Class<TResult> clazz) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListDatabasesIterable(clientSession, clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> clazz) {
        return this.watch(Collections.emptyList(), clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> clazz) {
        return this.createChangeStreamIterable(null, pipeline, clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> clazz) {
        return this.watch(clientSession, Collections.emptyList(), clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> clazz) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, clazz);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> clientWriteModels) throws ClientBulkWriteException {
        Assertions.notNull((String)"clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument((String)"`clientWriteModels` must not be empty", (!clientWriteModels.isEmpty() ? 1 : 0) != 0);
        return this.executeBulkWrite(null, clientWriteModels, null);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> clientWriteModels, ClientBulkWriteOptions options) throws ClientBulkWriteException {
        Assertions.notNull((String)"clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument((String)"`clientWriteModels` must not be empty", (!clientWriteModels.isEmpty() ? 1 : 0) != 0);
        Assertions.notNull((String)"options", (Object)options);
        return this.executeBulkWrite(null, clientWriteModels, options);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels) throws ClientBulkWriteException {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        Assertions.notNull((String)"clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument((String)"`clientWriteModels` must not be empty", (!clientWriteModels.isEmpty() ? 1 : 0) != 0);
        return this.executeBulkWrite(clientSession, clientWriteModels, null);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels, ClientBulkWriteOptions options) throws ClientBulkWriteException {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        Assertions.notNull((String)"clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument((String)"`clientWriteModels` must not be empty", (!clientWriteModels.isEmpty() ? 1 : 0) != 0);
        Assertions.notNull((String)"options", (Object)options);
        return this.executeBulkWrite(clientSession, clientWriteModels, options);
    }

    private <T> ListDatabasesIterable<T> createListDatabasesIterable(@Nullable ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clientSession, clazz, this.codecRegistry, ReadPreference.primary(), this.operationExecutor, this.retryReads, this.timeoutSettings);
    }

    private MongoIterable<String> createListDatabaseNamesIterable(@Nullable ClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(true).map(result -> result.getString((Object)"name").getValue());
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, "admin", this.codecRegistry, this.readPreference, this.readConcern, this.operationExecutor, pipeline, resultClass, ChangeStreamLevel.CLIENT, this.retryReads, this.timeoutSettings);
    }

    private ClientBulkWriteResult executeBulkWrite(@Nullable ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels, @Nullable ClientBulkWriteOptions options) {
        Assertions.isTrue((String)"`autoEncryptionSettings` is null, as bulkWrite does not currently support automatic encryption", (this.autoEncryptionSettings == null ? 1 : 0) != 0);
        return (ClientBulkWriteResult)this.operationExecutor.execute(this.operations.clientBulkWriteOperation(clientWriteModels, options), this.readConcern, clientSession);
    }

    private boolean isImplicitSession(@Nullable ClientSession session) {
        return session == null;
    }

    final class OperationExecutorImpl
    implements OperationExecutor {
        private final TimeoutSettings executorTimeoutSettings;

        OperationExecutorImpl(TimeoutSettings executorTimeoutSettings) {
            this.executorTimeoutSettings = executorTimeoutSettings;
        }

        @Override
        public <T> T execute(ReadOperation<T, ?> operation, ReadPreference readPreference, ReadConcern readConcern) {
            return this.execute(operation, readPreference, readConcern, null);
        }

        @Override
        public <T> T execute(WriteOperation<T> operation, ReadConcern readConcern) {
            return this.execute(operation, readConcern, null);
        }

        @Override
        public <T> T execute(ReadOperation<T, ?> operation, ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session) {
            if (session != null) {
                session.notifyOperationInitiated(operation);
            }
            ClientSession actualClientSession = this.getClientSession(session);
            boolean implicitSession = MongoClusterImpl.this.isImplicitSession(session);
            OperationContext operationContext = this.getOperationContext(actualClientSession, readConcern, operation.getCommandName()).withSessionContext((SessionContext)new ClientSessionBinding.SyncClientSessionContext(actualClientSession, readConcern, implicitSession));
            Span span = operationContext.getTracingManager().createOperationSpan(actualClientSession.getTransactionSpan(), operationContext, operation.getCommandName(), operation.getNamespace());
            ReadBinding binding = this.getReadBinding(readPreference, actualClientSession, implicitSession);
            try {
                if (actualClientSession.hasActiveTransaction() && !binding.getReadPreference().equals(ReadPreference.primary())) {
                    throw new MongoClientException("Read preference in a transaction must be primary");
                }
                Object object = operation.execute(binding, operationContext);
                return (T)object;
            }
            catch (MongoException e) {
                MongoException exceptionToHandle = OperationHelper.unwrap((MongoException)e);
                this.labelException(actualClientSession, exceptionToHandle);
                this.clearTransactionContextOnTransientTransactionError(session, exceptionToHandle);
                if (span != null) {
                    span.error((Throwable)e);
                }
                throw e;
            }
            finally {
                binding.release();
                if (span != null) {
                    span.end();
                }
            }
        }

        @Override
        public <T> T execute(WriteOperation<T> operation, ReadConcern readConcern, @Nullable ClientSession session) {
            if (session != null) {
                session.notifyOperationInitiated(operation);
            }
            ClientSession actualClientSession = this.getClientSession(session);
            OperationContext operationContext = this.getOperationContext(actualClientSession, readConcern, operation.getCommandName()).withSessionContext((SessionContext)new ClientSessionBinding.SyncClientSessionContext(actualClientSession, readConcern, MongoClusterImpl.this.isImplicitSession(session)));
            Span span = operationContext.getTracingManager().createOperationSpan(actualClientSession.getTransactionSpan(), operationContext, operation.getCommandName(), operation.getNamespace());
            WriteBinding binding = this.getWriteBinding(actualClientSession, MongoClusterImpl.this.isImplicitSession(session));
            try {
                Object object = operation.execute(binding, operationContext);
                return (T)object;
            }
            catch (MongoException e) {
                MongoException exceptionToHandle = OperationHelper.unwrap((MongoException)e);
                this.labelException(actualClientSession, exceptionToHandle);
                this.clearTransactionContextOnTransientTransactionError(session, exceptionToHandle);
                if (span != null) {
                    span.error((Throwable)e);
                }
                throw e;
            }
            finally {
                binding.release();
                if (span != null) {
                    span.end();
                }
            }
        }

        @Override
        public OperationExecutor withTimeoutSettings(TimeoutSettings newTimeoutSettings) {
            if (Objects.equals(this.executorTimeoutSettings, newTimeoutSettings)) {
                return this;
            }
            return new OperationExecutorImpl(newTimeoutSettings);
        }

        @Override
        public TimeoutSettings getTimeoutSettings() {
            return this.executorTimeoutSettings;
        }

        WriteBinding getWriteBinding(ClientSession session, boolean ownsSession) {
            return this.getReadWriteBinding(ReadPreference.primary(), session, ownsSession);
        }

        ReadBinding getReadBinding(ReadPreference readPreference, ClientSession session, boolean ownsSession) {
            return this.getReadWriteBinding(readPreference, session, ownsSession);
        }

        ReadWriteBinding getReadWriteBinding(ReadPreference readPreference, ClientSession session, boolean ownsSession) {
            Object readWriteBinding = new ClusterBinding(MongoClusterImpl.this.cluster, this.getReadPreferenceForBinding(readPreference, session));
            if (MongoClusterImpl.this.crypt != null) {
                readWriteBinding = new CryptBinding((ClusterAwareReadWriteBinding)readWriteBinding, MongoClusterImpl.this.crypt);
            }
            return new ClientSessionBinding(session, ownsSession, (ClusterAwareReadWriteBinding)readWriteBinding);
        }

        private OperationContext getOperationContext(ClientSession session, ReadConcern readConcern, String commandName) {
            return new OperationContext(this.getRequestContext(), (SessionContext)new ReadConcernAwareNoOpSessionContext(readConcern), TimeoutContext.createTimeoutContext((com.mongodb.session.ClientSession)session, (TimeoutSettings)this.executorTimeoutSettings), MongoClusterImpl.this.tracingManager, MongoClusterImpl.this.serverApi, commandName);
        }

        private RequestContext getRequestContext() {
            RequestContext context = null;
            if (MongoClusterImpl.this.contextProvider != null) {
                context = MongoClusterImpl.this.contextProvider.getContext();
            }
            return context == null ? IgnorableRequestContext.INSTANCE : context;
        }

        private void labelException(ClientSession session, MongoException e) {
            if (session.hasActiveTransaction() && (e instanceof MongoSocketException || e instanceof MongoTimeoutException || e instanceof MongoQueryException && e.getCode() == 91) && !e.hasErrorLabel("UnknownTransactionCommitResult")) {
                e.addLabel("TransientTransactionError");
            }
        }

        private void clearTransactionContextOnTransientTransactionError(@Nullable ClientSession session, MongoException e) {
            if (session != null && e.hasErrorLabel("TransientTransactionError")) {
                session.clearTransactionContext();
            }
        }

        private ReadPreference getReadPreferenceForBinding(ReadPreference readPreference, @Nullable ClientSession session) {
            if (MongoClusterImpl.this.isImplicitSession(session)) {
                return readPreference;
            }
            if (session.hasActiveTransaction()) {
                ReadPreference readPreferenceForBinding = session.getTransactionOptions().getReadPreference();
                if (readPreferenceForBinding == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read preference can not be null");
                }
                return readPreferenceForBinding;
            }
            return readPreference;
        }

        ClientSession getClientSession(@Nullable ClientSession clientSessionFromOperation) {
            ClientSession session;
            if (clientSessionFromOperation != null) {
                Assertions.isTrue((String)"ClientSession from same MongoClient", (clientSessionFromOperation.getOriginator() == MongoClusterImpl.this.originator ? 1 : 0) != 0);
                session = clientSessionFromOperation;
            } else {
                session = MongoClusterImpl.this.startSession(ClientSessionOptions.builder().causallyConsistent(false).defaultTransactionOptions(TransactionOptions.builder().readConcern(ReadConcern.DEFAULT).readPreference(ReadPreference.primary()).writeConcern(WriteConcern.ACKNOWLEDGED).build()).build());
            }
            return session;
        }
    }
}

