/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.Function;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.ClientSession;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.binding.TransactionContext;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.session.ClientSessionContext;
import org.bson.assertions.Assertions;

public class ClientSessionBinding
extends AbstractReferenceCounted
implements ReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;

    public ClientSessionBinding(ClientSession session, boolean ownsSession, ClusterAwareReadWriteBinding wrapped) {
        this.wrapped = wrapped;
        wrapped.retain();
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
        this.ownsSession = ownsSession;
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public ClientSessionBinding retain() {
        super.retain();
        return this;
    }

    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.release();
            if (this.ownsSession) {
                this.session.close();
            }
        }
        return count;
    }

    public ConnectionSource getReadConnectionSource(OperationContext operationContext) {
        return new SessionBindingConnectionSource(this.getConnectionSource((Function<OperationContext, ConnectionSource>)((Function)arg_0 -> ((ClusterAwareReadWriteBinding)this.wrapped).getReadConnectionSource(arg_0)), operationContext));
    }

    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, OperationContext operationContext) {
        ConnectionSource connectionSource = this.getConnectionSource((Function<OperationContext, ConnectionSource>)((Function)opContext -> this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference, opContext)), operationContext);
        return new SessionBindingConnectionSource(connectionSource);
    }

    public ConnectionSource getWriteConnectionSource(OperationContext operationContext) {
        ConnectionSource connectionSource = this.getConnectionSource((Function<OperationContext, ConnectionSource>)((Function)arg_0 -> ((ClusterAwareReadWriteBinding)this.wrapped).getWriteConnectionSource(arg_0)), operationContext);
        return new SessionBindingConnectionSource(connectionSource);
    }

    private ConnectionSource getConnectionSource(Function<OperationContext, ConnectionSource> wrappedConnectionSourceSupplier, OperationContext operationContext) {
        if (!this.session.hasActiveTransaction()) {
            return (ConnectionSource)wrappedConnectionSourceSupplier.apply((Object)operationContext);
        }
        if (TransactionContext.get((com.mongodb.session.ClientSession)this.session) == null) {
            ConnectionSource source = (ConnectionSource)wrappedConnectionSourceSupplier.apply((Object)operationContext);
            ClusterType clusterType = source.getServerDescription().getClusterType();
            if (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED) {
                TransactionContext transactionContext = new TransactionContext(clusterType);
                this.session.setTransactionContext(source.getServerDescription().getAddress(), transactionContext);
                transactionContext.release();
            }
            return source;
        }
        return this.wrapped.getConnectionSource((ServerAddress)Assertions.assertNotNull((Object)this.session.getPinnedServerAddress()), operationContext);
    }

    private class SessionBindingConnectionSource
    implements ConnectionSource {
        private ConnectionSource wrapped;

        SessionBindingConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
            ClientSessionBinding.this.retain();
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        public Connection getConnection(OperationContext operationContext) {
            TransactionContext transactionContext = TransactionContext.get((com.mongodb.session.ClientSession)ClientSessionBinding.this.session);
            if (transactionContext != null && transactionContext.isConnectionPinningRequired()) {
                Connection pinnedConnection = (Connection)transactionContext.getPinnedConnection();
                if (pinnedConnection == null) {
                    Connection connection = this.wrapped.getConnection(operationContext);
                    transactionContext.pinConnection((ReferenceCounted)connection, Connection::markAsPinned);
                    return connection;
                }
                return pinnedConnection.retain();
            }
            return this.wrapped.getConnection(operationContext);
        }

        public ConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public int release() {
            int count = this.wrapped.release();
            if (count == 0) {
                ClientSessionBinding.this.release();
            }
            return count;
        }
    }

    public static final class SyncClientSessionContext
    extends ClientSessionContext {
        private final ClientSession clientSession;
        private final boolean ownsSession;
        private final ReadConcern inheritedReadConcern;

        SyncClientSessionContext(ClientSession clientSession, ReadConcern inheritedReadConcern, boolean ownsSession) {
            super((com.mongodb.session.ClientSession)clientSession);
            this.clientSession = clientSession;
            this.ownsSession = ownsSession;
            this.inheritedReadConcern = inheritedReadConcern;
        }

        public boolean isImplicitSession() {
            return this.ownsSession;
        }

        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return (ReadConcern)Assertions.assertNotNull((Object)this.clientSession.getTransactionOptions().getReadConcern());
            }
            if (this.isSnapshot()) {
                return ReadConcern.SNAPSHOT;
            }
            return this.inheritedReadConcern;
        }
    }
}

