/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class AggregateIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements AggregateIterable<TResult> {
    private final SyncOperations<TDocument> operations;
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final CodecRegistry codecRegistry;
    private final List<? extends Bson> pipeline;
    private final AggregationLevel aggregationLevel;
    private Boolean allowDiskUse;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private BsonValue comment;
    private Bson hint;
    private String hintString;
    private Bson variables;

    AggregateIterableImpl(@Nullable ClientSession clientSession, String databaseName, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, List<? extends Bson> pipeline, AggregationLevel aggregationLevel) {
        this(clientSession, new MongoNamespace(databaseName, "ignored"), documentClass, resultClass, codecRegistry, readPreference, readConcern, writeConcern, executor, pipeline, aggregationLevel, true);
    }

    AggregateIterableImpl(@Nullable ClientSession clientSession, String databaseName, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, List<? extends Bson> pipeline, AggregationLevel aggregationLevel, boolean retryReads) {
        this(clientSession, new MongoNamespace(databaseName, "ignored"), documentClass, resultClass, codecRegistry, readPreference, readConcern, writeConcern, executor, pipeline, aggregationLevel, retryReads);
    }

    AggregateIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, List<? extends Bson> pipeline, AggregationLevel aggregationLevel, boolean retryReads) {
        super(clientSession, executor, readConcern, readPreference, retryReads);
        this.operations = new SyncOperations(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcern, true, retryReads);
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
        this.aggregationLevel = (AggregationLevel)Assertions.notNull((String)"aggregationLevel", (Object)aggregationLevel);
    }

    @Override
    public void toCollection() {
        BsonDocument lastPipelineStage = this.getLastPipelineStage();
        if (lastPipelineStage == null || !lastPipelineStage.containsKey((Object)"$out") && !lastPipelineStage.containsKey((Object)"$merge")) {
            throw new IllegalStateException("The last stage of the aggregation pipeline must be $out or $merge");
        }
        this.getExecutor().execute(this.operations.aggregateToCollection(this.pipeline, this.maxTimeMS, this.allowDiskUse, this.bypassDocumentValidation, this.collation, this.hint, this.hintString, this.comment, this.variables, this.aggregationLevel), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    @Override
    public AggregateIterable<TResult> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AggregateIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<TResult> bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public AggregateIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public AggregateIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment == null ? null : new BsonString(comment);
        return this;
    }

    @Override
    public AggregateIterable<TResult> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public AggregateIterable<TResult> hint(@Nullable Bson hint) {
        this.hint = hint;
        return this;
    }

    @Override
    public AggregateIterable<TResult> hintString(@Nullable String hint) {
        this.hintString = hint;
        return this;
    }

    @Override
    public AggregateIterable<TResult> let(@Nullable Bson variables) {
        this.variables = variables;
        return this;
    }

    @Override
    public Document explain() {
        return this.executeExplain(Document.class, null);
    }

    @Override
    public Document explain(ExplainVerbosity verbosity) {
        return this.executeExplain(Document.class, (ExplainVerbosity)Assertions.notNull((String)"verbosity", (Object)verbosity));
    }

    @Override
    public <E> E explain(Class<E> explainDocumentClass) {
        return this.executeExplain(explainDocumentClass, null);
    }

    @Override
    public <E> E explain(Class<E> explainResultClass, ExplainVerbosity verbosity) {
        return this.executeExplain(explainResultClass, (ExplainVerbosity)Assertions.notNull((String)"verbosity", (Object)verbosity));
    }

    private <E> E executeExplain(Class<E> explainResultClass, @Nullable ExplainVerbosity verbosity) {
        Assertions.notNull((String)"explainDocumentClass", explainResultClass);
        return (E)this.getExecutor().execute(this.asAggregateOperation().asExplainableOperation(verbosity, (Decoder)this.codecRegistry.get(explainResultClass)), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        MongoNamespace outNamespace = this.getOutNamespace();
        if (outNamespace != null) {
            this.getExecutor().execute(this.operations.aggregateToCollection(this.pipeline, this.maxTimeMS, this.allowDiskUse, this.bypassDocumentValidation, this.collation, this.hint, this.hintString, this.comment, this.variables, this.aggregationLevel), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
            FindOptions findOptions = new FindOptions().collation(this.collation);
            Integer batchSize = this.getBatchSize();
            if (batchSize != null) {
                findOptions.batchSize(batchSize.intValue());
            }
            return this.operations.find(outNamespace, (Bson)new BsonDocument(), this.resultClass, findOptions);
        }
        return this.asAggregateOperation();
    }

    private ExplainableReadOperation<BatchCursor<TResult>> asAggregateOperation() {
        return this.operations.aggregate(this.pipeline, this.resultClass, this.maxTimeMS, this.maxAwaitTimeMS, this.getBatchSize(), this.collation, this.hint, this.hintString, this.comment, this.variables, this.allowDiskUse, this.aggregationLevel);
    }

    @Nullable
    private BsonDocument getLastPipelineStage() {
        if (this.pipeline.isEmpty()) {
            return null;
        }
        Bson lastStage = (Bson)Assertions.notNull((String)"last pipeline stage", (Object)this.pipeline.get(this.pipeline.size() - 1));
        return lastStage.toBsonDocument(this.documentClass, this.codecRegistry);
    }

    @Nullable
    private MongoNamespace getOutNamespace() {
        BsonDocument lastPipelineStage = this.getLastPipelineStage();
        if (lastPipelineStage == null) {
            return null;
        }
        if (lastPipelineStage.containsKey((Object)"$out")) {
            if (lastPipelineStage.get((Object)"$out").isString()) {
                return new MongoNamespace(this.namespace.getDatabaseName(), lastPipelineStage.getString((Object)"$out").getValue());
            }
            if (lastPipelineStage.get((Object)"$out").isDocument()) {
                BsonDocument outDocument = lastPipelineStage.getDocument((Object)"$out");
                if (!outDocument.containsKey((Object)"db") || !outDocument.containsKey((Object)"coll")) {
                    throw new IllegalStateException("Cannot return a cursor when the value for $out stage is not a namespace document");
                }
                return new MongoNamespace(outDocument.getString((Object)"db").getValue(), outDocument.getString((Object)"coll").getValue());
            }
            throw new IllegalStateException("Cannot return a cursor when the value for $out stage is not a string or namespace document");
        }
        if (lastPipelineStage.containsKey((Object)"$merge")) {
            if (lastPipelineStage.isString((Object)"$merge")) {
                return new MongoNamespace(this.namespace.getDatabaseName(), lastPipelineStage.getString((Object)"$merge").getValue());
            }
            if (lastPipelineStage.isDocument((Object)"$merge")) {
                BsonDocument mergeDocument = lastPipelineStage.getDocument((Object)"$merge");
                if (mergeDocument.isDocument((Object)"into")) {
                    BsonDocument intoDocument = mergeDocument.getDocument((Object)"into");
                    return new MongoNamespace(intoDocument.getString((Object)"db", new BsonString(this.namespace.getDatabaseName())).getValue(), intoDocument.getString((Object)"coll").getValue());
                }
                if (mergeDocument.isString((Object)"into")) {
                    return new MongoNamespace(this.namespace.getDatabaseName(), mergeDocument.getString((Object)"into").getValue());
                }
            } else {
                throw new IllegalStateException("Cannot return a cursor when the value for $merge stage is not a string or a document");
            }
        }
        return null;
    }
}

