/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.gridfs.GridFSUploadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.internal.Locks;
import com.mongodb.lang.Nullable;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

final class GridFSUploadStreamImpl
extends GridFSUploadStream {
    private final ClientSession clientSession;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<Document> chunksCollection;
    private final BsonValue fileId;
    private final String filename;
    private final int chunkSizeBytes;
    private final Document metadata;
    private byte[] buffer;
    private long lengthInBytes;
    private int bufferOffset;
    private int chunkIndex;
    private final ReentrantLock closeLock = new ReentrantLock();
    private boolean closed = false;

    GridFSUploadStreamImpl(@Nullable ClientSession clientSession, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, BsonValue fileId, String filename, int chunkSizeBytes, @Nullable Document metadata) {
        this.clientSession = clientSession;
        this.filesCollection = (MongoCollection)Assertions.notNull((String)"files collection", filesCollection);
        this.chunksCollection = (MongoCollection)Assertions.notNull((String)"chunks collection", chunksCollection);
        this.fileId = (BsonValue)Assertions.notNull((String)"File Id", (Object)fileId);
        this.filename = (String)Assertions.notNull((String)"filename", (Object)filename);
        this.chunkSizeBytes = chunkSizeBytes;
        this.metadata = metadata;
        this.chunkIndex = 0;
        this.bufferOffset = 0;
        this.buffer = new byte[chunkSizeBytes];
    }

    @Override
    public ObjectId getObjectId() {
        if (!this.fileId.isObjectId()) {
            throw new MongoGridFSException("Custom id type used for this GridFS upload stream");
        }
        return this.fileId.asObjectId().getValue();
    }

    @Override
    public BsonValue getId() {
        return this.fileId;
    }

    @Override
    public void abort() {
        Locks.withLock((Lock)this.closeLock, () -> {
            this.checkClosed();
            this.closed = true;
        });
        if (this.clientSession != null) {
            this.chunksCollection.deleteMany(this.clientSession, (Bson)new Document("files_id", (Object)this.fileId));
        } else {
            this.chunksCollection.deleteMany((Bson)new Document("files_id", (Object)this.fileId));
        }
    }

    @Override
    public void write(int b) {
        byte[] byteArray = new byte[]{(byte)(0xFF & b)};
        this.write(byteArray, 0, 1);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.checkClosed();
        Assertions.notNull((String)"b", (Object)b);
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int currentOffset = off;
        int lengthToWrite = len;
        int amountToCopy = 0;
        while (lengthToWrite > 0) {
            amountToCopy = lengthToWrite;
            if (amountToCopy > this.chunkSizeBytes - this.bufferOffset) {
                amountToCopy = this.chunkSizeBytes - this.bufferOffset;
            }
            System.arraycopy(b, currentOffset, this.buffer, this.bufferOffset, amountToCopy);
            this.bufferOffset += amountToCopy;
            currentOffset += amountToCopy;
            lengthToWrite -= amountToCopy;
            this.lengthInBytes += (long)amountToCopy;
            if (this.bufferOffset != this.chunkSizeBytes) continue;
            this.writeChunk();
        }
    }

    @Override
    public void close() {
        boolean alreadyClosed = (Boolean)Locks.withLock((Lock)this.closeLock, () -> {
            boolean prevClosed = this.closed;
            this.closed = true;
            return prevClosed;
        });
        if (alreadyClosed) {
            return;
        }
        this.writeChunk();
        GridFSFile gridFSFile = new GridFSFile(this.fileId, this.filename, this.lengthInBytes, this.chunkSizeBytes, new Date(), this.metadata);
        if (this.clientSession != null) {
            this.filesCollection.insertOne(this.clientSession, gridFSFile);
        } else {
            this.filesCollection.insertOne(gridFSFile);
        }
        this.buffer = null;
    }

    private void writeChunk() {
        if (this.bufferOffset > 0) {
            if (this.clientSession != null) {
                this.chunksCollection.insertOne(this.clientSession, new Document("files_id", (Object)this.fileId).append("n", (Object)this.chunkIndex).append("data", (Object)this.getData()));
            } else {
                this.chunksCollection.insertOne(new Document("files_id", (Object)this.fileId).append("n", (Object)this.chunkIndex).append("data", (Object)this.getData()));
            }
            ++this.chunkIndex;
            this.bufferOffset = 0;
        }
    }

    private Binary getData() {
        if (this.bufferOffset < this.chunkSizeBytes) {
            byte[] sizedBuffer = new byte[this.bufferOffset];
            System.arraycopy(this.buffer, 0, sizedBuffer, 0, this.bufferOffset);
            this.buffer = sizedBuffer;
        }
        return new Binary(this.buffer);
    }

    private void checkClosed() {
        Locks.withLock((Lock)this.closeLock, () -> {
            if (this.closed) {
                throw new MongoGridFSException("The OutputStream has been closed");
            }
        });
    }
}

