/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.gridfs.AsyncInputStream;
import com.mongodb.async.client.gridfs.AsyncOutputStream;
import com.mongodb.async.client.gridfs.GridFSBucket;
import com.mongodb.async.client.gridfs.GridFSDownloadStream;
import com.mongodb.async.client.gridfs.GridFSDownloadStreamImpl;
import com.mongodb.async.client.gridfs.GridFSFindIterable;
import com.mongodb.async.client.gridfs.GridFSFindIterableImpl;
import com.mongodb.async.client.gridfs.GridFSIndexCheckImpl;
import com.mongodb.async.client.gridfs.GridFSUploadStream;
import com.mongodb.async.client.gridfs.GridFSUploadStreamImpl;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

final class GridFSBucketImpl
implements GridFSBucket {
    private static final Logger LOGGER = Loggers.getLogger((String)"client.gridfs");
    private static final int DEFAULT_CHUNKSIZE_BYTES = 261120;
    private static final int DEFAULT_BUFFER_SIZE = 0x400000;
    private final String bucketName;
    private final int chunkSizeBytes;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<Document> chunksCollection;

    GridFSBucketImpl(MongoDatabase database) {
        this(database, "fs");
    }

    GridFSBucketImpl(MongoDatabase database, String bucketName) {
        this((String)Assertions.notNull((String)"bucketName", (Object)bucketName), 261120, GridFSBucketImpl.getFilesCollection((MongoDatabase)Assertions.notNull((String)"database", (Object)database), bucketName), GridFSBucketImpl.getChunksCollection(database, bucketName));
    }

    GridFSBucketImpl(String bucketName, int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection) {
        this.bucketName = (String)Assertions.notNull((String)"bucketName", (Object)bucketName);
        this.chunkSizeBytes = chunkSizeBytes;
        this.filesCollection = (MongoCollection)Assertions.notNull((String)"filesCollection", filesCollection);
        this.chunksCollection = (MongoCollection)Assertions.notNull((String)"chunksCollection", chunksCollection);
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.filesCollection.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.filesCollection.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.filesCollection.getReadConcern();
    }

    @Override
    public GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.bucketName, chunkSizeBytes, this.filesCollection, this.chunksCollection);
    }

    @Override
    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference));
    }

    @Override
    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern));
    }

    @Override
    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        Assertions.notNull((String)"readConcern", (Object)readConcern);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern));
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename) {
        return this.openUploadStream((BsonValue)new BsonObjectId(), filename);
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename, GridFSUploadOptions options) {
        return this.openUploadStream((BsonValue)new BsonObjectId(), filename, options);
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue id, String filename) {
        return this.openUploadStream(id, filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue id, String filename, GridFSUploadOptions options) {
        return this.createGridFSUploadStream(null, id, filename, options);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, String filename) {
        return this.openUploadStream(clientSession, (BsonValue)new BsonObjectId(), filename);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, String filename, GridFSUploadOptions options) {
        return this.openUploadStream(clientSession, (BsonValue)new BsonObjectId(), filename, options);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue id, String filename) {
        return this.openUploadStream(clientSession, id, filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createGridFSUploadStream(clientSession, id, filename, options);
    }

    private GridFSUploadStream createGridFSUploadStream(@Nullable ClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options) {
        Assertions.notNull((String)"options", (Object)options);
        Integer chunkSizeBytes = options.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        return new GridFSUploadStreamImpl(clientSession, this.filesCollection, this.chunksCollection, id, filename, chunkSize, options.getMetadata(), new GridFSIndexCheckImpl(clientSession, this.filesCollection, this.chunksCollection));
    }

    @Override
    public void uploadFromStream(String filename, AsyncInputStream source, SingleResultCallback<ObjectId> callback) {
        this.uploadFromStream(filename, source, new GridFSUploadOptions(), callback);
    }

    @Override
    public void uploadFromStream(String filename, AsyncInputStream source, GridFSUploadOptions options, final SingleResultCallback<ObjectId> callback) {
        final BsonObjectId id = new BsonObjectId();
        this.uploadFromStream((BsonValue)id, filename, source, options, new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)id.getValue(), null);
                }
            }
        });
    }

    @Override
    public void uploadFromStream(BsonValue id, String filename, AsyncInputStream source, SingleResultCallback<Void> callback) {
        this.uploadFromStream(id, filename, source, new GridFSUploadOptions(), callback);
    }

    @Override
    public void uploadFromStream(BsonValue id, String filename, AsyncInputStream source, GridFSUploadOptions options, SingleResultCallback<Void> callback) {
        this.executeUploadFromStream(null, id, filename, source, options, callback);
    }

    @Override
    public void uploadFromStream(ClientSession clientSession, String filename, AsyncInputStream source, SingleResultCallback<ObjectId> callback) {
        this.uploadFromStream(clientSession, filename, source, new GridFSUploadOptions(), callback);
    }

    @Override
    public void uploadFromStream(ClientSession clientSession, String filename, AsyncInputStream source, GridFSUploadOptions options, final SingleResultCallback<ObjectId> callback) {
        final BsonObjectId id = new BsonObjectId();
        this.uploadFromStream(clientSession, (BsonValue)id, filename, source, options, new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)id.getValue(), null);
                }
            }
        });
    }

    @Override
    public void uploadFromStream(ClientSession clientSession, BsonValue id, String filename, AsyncInputStream source, SingleResultCallback<Void> callback) {
        this.uploadFromStream(clientSession, id, filename, source, new GridFSUploadOptions(), callback);
    }

    @Override
    public void uploadFromStream(ClientSession clientSession, BsonValue id, String filename, AsyncInputStream source, GridFSUploadOptions options, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeUploadFromStream(clientSession, id, filename, source, options, callback);
    }

    private void executeUploadFromStream(@Nullable ClientSession clientSession, BsonValue id, String filename, AsyncInputStream source, GridFSUploadOptions options, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"filename", (Object)filename);
        Assertions.notNull((String)"source", (Object)source);
        Assertions.notNull((String)"options", (Object)options);
        Assertions.notNull((String)"callback", callback);
        Integer chunkSizeBytes = options.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        GridFSUploadStream uploadStream = clientSession != null ? this.openUploadStream(clientSession, id, filename, options) : this.openUploadStream(id, filename, options);
        this.readAndWriteInputStream(source, uploadStream, ByteBuffer.allocate(chunkSize), (SingleResultCallback<Void>)ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ObjectId id) {
        Assertions.notNull((String)"id", (Object)id);
        return this.createGridFSDownloadStream(null, this.find((Bson)new Document("_id", (Object)id)));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(BsonValue id) {
        Assertions.notNull((String)"id", (Object)id);
        return this.createGridFSDownloadStream(null, this.find((Bson)new Document("_id", (Object)id)));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String filename) {
        return this.openDownloadStream(filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String filename, GridFSDownloadOptions options) {
        return this.createGridFSDownloadStream(null, this.createGridFSFindIterable(null, filename, options));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, ObjectId id) {
        Assertions.notNull((String)"id", (Object)id);
        return this.createGridFSDownloadStream(clientSession, this.find(clientSession, (Bson)new Document("_id", (Object)id)));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, BsonValue id) {
        Assertions.notNull((String)"id", (Object)id);
        return this.createGridFSDownloadStream(clientSession, this.find(clientSession, (Bson)new Document("_id", (Object)id)));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String filename) {
        return this.openDownloadStream(clientSession, filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String filename, GridFSDownloadOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createGridFSDownloadStream(clientSession, this.createGridFSFindIterable(clientSession, filename, options));
    }

    private GridFSDownloadStream createGridFSDownloadStream(@Nullable ClientSession clientSession, GridFSFindIterable gridFSFindIterable) {
        return new GridFSDownloadStreamImpl(clientSession, gridFSFindIterable, this.chunksCollection);
    }

    @Override
    public void downloadToStream(String filename, AsyncOutputStream destination, SingleResultCallback<Long> callback) {
        this.downloadToStream(filename, destination, new GridFSDownloadOptions(), callback);
    }

    @Override
    public void downloadToStream(String filename, AsyncOutputStream destination, GridFSDownloadOptions options, SingleResultCallback<Long> callback) {
        this.downloadToAsyncOutputStream(this.openDownloadStream(filename, options), destination, (SingleResultCallback<Long>)ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER));
    }

    @Override
    public void downloadToStream(ObjectId id, AsyncOutputStream destination, SingleResultCallback<Long> callback) {
        this.downloadToAsyncOutputStream(this.openDownloadStream(id), destination, (SingleResultCallback<Long>)ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER));
    }

    @Override
    public void downloadToStream(BsonValue id, AsyncOutputStream destination, SingleResultCallback<Long> callback) {
        this.downloadToAsyncOutputStream(this.openDownloadStream(id), destination, (SingleResultCallback<Long>)ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER));
    }

    @Override
    public void downloadToStream(ClientSession clientSession, ObjectId id, AsyncOutputStream destination, SingleResultCallback<Long> callback) {
        this.downloadToAsyncOutputStream(this.openDownloadStream(clientSession, id), destination, (SingleResultCallback<Long>)ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER));
    }

    @Override
    public void downloadToStream(ClientSession clientSession, BsonValue id, AsyncOutputStream destination, SingleResultCallback<Long> callback) {
        this.downloadToAsyncOutputStream(this.openDownloadStream(clientSession, id), destination, (SingleResultCallback<Long>)ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER));
    }

    @Override
    public void downloadToStream(ClientSession clientSession, String filename, AsyncOutputStream destination, SingleResultCallback<Long> callback) {
        this.downloadToStream(clientSession, filename, destination, new GridFSDownloadOptions(), callback);
    }

    @Override
    public void downloadToStream(ClientSession clientSession, String filename, AsyncOutputStream destination, GridFSDownloadOptions options, SingleResultCallback<Long> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.downloadToAsyncOutputStream(this.openDownloadStream(clientSession, filename, options), destination, (SingleResultCallback<Long>)ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER));
    }

    @Override
    public GridFSFindIterable find() {
        return this.createGridFSFindIterable(null, null);
    }

    @Override
    public GridFSFindIterable find(Bson filter) {
        Assertions.notNull((String)"filter", (Object)filter);
        return this.createGridFSFindIterable(null, filter);
    }

    @Override
    public GridFSFindIterable find(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createGridFSFindIterable(clientSession, null);
    }

    @Override
    public GridFSFindIterable find(ClientSession clientSession, Bson filter) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        Assertions.notNull((String)"filter", (Object)filter);
        return this.createGridFSFindIterable(clientSession, filter);
    }

    @Override
    public void delete(ObjectId id, SingleResultCallback<Void> callback) {
        this.delete((BsonValue)new BsonObjectId(id), callback);
    }

    @Override
    public void delete(BsonValue id, SingleResultCallback<Void> callback) {
        this.executeDelete(null, id, callback);
    }

    @Override
    public void delete(ClientSession clientSession, ObjectId id, SingleResultCallback<Void> callback) {
        this.delete(clientSession, (BsonValue)new BsonObjectId(id), callback);
    }

    @Override
    public void delete(ClientSession clientSession, BsonValue id, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDelete(clientSession, id, callback);
    }

    private void executeDelete(final @Nullable ClientSession clientSession, final BsonValue id, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"id", (Object)id);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        SingleResultCallback<DeleteResult> deleteFileCallback = new SingleResultCallback<DeleteResult>(){

            public void onResult(final DeleteResult filesResult, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    SingleResultCallback<DeleteResult> deleteChunksCallback = new SingleResultCallback<DeleteResult>(){

                        public void onResult(DeleteResult chunksResult, Throwable t) {
                            if (t != null) {
                                errHandlingCallback.onResult(null, t);
                            } else if (filesResult.wasAcknowledged() && filesResult.getDeletedCount() == 0L) {
                                errHandlingCallback.onResult(null, (Throwable)new MongoGridFSException(String.format("No file found with the ObjectId: %s", id)));
                            } else {
                                errHandlingCallback.onResult(null, null);
                            }
                        }
                    };
                    if (clientSession != null) {
                        GridFSBucketImpl.this.chunksCollection.deleteMany(clientSession, (Bson)new BsonDocument("files_id", id), deleteChunksCallback);
                    } else {
                        GridFSBucketImpl.this.chunksCollection.deleteMany((Bson)new BsonDocument("files_id", id), deleteChunksCallback);
                    }
                }
            }
        };
        if (clientSession != null) {
            this.filesCollection.deleteOne(clientSession, (Bson)new BsonDocument("_id", id), deleteFileCallback);
        } else {
            this.filesCollection.deleteOne((Bson)new BsonDocument("_id", id), deleteFileCallback);
        }
    }

    @Override
    public void rename(ObjectId id, String newFilename, SingleResultCallback<Void> callback) {
        this.rename((BsonValue)new BsonObjectId(id), newFilename, callback);
    }

    @Override
    public void rename(BsonValue id, String newFilename, SingleResultCallback<Void> callback) {
        this.executeRename(null, id, newFilename, callback);
    }

    @Override
    public void rename(ClientSession clientSession, ObjectId id, String newFilename, SingleResultCallback<Void> callback) {
        this.rename(clientSession, (BsonValue)new BsonObjectId(id), newFilename, callback);
    }

    @Override
    public void rename(ClientSession clientSession, BsonValue id, String newFilename, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeRename(clientSession, id, newFilename, callback);
    }

    private void executeRename(@Nullable ClientSession clientSession, final BsonValue id, String newFilename, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"id", (Object)id);
        Assertions.notNull((String)"newFilename", (Object)newFilename);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        SingleResultCallback<UpdateResult> resultCallback = new SingleResultCallback<UpdateResult>(){

            public void onResult(UpdateResult result, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else if (result.wasAcknowledged() && result.getMatchedCount() == 0L) {
                    errHandlingCallback.onResult(null, (Throwable)new MongoGridFSException(String.format("No file found with the ObjectId: %s", id)));
                } else {
                    errHandlingCallback.onResult(null, null);
                }
            }
        };
        if (clientSession != null) {
            this.filesCollection.updateOne(clientSession, (Bson)new BsonDocument("_id", id), (Bson)new BsonDocument("$set", (BsonValue)new BsonDocument("filename", (BsonValue)new BsonString(newFilename))), resultCallback);
        } else {
            this.filesCollection.updateOne((Bson)new BsonDocument("_id", id), (Bson)new BsonDocument("$set", (BsonValue)new BsonDocument("filename", (BsonValue)new BsonString(newFilename))), resultCallback);
        }
    }

    @Override
    public void drop(SingleResultCallback<Void> callback) {
        this.executeDrop(null, callback);
    }

    @Override
    public void drop(ClientSession clientSession, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDrop(clientSession, callback);
    }

    private void executeDrop(final @Nullable ClientSession clientSession, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        SingleResultCallback<Void> dropFileCallback = new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else if (clientSession != null) {
                    GridFSBucketImpl.this.chunksCollection.drop(clientSession, (SingleResultCallback<Void>)errHandlingCallback);
                } else {
                    GridFSBucketImpl.this.chunksCollection.drop((SingleResultCallback<Void>)errHandlingCallback);
                }
            }
        };
        if (clientSession != null) {
            this.filesCollection.drop(clientSession, dropFileCallback);
        } else {
            this.filesCollection.drop(dropFileCallback);
        }
    }

    private GridFSFindIterable createGridFSFindIterable(@Nullable ClientSession clientSession, @Nullable Bson filter) {
        return new GridFSFindIterableImpl(this.createFindIterable(clientSession, filter));
    }

    private GridFSFindIterable createGridFSFindIterable(@Nullable ClientSession clientSession, String filename, GridFSDownloadOptions options) {
        int sort;
        int skip;
        int revision = options.getRevision();
        if (revision >= 0) {
            skip = revision;
            sort = 1;
        } else {
            skip = -revision - 1;
            sort = -1;
        }
        return this.createGridFSFindIterable(clientSession, (Bson)new Document("filename", (Object)filename)).skip(skip).sort((Bson)new Document("uploadDate", (Object)sort));
    }

    private FindIterable<GridFSFile> createFindIterable(@Nullable ClientSession clientSession, @Nullable Bson filter) {
        FindIterable<GridFSFile> findIterable = clientSession != null ? this.filesCollection.find(clientSession) : this.filesCollection.find();
        if (filter != null) {
            findIterable = findIterable.filter(filter);
        }
        return findIterable;
    }

    private static MongoCollection<GridFSFile> getFilesCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".files", GridFSFile.class).withCodecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{database.getCodecRegistry(), MongoClients.getDefaultCodecRegistry()}));
    }

    private static MongoCollection<Document> getChunksCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".chunks").withCodecRegistry(MongoClients.getDefaultCodecRegistry());
    }

    private void downloadToAsyncOutputStream(final GridFSDownloadStream downloadStream, final AsyncOutputStream destination, final SingleResultCallback<Long> callback) {
        Assertions.notNull((String)"downloadStream", (Object)downloadStream);
        downloadStream.getGridFSFile(new SingleResultCallback<GridFSFile>(){

            public void onResult(GridFSFile result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    int bufferSize = 0x400000L > result.getLength() ? (int)result.getLength() : 0x400000;
                    GridFSBucketImpl.this.readAndWriteOutputStream(destination, downloadStream, ByteBuffer.allocate(bufferSize), 0L, (SingleResultCallback<Long>)callback);
                }
            }
        });
    }

    private void readAndWriteInputStream(final AsyncInputStream source, final GridFSUploadStream uploadStream, final ByteBuffer buffer, final SingleResultCallback<Void> callback) {
        ((Buffer)buffer).clear();
        source.read(buffer, new SingleResultCallback<Integer>(){

            public void onResult(Integer result, final Throwable t) {
                if (t != null) {
                    if (t instanceof IOException) {
                        uploadStream.abort(new SingleResultCallback<Void>(){

                            public void onResult(Void result, Throwable abortException) {
                                if (abortException != null) {
                                    callback.onResult(null, abortException);
                                } else {
                                    callback.onResult(null, (Throwable)new MongoGridFSException("IOException when reading from the InputStream", t));
                                }
                            }
                        });
                    } else {
                        callback.onResult(null, t);
                    }
                } else if (result > 0) {
                    ((Buffer)buffer).flip();
                    uploadStream.write(buffer, new SingleResultCallback<Integer>(){

                        public void onResult(Integer result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                GridFSBucketImpl.this.readAndWriteInputStream(source, uploadStream, buffer, (SingleResultCallback<Void>)callback);
                            }
                        }
                    });
                } else {
                    uploadStream.close((SingleResultCallback<Void>)callback);
                }
            }
        });
    }

    private void readAndWriteOutputStream(final AsyncOutputStream destination, final GridFSDownloadStream downloadStream, final ByteBuffer buffer, final long amountRead, final SingleResultCallback<Long> callback) {
        ((Buffer)buffer).clear();
        downloadStream.read(buffer, new SingleResultCallback<Integer>(){

            public void onResult(Integer readResult, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (readResult > 0) {
                    ((Buffer)buffer).flip();
                    destination.write(buffer, new SingleResultCallback<Integer>(){

                        public void onResult(Integer writeResult, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                GridFSBucketImpl.this.readAndWriteOutputStream(destination, downloadStream, buffer, amountRead + (long)writeResult.intValue(), (SingleResultCallback<Long>)callback);
                            }
                        }
                    });
                } else {
                    callback.onResult((Object)amountRead, null);
                }
            }
        });
    }
}

