/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.ChangeStreamIterable;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.DistinctIterable;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.ListIndexesIterable;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@ThreadSafe
public interface MongoCollection<TDocument> {
    public MongoNamespace getNamespace();

    public Class<TDocument> getDocumentClass();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> var1);

    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry var1);

    public MongoCollection<TDocument> withReadPreference(ReadPreference var1);

    public MongoCollection<TDocument> withWriteConcern(WriteConcern var1);

    public MongoCollection<TDocument> withReadConcern(ReadConcern var1);

    public void count(SingleResultCallback<Long> var1);

    public void count(Bson var1, SingleResultCallback<Long> var2);

    public void count(Bson var1, CountOptions var2, SingleResultCallback<Long> var3);

    public void count(ClientSession var1, SingleResultCallback<Long> var2);

    public void count(ClientSession var1, Bson var2, SingleResultCallback<Long> var3);

    public void count(ClientSession var1, Bson var2, CountOptions var3, SingleResultCallback<Long> var4);

    public <TResult> DistinctIterable<TResult> distinct(String var1, Class<TResult> var2);

    public <TResult> DistinctIterable<TResult> distinct(String var1, Bson var2, Class<TResult> var3);

    public <TResult> DistinctIterable<TResult> distinct(ClientSession var1, String var2, Class<TResult> var3);

    public <TResult> DistinctIterable<TResult> distinct(ClientSession var1, String var2, Bson var3, Class<TResult> var4);

    public FindIterable<TDocument> find();

    public <TResult> FindIterable<TResult> find(Class<TResult> var1);

    public FindIterable<TDocument> find(Bson var1);

    public <TResult> FindIterable<TResult> find(Bson var1, Class<TResult> var2);

    public FindIterable<TDocument> find(ClientSession var1);

    public <TResult> FindIterable<TResult> find(ClientSession var1, Class<TResult> var2);

    public FindIterable<TDocument> find(ClientSession var1, Bson var2);

    public <TResult> FindIterable<TResult> find(ClientSession var1, Bson var2, Class<TResult> var3);

    public AggregateIterable<TDocument> aggregate(List<? extends Bson> var1);

    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public AggregateIterable<TDocument> aggregate(ClientSession var1, List<? extends Bson> var2);

    public <TResult> AggregateIterable<TResult> aggregate(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public ChangeStreamIterable<TDocument> watch();

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> var1);

    public ChangeStreamIterable<TDocument> watch(List<? extends Bson> var1);

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public ChangeStreamIterable<TDocument> watch(ClientSession var1);

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession var1, Class<TResult> var2);

    public ChangeStreamIterable<TDocument> watch(ClientSession var1, List<? extends Bson> var2);

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public MapReduceIterable<TDocument> mapReduce(String var1, String var2);

    public <TResult> MapReduceIterable<TResult> mapReduce(String var1, String var2, Class<TResult> var3);

    public MapReduceIterable<TDocument> mapReduce(ClientSession var1, String var2, String var3);

    public <TResult> MapReduceIterable<TResult> mapReduce(ClientSession var1, String var2, String var3, Class<TResult> var4);

    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, SingleResultCallback<BulkWriteResult> var2);

    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, BulkWriteOptions var2, SingleResultCallback<BulkWriteResult> var3);

    public void bulkWrite(ClientSession var1, List<? extends WriteModel<? extends TDocument>> var2, SingleResultCallback<BulkWriteResult> var3);

    public void bulkWrite(ClientSession var1, List<? extends WriteModel<? extends TDocument>> var2, BulkWriteOptions var3, SingleResultCallback<BulkWriteResult> var4);

    public void insertOne(TDocument var1, SingleResultCallback<Void> var2);

    public void insertOne(TDocument var1, InsertOneOptions var2, SingleResultCallback<Void> var3);

    public void insertOne(ClientSession var1, TDocument var2, SingleResultCallback<Void> var3);

    public void insertOne(ClientSession var1, TDocument var2, InsertOneOptions var3, SingleResultCallback<Void> var4);

    public void insertMany(List<? extends TDocument> var1, SingleResultCallback<Void> var2);

    public void insertMany(List<? extends TDocument> var1, InsertManyOptions var2, SingleResultCallback<Void> var3);

    public void insertMany(ClientSession var1, List<? extends TDocument> var2, SingleResultCallback<Void> var3);

    public void insertMany(ClientSession var1, List<? extends TDocument> var2, InsertManyOptions var3, SingleResultCallback<Void> var4);

    public void deleteOne(Bson var1, SingleResultCallback<DeleteResult> var2);

    public void deleteOne(Bson var1, DeleteOptions var2, SingleResultCallback<DeleteResult> var3);

    public void deleteOne(ClientSession var1, Bson var2, SingleResultCallback<DeleteResult> var3);

    public void deleteOne(ClientSession var1, Bson var2, DeleteOptions var3, SingleResultCallback<DeleteResult> var4);

    public void deleteMany(Bson var1, SingleResultCallback<DeleteResult> var2);

    public void deleteMany(Bson var1, DeleteOptions var2, SingleResultCallback<DeleteResult> var3);

    public void deleteMany(ClientSession var1, Bson var2, SingleResultCallback<DeleteResult> var3);

    public void deleteMany(ClientSession var1, Bson var2, DeleteOptions var3, SingleResultCallback<DeleteResult> var4);

    public void replaceOne(Bson var1, TDocument var2, SingleResultCallback<UpdateResult> var3);

    @Deprecated
    public void replaceOne(Bson var1, TDocument var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void replaceOne(Bson var1, TDocument var2, ReplaceOptions var3, SingleResultCallback<UpdateResult> var4);

    public void replaceOne(ClientSession var1, Bson var2, TDocument var3, SingleResultCallback<UpdateResult> var4);

    @Deprecated
    public void replaceOne(ClientSession var1, Bson var2, TDocument var3, UpdateOptions var4, SingleResultCallback<UpdateResult> var5);

    public void replaceOne(ClientSession var1, Bson var2, TDocument var3, ReplaceOptions var4, SingleResultCallback<UpdateResult> var5);

    public void updateOne(Bson var1, Bson var2, SingleResultCallback<UpdateResult> var3);

    public void updateOne(Bson var1, Bson var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void updateOne(ClientSession var1, Bson var2, Bson var3, SingleResultCallback<UpdateResult> var4);

    public void updateOne(ClientSession var1, Bson var2, Bson var3, UpdateOptions var4, SingleResultCallback<UpdateResult> var5);

    public void updateMany(Bson var1, Bson var2, SingleResultCallback<UpdateResult> var3);

    public void updateMany(Bson var1, Bson var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void updateMany(ClientSession var1, Bson var2, Bson var3, SingleResultCallback<UpdateResult> var4);

    public void updateMany(ClientSession var1, Bson var2, Bson var3, UpdateOptions var4, SingleResultCallback<UpdateResult> var5);

    public void findOneAndDelete(Bson var1, SingleResultCallback<TDocument> var2);

    public void findOneAndDelete(Bson var1, FindOneAndDeleteOptions var2, SingleResultCallback<TDocument> var3);

    public void findOneAndDelete(ClientSession var1, Bson var2, SingleResultCallback<TDocument> var3);

    public void findOneAndDelete(ClientSession var1, Bson var2, FindOneAndDeleteOptions var3, SingleResultCallback<TDocument> var4);

    public void findOneAndReplace(Bson var1, TDocument var2, SingleResultCallback<TDocument> var3);

    public void findOneAndReplace(Bson var1, TDocument var2, FindOneAndReplaceOptions var3, SingleResultCallback<TDocument> var4);

    public void findOneAndReplace(ClientSession var1, Bson var2, TDocument var3, SingleResultCallback<TDocument> var4);

    public void findOneAndReplace(ClientSession var1, Bson var2, TDocument var3, FindOneAndReplaceOptions var4, SingleResultCallback<TDocument> var5);

    public void findOneAndUpdate(Bson var1, Bson var2, SingleResultCallback<TDocument> var3);

    public void findOneAndUpdate(Bson var1, Bson var2, FindOneAndUpdateOptions var3, SingleResultCallback<TDocument> var4);

    public void findOneAndUpdate(ClientSession var1, Bson var2, Bson var3, SingleResultCallback<TDocument> var4);

    public void findOneAndUpdate(ClientSession var1, Bson var2, Bson var3, FindOneAndUpdateOptions var4, SingleResultCallback<TDocument> var5);

    public void drop(SingleResultCallback<Void> var1);

    public void drop(ClientSession var1, SingleResultCallback<Void> var2);

    public void createIndex(Bson var1, SingleResultCallback<String> var2);

    public void createIndex(Bson var1, IndexOptions var2, SingleResultCallback<String> var3);

    public void createIndex(ClientSession var1, Bson var2, SingleResultCallback<String> var3);

    public void createIndex(ClientSession var1, Bson var2, IndexOptions var3, SingleResultCallback<String> var4);

    public void createIndexes(List<IndexModel> var1, SingleResultCallback<List<String>> var2);

    public void createIndexes(List<IndexModel> var1, CreateIndexOptions var2, SingleResultCallback<List<String>> var3);

    public void createIndexes(ClientSession var1, List<IndexModel> var2, SingleResultCallback<List<String>> var3);

    public void createIndexes(ClientSession var1, List<IndexModel> var2, CreateIndexOptions var3, SingleResultCallback<List<String>> var4);

    public ListIndexesIterable<Document> listIndexes();

    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> var1);

    public ListIndexesIterable<Document> listIndexes(ClientSession var1);

    public <TResult> ListIndexesIterable<TResult> listIndexes(ClientSession var1, Class<TResult> var2);

    public void dropIndex(String var1, SingleResultCallback<Void> var2);

    public void dropIndex(String var1, DropIndexOptions var2, SingleResultCallback<Void> var3);

    public void dropIndex(Bson var1, SingleResultCallback<Void> var2);

    public void dropIndex(Bson var1, DropIndexOptions var2, SingleResultCallback<Void> var3);

    public void dropIndex(ClientSession var1, String var2, SingleResultCallback<Void> var3);

    public void dropIndex(ClientSession var1, String var2, DropIndexOptions var3, SingleResultCallback<Void> var4);

    public void dropIndex(ClientSession var1, Bson var2, SingleResultCallback<Void> var3);

    public void dropIndex(ClientSession var1, Bson var2, DropIndexOptions var3, SingleResultCallback<Void> var4);

    public void dropIndexes(SingleResultCallback<Void> var1);

    public void dropIndexes(DropIndexOptions var1, SingleResultCallback<Void> var2);

    public void dropIndexes(ClientSession var1, SingleResultCallback<Void> var2);

    public void dropIndexes(ClientSession var1, DropIndexOptions var2, SingleResultCallback<Void> var3);

    public void renameCollection(MongoNamespace var1, SingleResultCallback<Void> var2);

    public void renameCollection(MongoNamespace var1, RenameCollectionOptions var2, SingleResultCallback<Void> var3);

    public void renameCollection(ClientSession var1, MongoNamespace var2, SingleResultCallback<Void> var3);

    public void renameCollection(ClientSession var1, MongoNamespace var2, RenameCollectionOptions var3, SingleResultCallback<Void> var4);
}

