/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.gridfs;

import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.ListIndexesIterable;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.gridfs.GridFSIndexCheck;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.session.ClientSession;
import java.util.ArrayList;
import org.bson.Document;
import org.bson.conversions.Bson;

final class GridFSIndexCheckImpl
implements GridFSIndexCheck {
    private static final Document PROJECTION = new Document("_id", (Object)1);
    private final ClientSession clientSession;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<Document> chunksCollection;

    GridFSIndexCheckImpl(ClientSession clientSession, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection) {
        this.clientSession = clientSession;
        this.filesCollection = (MongoCollection)Assertions.notNull((String)"files collection", filesCollection);
        this.chunksCollection = (MongoCollection)Assertions.notNull((String)"chunks collection", chunksCollection);
    }

    @Override
    public void checkAndCreateIndex(final SingleResultCallback<Void> callback) {
        MongoCollection<Document> collection = this.filesCollection.withDocumentClass(Document.class).withReadPreference(ReadPreference.primary());
        FindIterable<Document> findIterable = this.clientSession != null ? collection.find(this.clientSession) : collection.find();
        findIterable.projection((Bson)PROJECTION).first(new SingleResultCallback<Document>(){

            public void onResult(Document result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (result == null) {
                    GridFSIndexCheckImpl.this.checkFilesIndex((SingleResultCallback<Void>)callback);
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }

    private <T> void hasIndex(MongoCollection<T> collection, final Document index, final SingleResultCallback<Boolean> callback) {
        ListIndexesIterable<Document> listIndexesIterable = this.clientSession != null ? collection.listIndexes(this.clientSession) : collection.listIndexes();
        listIndexesIterable.into(new ArrayList(), new SingleResultCallback<ArrayList<Document>>(){

            public void onResult(ArrayList<Document> indexes, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    boolean hasIndex = false;
                    for (Document indexDoc : indexes) {
                        if (!((Document)indexDoc.get((Object)"key", Document.class)).equals((Object)index)) continue;
                        hasIndex = true;
                        break;
                    }
                    callback.onResult((Object)hasIndex, null);
                }
            }
        });
    }

    private void checkFilesIndex(final SingleResultCallback<Void> callback) {
        final Document filesIndex = new Document("filename", (Object)1).append("uploadDate", (Object)1);
        this.hasIndex(this.filesCollection.withReadPreference(ReadPreference.primary()), filesIndex, new SingleResultCallback<Boolean>(){

            public void onResult(Boolean result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (!result.booleanValue()) {
                    SingleResultCallback<String> createIndexCallback = new SingleResultCallback<String>(){

                        public void onResult(String result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                GridFSIndexCheckImpl.this.checkChunksIndex((SingleResultCallback<Void>)callback);
                            }
                        }
                    };
                    if (GridFSIndexCheckImpl.this.clientSession != null) {
                        GridFSIndexCheckImpl.this.filesCollection.createIndex(GridFSIndexCheckImpl.this.clientSession, (Bson)filesIndex, createIndexCallback);
                    } else {
                        GridFSIndexCheckImpl.this.filesCollection.createIndex((Bson)filesIndex, createIndexCallback);
                    }
                } else {
                    GridFSIndexCheckImpl.this.checkChunksIndex((SingleResultCallback<Void>)callback);
                }
            }
        });
    }

    private void checkChunksIndex(final SingleResultCallback<Void> callback) {
        final Document chunksIndex = new Document("files_id", (Object)1).append("n", (Object)1);
        this.hasIndex(this.chunksCollection.withReadPreference(ReadPreference.primary()), chunksIndex, new SingleResultCallback<Boolean>(){

            public void onResult(Boolean result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (!result.booleanValue()) {
                    SingleResultCallback<String> createIndexCallback = new SingleResultCallback<String>(){

                        public void onResult(String result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                callback.onResult(null, null);
                            }
                        }
                    };
                    if (GridFSIndexCheckImpl.this.clientSession != null) {
                        GridFSIndexCheckImpl.this.chunksCollection.createIndex(GridFSIndexCheckImpl.this.clientSession, (Bson)chunksIndex, new IndexOptions().unique(true), createIndexCallback);
                    } else {
                        GridFSIndexCheckImpl.this.chunksCollection.createIndex((Bson)chunksIndex, new IndexOptions().unique(true), createIndexCallback);
                    }
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }
}

