/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MappingAsyncBatchCursor;
import com.mongodb.async.client.MongoIterable;
import java.util.Collection;
import org.bson.assertions.Assertions;

class MappingIterable<U, V>
implements MongoIterable<V> {
    private final MongoIterable<U> iterable;
    private final Function<U, V> mapper;

    MappingIterable(MongoIterable<U> iterable, Function<U, V> mapper) {
        this.iterable = (MongoIterable)Assertions.notNull((String)"iterable", iterable);
        this.mapper = (Function)Assertions.notNull((String)"mapper", mapper);
    }

    MongoIterable<U> getMapped() {
        return this.iterable;
    }

    @Override
    public void first(final SingleResultCallback<V> callback) {
        Assertions.notNull((String)"callback", callback);
        this.iterable.first(new SingleResultCallback<U>(){

            public void onResult(U result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(MappingIterable.this.mapper.apply(result), null);
                }
            }
        });
    }

    @Override
    public void forEach(final Block<? super V> block, final SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"block", block);
        Assertions.notNull((String)"callback", callback);
        this.iterable.forEach(new Block<U>(){

            public void apply(U t) {
                block.apply(MappingIterable.this.mapper.apply(t));
            }
        }, new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }

    @Override
    public <A extends Collection<? super V>> void into(final A target, final SingleResultCallback<A> callback) {
        Assertions.notNull((String)"target", target);
        Assertions.notNull((String)"callback", callback);
        this.iterable.forEach(new Block<U>(){

            public void apply(U t) {
                target.add(MappingIterable.this.mapper.apply(t));
            }
        }, new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)target, null);
                }
            }
        });
    }

    @Override
    public <W> MongoIterable<W> map(Function<V, W> mapper) {
        return new MappingIterable<V, W>(this, mapper);
    }

    @Override
    public MongoIterable<V> batchSize(int batchSize) {
        this.iterable.batchSize(batchSize);
        return this;
    }

    @Override
    public void batchCursor(final SingleResultCallback<AsyncBatchCursor<V>> callback) {
        Assertions.notNull((String)"callback", callback);
        this.iterable.batchCursor(new SingleResultCallback<AsyncBatchCursor<U>>(){

            public void onResult(AsyncBatchCursor<U> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new MappingAsyncBatchCursor(batchCursor, MappingIterable.this.mapper), null);
                }
            }
        });
    }
}

