/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ListIndexesIterable;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationIterable;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.ListIndexesOperation;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;

final class ListIndexesIterableImpl<TResult>
implements ListIndexesIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TResult> resultClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final AsyncOperationExecutor executor;
    private int batchSize;
    private long maxTimeMS;

    ListIndexesIterableImpl(MongoNamespace namespace, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, AsyncOperationExecutor executor) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public ListIndexesIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListIndexesIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public void first(SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"callback", callback);
        this.execute(this.createListIndexesOperation().batchSize(-1)).first(callback);
    }

    @Override
    public void forEach(Block<? super TResult> block, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"block", block);
        Assertions.notNull((String)"callback", callback);
        this.execute().forEach(block, callback);
    }

    @Override
    public <A extends Collection<? super TResult>> void into(A target, SingleResultCallback<A> callback) {
        Assertions.notNull((String)"target", target);
        Assertions.notNull((String)"callback", callback);
        this.execute().into(target, callback);
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<TResult>> callback) {
        Assertions.notNull((String)"callback", callback);
        this.execute().batchCursor(callback);
    }

    private MongoIterable<TResult> execute() {
        return this.execute(this.createListIndexesOperation());
    }

    private MongoIterable<TResult> execute(ListIndexesOperation<TResult> operation) {
        return new OperationIterable(operation, this.readPreference, this.executor);
    }

    private ListIndexesOperation<TResult> createListIndexesOperation() {
        return new ListIndexesOperation(this.namespace, (Decoder)this.codecRegistry.get(this.resultClass)).batchSize(this.batchSize).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }
}

