/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.gridfs.helpers;

import com.mongodb.MongoGridFSException;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.gridfs.AsyncInputStream;
import com.mongodb.async.client.gridfs.AsyncOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.bson.assertions.Assertions;

public final class AsyncStreamHelper {
    public static AsyncInputStream toAsyncInputStream(byte[] srcBytes) {
        return AsyncStreamHelper.toAsyncInputStream(ByteBuffer.wrap(srcBytes));
    }

    public static AsyncOutputStream toAsyncOutputStream(byte[] dstBytes) {
        return AsyncStreamHelper.toAsyncOutputStream(ByteBuffer.wrap(dstBytes));
    }

    public static AsyncInputStream toAsyncInputStream(final ByteBuffer srcByteBuffer) {
        Assertions.notNull((String)"srcByteBuffer", (Object)srcByteBuffer);
        return new AsyncInputStream(){

            @Override
            public void read(ByteBuffer dstByteBuffer, SingleResultCallback<Integer> callback) {
                AsyncStreamHelper.transferDataFromByteBuffers(srcByteBuffer, dstByteBuffer, (SingleResultCallback<Integer>)callback);
            }

            @Override
            public void close(SingleResultCallback<Void> callback) {
                callback.onResult(null, null);
            }
        };
    }

    public static AsyncOutputStream toAsyncOutputStream(final ByteBuffer dstByteBuffer) {
        Assertions.notNull((String)"dstByteBuffer", (Object)dstByteBuffer);
        return new AsyncOutputStream(){

            @Override
            public void write(ByteBuffer srcByteBuffer, SingleResultCallback<Integer> callback) {
                AsyncStreamHelper.transferDataFromByteBuffers(srcByteBuffer, dstByteBuffer, (SingleResultCallback<Integer>)callback);
            }

            @Override
            public void close(SingleResultCallback<Void> callback) {
                callback.onResult(null, null);
            }
        };
    }

    public static AsyncInputStream toAsyncInputStream(final InputStream inputStream) {
        Assertions.notNull((String)"inputStream", (Object)inputStream);
        return new AsyncInputStream(){

            @Override
            public void read(ByteBuffer dstByteBuffer, SingleResultCallback<Integer> callback) {
                int amountRead;
                Assertions.notNull((String)"dst", (Object)dstByteBuffer);
                Assertions.notNull((String)"callback", callback);
                if (!dstByteBuffer.hasRemaining()) {
                    callback.onResult((Object)-1, null);
                    return;
                }
                int maxAmount = dstByteBuffer.remaining();
                byte[] bytes = new byte[maxAmount];
                try {
                    amountRead = inputStream.read(bytes);
                }
                catch (Throwable t) {
                    callback.onResult(null, (Throwable)new MongoGridFSException("Error reading from input stream", t));
                    return;
                }
                if (amountRead > 0) {
                    if (amountRead < maxAmount) {
                        byte[] dataRead = new byte[amountRead];
                        System.arraycopy(bytes, 0, dataRead, 0, amountRead);
                        dstByteBuffer.put(dataRead);
                    } else {
                        dstByteBuffer.put(bytes);
                    }
                }
                callback.onResult((Object)amountRead, null);
            }

            @Override
            public void close(SingleResultCallback<Void> callback) {
                try {
                    inputStream.close();
                }
                catch (Throwable t) {
                    callback.onResult(null, (Throwable)new MongoGridFSException("Error closing input stream", t));
                    return;
                }
                callback.onResult(null, null);
            }
        };
    }

    public static AsyncOutputStream toAsyncOutputStream(final OutputStream outputStream) {
        Assertions.notNull((String)"outputStream", (Object)outputStream);
        return new AsyncOutputStream(){

            @Override
            public void write(ByteBuffer srcByteBuffer, SingleResultCallback<Integer> callback) {
                Assertions.notNull((String)"src", (Object)srcByteBuffer);
                Assertions.notNull((String)"callback", callback);
                if (!srcByteBuffer.hasRemaining()) {
                    callback.onResult((Object)-1, null);
                    return;
                }
                int amount = srcByteBuffer.remaining();
                byte[] bytes = new byte[amount];
                try {
                    srcByteBuffer.get(bytes);
                    outputStream.write(bytes);
                }
                catch (Throwable t) {
                    callback.onResult(null, (Throwable)new MongoGridFSException("Error reading from input stream", t));
                    return;
                }
                callback.onResult((Object)amount, null);
            }

            @Override
            public void close(SingleResultCallback<Void> callback) {
                try {
                    outputStream.close();
                }
                catch (Throwable t) {
                    callback.onResult(null, (Throwable)new MongoGridFSException("Error closing from output stream", t));
                    return;
                }
                callback.onResult(null, null);
            }
        };
    }

    private static void transferDataFromByteBuffers(ByteBuffer srcByteBuffer, ByteBuffer dstByteBuffer, SingleResultCallback<Integer> callback) {
        if (!srcByteBuffer.hasRemaining()) {
            callback.onResult((Object)-1, null);
            return;
        }
        int transferAmount = Math.min(dstByteBuffer.remaining(), srcByteBuffer.remaining());
        if (transferAmount > 0) {
            ByteBuffer temp = srcByteBuffer.duplicate();
            temp.limit(temp.position() + transferAmount);
            dstByteBuffer.put(temp);
            srcByteBuffer.position(srcByteBuffer.position() + transferAmount);
        }
        callback.onResult((Object)transferAmount, null);
    }

    private AsyncStreamHelper() {
    }
}

