/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.client.MongoClients;
import com.mongodb.connection.AsynchronousSocketChannelStreamFactoryFactory;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.netty.NettyStreamFactoryFactory;
import java.util.Collections;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;

@Immutable
public final class MongoClientSettings {
    private final ReadPreference readPreference;
    private final WriteConcern writeConcern;
    private final ReadConcern readConcern;
    private final List<MongoCredential> credentialList;
    private final StreamFactoryFactory streamFactoryFactory;
    private final CodecRegistry codecRegistry;
    private final ClusterSettings clusterSettings;
    private final SocketSettings socketSettings;
    private final SocketSettings heartbeatSocketSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final ServerSettings serverSettings;
    private final SslSettings sslSettings;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoClientSettings settings) {
        return new Builder(settings);
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public List<MongoCredential> getCredentialList() {
        return this.credentialList;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public StreamFactoryFactory getStreamFactoryFactory() {
        return this.streamFactoryFactory;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public SslSettings getSslSettings() {
        return this.sslSettings;
    }

    public SocketSettings getSocketSettings() {
        return this.socketSettings;
    }

    public SocketSettings getHeartbeatSocketSettings() {
        return this.heartbeatSocketSettings;
    }

    public ConnectionPoolSettings getConnectionPoolSettings() {
        return this.connectionPoolSettings;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    private MongoClientSettings(Builder builder) {
        this.readPreference = builder.readPreference;
        this.writeConcern = builder.writeConcern;
        this.readConcern = builder.readConcern;
        this.credentialList = builder.credentialList;
        this.streamFactoryFactory = builder.streamFactoryFactory;
        this.codecRegistry = builder.codecRegistry;
        this.clusterSettings = builder.clusterSettings;
        this.serverSettings = builder.serverSettings;
        this.socketSettings = builder.socketSettings;
        this.heartbeatSocketSettings = builder.heartbeatSocketSettings;
        this.connectionPoolSettings = builder.connectionPoolSettings;
        this.sslSettings = builder.sslSettings;
    }

    @NotThreadSafe
    public static final class Builder {
        private ReadPreference readPreference = ReadPreference.primary();
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
        private ReadConcern readConcern = ReadConcern.DEFAULT;
        private CodecRegistry codecRegistry = MongoClients.getDefaultCodecRegistry();
        private StreamFactoryFactory streamFactoryFactory = Builder.createDefaultStreamFactoryFactory();
        private ClusterSettings clusterSettings;
        private SocketSettings socketSettings = SocketSettings.builder().build();
        private SocketSettings heartbeatSocketSettings = SocketSettings.builder().build();
        private ConnectionPoolSettings connectionPoolSettings = ConnectionPoolSettings.builder().maxSize(100).maxWaitQueueSize(500).build();
        private ServerSettings serverSettings = ServerSettings.builder().build();
        private SslSettings sslSettings = SslSettings.builder().build();
        private List<MongoCredential> credentialList = Collections.emptyList();

        private Builder() {
        }

        private Builder(MongoClientSettings settings) {
            this.readPreference = settings.getReadPreference();
            this.writeConcern = settings.getWriteConcern();
            this.readConcern = settings.getReadConcern();
            this.credentialList = settings.getCredentialList();
            this.codecRegistry = settings.getCodecRegistry();
            this.streamFactoryFactory = settings.getStreamFactoryFactory();
            this.clusterSettings = settings.getClusterSettings();
            this.serverSettings = settings.getServerSettings();
            this.socketSettings = settings.getSocketSettings();
            this.heartbeatSocketSettings = settings.getHeartbeatSocketSettings();
            this.connectionPoolSettings = settings.getConnectionPoolSettings();
            this.sslSettings = settings.getSslSettings();
        }

        public Builder clusterSettings(ClusterSettings clusterSettings) {
            this.clusterSettings = (ClusterSettings)Assertions.notNull((String)"clusterSettings", (Object)clusterSettings);
            return this;
        }

        public Builder socketSettings(SocketSettings socketSettings) {
            this.socketSettings = (SocketSettings)Assertions.notNull((String)"socketSettings", (Object)socketSettings);
            return this;
        }

        public Builder heartbeatSocketSettings(SocketSettings heartbeatSocketSettings) {
            this.heartbeatSocketSettings = (SocketSettings)Assertions.notNull((String)"heartbeatSocketSettings", (Object)heartbeatSocketSettings);
            return this;
        }

        public Builder connectionPoolSettings(ConnectionPoolSettings connectionPoolSettings) {
            this.connectionPoolSettings = (ConnectionPoolSettings)Assertions.notNull((String)"connectionPoolSettings", (Object)connectionPoolSettings);
            return this;
        }

        public Builder serverSettings(ServerSettings serverSettings) {
            this.serverSettings = (ServerSettings)Assertions.notNull((String)"serverSettings", (Object)serverSettings);
            return this;
        }

        public Builder sslSettings(SslSettings sslSettings) {
            this.sslSettings = (SslSettings)Assertions.notNull((String)"sslSettings", (Object)sslSettings);
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
            return this;
        }

        public Builder readConcern(ReadConcern readConcern) {
            this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
            return this;
        }

        public Builder credentialList(List<MongoCredential> credentialList) {
            this.credentialList = Collections.unmodifiableList((List)Assertions.notNull((String)"credentialList", credentialList));
            return this;
        }

        public Builder codecRegistry(CodecRegistry codecRegistry) {
            this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
            return this;
        }

        public Builder streamFactoryFactory(StreamFactoryFactory streamFactoryFactory) {
            this.streamFactoryFactory = (StreamFactoryFactory)Assertions.notNull((String)"streamFactoryFactory", (Object)streamFactoryFactory);
            return this;
        }

        public MongoClientSettings build() {
            return new MongoClientSettings(this);
        }

        private static StreamFactoryFactory createDefaultStreamFactoryFactory() {
            String streamType = System.getProperty("org.mongodb.async.type", "nio2");
            if (streamType.equals("netty")) {
                return new NettyStreamFactoryFactory();
            }
            if (streamType.equals("nio2")) {
                return new AsynchronousSocketChannelStreamFactoryFactory();
            }
            throw new IllegalArgumentException("Unsupported stream type " + streamType);
        }
    }
}

