/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.internal;

import com.mongodb.MongoClientException;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcernResult;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.internal.Crypt;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.SplittablePayload;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.SplittablePayloadBsonWriter;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.validator.MappedFieldNameValidator;
import com.mongodb.lang.Nullable;
import com.mongodb.session.SessionContext;
import java.util.HashMap;
import java.util.List;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBinaryWriterSettings;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.FieldNameValidator;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;

class AsyncCryptConnection
implements AsyncConnection {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()});
    private static final int MAX_SPLITTABLE_DOCUMENT_SIZE = 0x200000;
    private final AsyncConnection wrapped;
    private final Crypt crypt;

    AsyncCryptConnection(AsyncConnection wrapped, Crypt crypt) {
        this.wrapped = wrapped;
        this.crypt = crypt;
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public AsyncCryptConnection retain() {
        this.wrapped.retain();
        return this;
    }

    public void release() {
        this.wrapped.release();
    }

    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator fieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, SingleResultCallback<T> callback) {
        this.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, sessionContext, true, null, null, callback);
    }

    public <T> void commandAsync(final String database, BsonDocument command, final FieldNameValidator commandFieldNameValidator, final ReadPreference readPreference, final Decoder<T> commandResultDecoder, final SessionContext sessionContext, final boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, final SingleResultCallback<T> callback) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotTwo((ConnectionDescription)this.wrapped.getDescription())) {
            callback.onResult(null, (Throwable)new MongoClientException("Auto-encryption requires a minimum MongoDB version of 4.2"));
        }
        BasicOutputBuffer bsonOutput = new BasicOutputBuffer();
        BsonBinaryWriter bsonBinaryWriter = new BsonBinaryWriter(new BsonWriterSettings(), new BsonBinaryWriterSettings(this.getDescription().getMaxDocumentSize()), (BsonOutput)bsonOutput, this.getFieldNameValidator(payload, commandFieldNameValidator, payloadFieldNameValidator));
        BsonBinaryWriter writer = payload == null ? bsonBinaryWriter : new SplittablePayloadBsonWriter(bsonBinaryWriter, (BsonOutput)bsonOutput, this.createSplittablePayloadMessageSettings(), payload, 0x200000);
        try {
            this.getEncoder(command).encode((BsonWriter)writer, (Object)command, EncoderContext.builder().build());
            this.crypt.encrypt(database, new RawBsonDocument(bsonOutput.getInternalBuffer(), 0, bsonOutput.getSize()), new SingleResultCallback<RawBsonDocument>(){

                public void onResult(RawBsonDocument encryptedCommand, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        AsyncCryptConnection.this.wrapped.commandAsync(database, (BsonDocument)encryptedCommand, commandFieldNameValidator, readPreference, (Decoder)new RawBsonDocumentCodec(), sessionContext, responseExpected, null, null, this.createCommandCallback());
                    }
                }

                private SingleResultCallback<RawBsonDocument> createCommandCallback() {
                    return new SingleResultCallback<RawBsonDocument>(){

                        public void onResult(RawBsonDocument encryptedResponse, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                AsyncCryptConnection.this.crypt.decrypt(encryptedResponse, (SingleResultCallback<RawBsonDocument>)this.createDecryptCallback());
                            }
                        }
                    };
                }

                private SingleResultCallback<RawBsonDocument> createDecryptCallback() {
                    return new SingleResultCallback<RawBsonDocument>(){

                        public void onResult(RawBsonDocument decryptedResponse, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                try {
                                    BsonBinaryReader reader = new BsonBinaryReader(decryptedResponse.getByteBuffer().asNIO());
                                    callback.onResult(commandResultDecoder.decode((BsonReader)reader, DecoderContext.builder().build()), null);
                                }
                                catch (Throwable t1) {
                                    callback.onResult(null, t1);
                                }
                            }
                        }
                    };
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    private Codec<BsonDocument> getEncoder(BsonDocument command) {
        return REGISTRY.get(command.getClass());
    }

    private FieldNameValidator getFieldNameValidator(@Nullable SplittablePayload payload, FieldNameValidator commandFieldNameValidator, @Nullable FieldNameValidator payloadFieldNameValidator) {
        if (payload == null) {
            return commandFieldNameValidator;
        }
        HashMap<String, FieldNameValidator> rootMap = new HashMap<String, FieldNameValidator>();
        rootMap.put(payload.getPayloadName(), payloadFieldNameValidator);
        return new MappedFieldNameValidator(commandFieldNameValidator, rootMap);
    }

    private MessageSettings createSplittablePayloadMessageSettings() {
        return MessageSettings.builder().maxBatchCount(this.getDescription().getMaxBatchCount()).maxMessageSize(this.getDescription().getMaxMessageSize()).maxDocumentSize(this.getDescription().getMaxDocumentSize()).build();
    }

    public void insertAsync(MongoNamespace namespace, boolean ordered, InsertRequest insertRequest, SingleResultCallback<WriteConcernResult> callback) {
        callback.onResult(null, (Throwable)new UnsupportedOperationException());
    }

    public void updateAsync(MongoNamespace namespace, boolean ordered, UpdateRequest updateRequest, SingleResultCallback<WriteConcernResult> callback) {
        callback.onResult(null, (Throwable)new UnsupportedOperationException());
    }

    public void deleteAsync(MongoNamespace namespace, boolean ordered, DeleteRequest deleteRequest, SingleResultCallback<WriteConcernResult> callback) {
        callback.onResult(null, (Throwable)new UnsupportedOperationException());
    }

    public <T> void commandAsync(String database, BsonDocument command, boolean slaveOk, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, SingleResultCallback<T> callback) {
        callback.onResult(null, (Throwable)new UnsupportedOperationException());
    }

    public <T> void queryAsync(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int numberToReturn, int skip, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder, SingleResultCallback<QueryResult<T>> callback) {
        callback.onResult(null, (Throwable)new UnsupportedOperationException());
    }

    public <T> void queryAsync(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int skip, int limit, int batchSize, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder, SingleResultCallback<QueryResult<T>> callback) {
        callback.onResult(null, (Throwable)new UnsupportedOperationException());
    }

    public <T> void getMoreAsync(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder, SingleResultCallback<QueryResult<T>> callback) {
        callback.onResult(null, (Throwable)new UnsupportedOperationException());
    }

    public void killCursorAsync(List<Long> cursors, SingleResultCallback<Void> callback) {
        callback.onResult(null, (Throwable)new UnsupportedOperationException());
    }

    public void killCursorAsync(MongoNamespace namespace, List<Long> cursors, SingleResultCallback<Void> callback) {
        callback.onResult(null, (Throwable)new UnsupportedOperationException());
    }
}

