/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.internal;

import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.internal.AsyncCryptConnection;
import com.mongodb.async.client.internal.Crypt;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadWriteBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.session.SessionContext;

public class AsyncCryptBinding
implements AsyncClusterAwareReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final Crypt crypt;

    public AsyncCryptBinding(AsyncClusterAwareReadWriteBinding wrapped, Crypt crypt) {
        this.wrapped = wrapped;
        this.crypt = crypt;
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public void getWriteConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getWriteConnectionSource((SingleResultCallback)new SingleResultCallback<AsyncConnectionSource>(){

            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)new AsyncCryptConnectionSource(result), null);
                }
            }
        });
    }

    public SessionContext getSessionContext() {
        return this.wrapped.getSessionContext();
    }

    public void getReadConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource((SingleResultCallback)new SingleResultCallback<AsyncConnectionSource>(){

            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)new AsyncCryptConnectionSource(result), null);
                }
            }
        });
    }

    public void getConnectionSource(ServerAddress serverAddress, final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getConnectionSource(serverAddress, (SingleResultCallback)new SingleResultCallback<AsyncConnectionSource>(){

            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)new AsyncCryptConnectionSource(result), null);
                }
            }
        });
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public AsyncReadWriteBinding retain() {
        return this.wrapped.retain();
    }

    public void release() {
        this.wrapped.release();
    }

    public Cluster getCluster() {
        return this.wrapped.getCluster();
    }

    private class AsyncCryptConnectionSource
    implements AsyncConnectionSource {
        private final AsyncConnectionSource wrapped;

        AsyncCryptConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
            AsyncCryptBinding.this.retain();
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public SessionContext getSessionContext() {
            return this.wrapped.getSessionContext();
        }

        public void getConnection(final SingleResultCallback<AsyncConnection> callback) {
            this.wrapped.getConnection((SingleResultCallback)new SingleResultCallback<AsyncConnection>(){

                public void onResult(AsyncConnection result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult((Object)new AsyncCryptConnection(result, AsyncCryptBinding.this.crypt), null);
                    }
                }
            });
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public AsyncConnectionSource retain() {
            this.wrapped.retain();
            return this;
        }

        public void release() {
            this.wrapped.release();
        }
    }
}

