/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Function;
import com.mongodb.MongoClientException;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.AggregateIterableImpl;
import com.mongodb.async.client.ChangeStreamIterable;
import com.mongodb.async.client.ChangeStreamIterableImpl;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.ListCollectionsIterable;
import com.mongodb.async.client.ListCollectionsIterableImpl;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoCollectionImpl;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationExecutor;
import com.mongodb.client.model.AggregationLevel;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.IndexOptionDefaults;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.client.model.changestream.ChangeStreamLevel;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.CommandReadOperation;
import com.mongodb.operation.CreateCollectionOperation;
import com.mongodb.operation.CreateViewOperation;
import com.mongodb.operation.DropDatabaseOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MongoDatabaseImpl
implements MongoDatabase {
    private final String name;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final boolean retryReads;
    private final ReadConcern readConcern;
    private final OperationExecutor executor;

    MongoDatabaseImpl(String name, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, ReadConcern readConcern, OperationExecutor executor) {
        MongoNamespace.checkDatabaseNameValidity((String)name);
        this.name = (String)Assertions.notNull((String)"name", (Object)name);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.retryWrites = retryWrites;
        this.retryReads = retryReads;
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.name, codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.executor);
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.executor);
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.executor);
    }

    @Override
    public MongoDatabase withReadConcern(ReadConcern readConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, readConcern, this.executor);
    }

    @Override
    public MongoIterable<String> listCollectionNames() {
        return this.createListCollectionNamesIterable(null);
    }

    @Override
    public MongoIterable<String> listCollectionNames(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListCollectionNamesIterable(clientSession);
    }

    private MongoIterable<String> createListCollectionNamesIterable(@Nullable ClientSession clientSession) {
        return this.createListCollectionsIterable(clientSession, BsonDocument.class, true).map(new Function<BsonDocument, String>(){

            public String apply(BsonDocument result) {
                return result.getString((Object)"name").getValue();
            }
        });
    }

    @Override
    public ListCollectionsIterable<Document> listCollections() {
        return this.listCollections(Document.class);
    }

    @Override
    public <TResult> ListCollectionsIterable<TResult> listCollections(Class<TResult> resultClass) {
        return this.createListCollectionsIterable(null, resultClass, false);
    }

    @Override
    public ListCollectionsIterable<Document> listCollections(ClientSession clientSession) {
        return this.listCollections(clientSession, Document.class);
    }

    @Override
    public <TResult> ListCollectionsIterable<TResult> listCollections(ClientSession clientSession, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListCollectionsIterable(clientSession, resultClass, false);
    }

    private <TResult> ListCollectionsIterable<TResult> createListCollectionsIterable(@Nullable ClientSession clientSession, Class<TResult> resultClass, boolean collectionNamesOnly) {
        return new ListCollectionsIterableImpl<TResult>(clientSession, this.name, collectionNamesOnly, resultClass, this.codecRegistry, ReadPreference.primary(), this.executor, this.retryReads);
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    @Override
    public <TDocument> MongoCollection<TDocument> getCollection(String collectionName, Class<TDocument> documentClass) {
        return new MongoCollectionImpl<TDocument>(new MongoNamespace(this.name, collectionName), documentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.executor);
    }

    @Override
    public void runCommand(Bson command, SingleResultCallback<Document> callback) {
        this.runCommand(command, Document.class, callback);
    }

    @Override
    public void runCommand(Bson command, ReadPreference readPreference, SingleResultCallback<Document> callback) {
        this.runCommand(command, readPreference, Document.class, callback);
    }

    @Override
    public <TResult> void runCommand(Bson command, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        this.runCommand(command, ReadPreference.primary(), resultClass, callback);
    }

    @Override
    public <TResult> void runCommand(Bson command, ReadPreference readPreference, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        this.executeCommand(null, command, readPreference, resultClass, callback);
    }

    @Override
    public void runCommand(ClientSession clientSession, Bson command, SingleResultCallback<Document> callback) {
        this.runCommand(clientSession, command, Document.class, callback);
    }

    @Override
    public void runCommand(ClientSession clientSession, Bson command, ReadPreference readPreference, SingleResultCallback<Document> callback) {
        this.runCommand(clientSession, command, readPreference, Document.class, callback);
    }

    @Override
    public <TResult> void runCommand(ClientSession clientSession, Bson command, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        this.runCommand(clientSession, command, ReadPreference.primary(), resultClass, callback);
    }

    @Override
    public <TResult> void runCommand(ClientSession clientSession, Bson command, ReadPreference readPreference, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeCommand(clientSession, command, readPreference, resultClass, callback);
    }

    private <TResult> void executeCommand(@Nullable ClientSession clientSession, Bson command, ReadPreference readPreference, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"command", (Object)command);
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        if (clientSession != null && clientSession.hasActiveTransaction() && !readPreference.equals(ReadPreference.primary())) {
            throw new MongoClientException("Read preference in a transaction must be primary");
        }
        this.executor.execute(new CommandReadOperation(this.getName(), this.toBsonDocument(command), (Decoder)this.codecRegistry.get(resultClass)), readPreference, this.readConcern, clientSession, callback);
    }

    @Override
    public void drop(SingleResultCallback<Void> callback) {
        this.executeDrop(null, callback);
    }

    @Override
    public void drop(ClientSession clientSession, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDrop(clientSession, callback);
    }

    private void executeDrop(@Nullable ClientSession clientSession, SingleResultCallback<Void> callback) {
        this.executor.execute(new DropDatabaseOperation(this.name, this.writeConcern), this.readConcern, clientSession, callback);
    }

    @Override
    public void createCollection(String collectionName, SingleResultCallback<Void> callback) {
        this.executeCreateCollection(null, collectionName, new CreateCollectionOptions(), callback);
    }

    @Override
    public void createCollection(String collectionName, CreateCollectionOptions createCollectionOptions, SingleResultCallback<Void> callback) {
        this.executeCreateCollection(null, collectionName, createCollectionOptions, callback);
    }

    @Override
    public void createCollection(ClientSession clientSession, String collectionName, SingleResultCallback<Void> callback) {
        this.createCollection(clientSession, collectionName, new CreateCollectionOptions(), callback);
    }

    @Override
    public void createCollection(ClientSession clientSession, String collectionName, CreateCollectionOptions options, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeCreateCollection(clientSession, collectionName, options, callback);
    }

    private void executeCreateCollection(@Nullable ClientSession clientSession, String collectionName, CreateCollectionOptions options, SingleResultCallback<Void> callback) {
        ValidationOptions validationOptions;
        Bson validator;
        CreateCollectionOperation operation = new CreateCollectionOperation(this.name, collectionName, this.writeConcern).capped(options.isCapped()).sizeInBytes(options.getSizeInBytes()).autoIndex(options.isAutoIndex()).maxDocuments(options.getMaxDocuments()).usePowerOf2Sizes(options.isUsePowerOf2Sizes()).storageEngineOptions(this.toBsonDocument(options.getStorageEngineOptions())).collation(options.getCollation());
        IndexOptionDefaults indexOptionDefaults = options.getIndexOptionDefaults();
        Bson storageEngine = indexOptionDefaults.getStorageEngine();
        if (storageEngine != null) {
            operation.indexOptionDefaults(new BsonDocument("storageEngine", (BsonValue)this.toBsonDocument(storageEngine)));
        }
        if ((validator = (validationOptions = options.getValidationOptions()).getValidator()) != null) {
            operation.validator(this.toBsonDocument(validator));
        }
        if (validationOptions.getValidationLevel() != null) {
            operation.validationLevel(validationOptions.getValidationLevel());
        }
        if (validationOptions.getValidationAction() != null) {
            operation.validationAction(validationOptions.getValidationAction());
        }
        this.executor.execute(operation, this.readConcern, clientSession, callback);
    }

    @Override
    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline, SingleResultCallback<Void> callback) {
        this.createView(viewName, viewOn, pipeline, new CreateViewOptions(), callback);
    }

    @Override
    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions, SingleResultCallback<Void> callback) {
        this.executeCreateView(null, viewName, viewOn, pipeline, createViewOptions, callback);
    }

    @Override
    public void createView(ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, SingleResultCallback<Void> callback) {
        this.createView(clientSession, viewName, viewOn, pipeline, new CreateViewOptions(), callback);
    }

    @Override
    public void createView(ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeCreateView(clientSession, viewName, viewOn, pipeline, createViewOptions, callback);
    }

    @Override
    public ChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    @Override
    public AggregateIterable<Document> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, Document.class);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createAggregateIterable(null, pipeline, resultClass);
    }

    @Override
    public AggregateIterable<Document> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createAggregateIterable((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), pipeline, resultClass);
    }

    private <TResult> AggregateIterable<TResult> createAggregateIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregateIterableImpl<Document, TResult>(clientSession, this.name, Document.class, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, pipeline, AggregationLevel.DATABASE, this.retryReads);
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, this.name, this.codecRegistry, this.readPreference, this.readConcern, this.executor, pipeline, resultClass, ChangeStreamLevel.DATABASE, this.retryReads);
    }

    private void executeCreateView(@Nullable ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"createViewOptions", (Object)createViewOptions);
        this.executor.execute(new CreateViewOperation(this.name, viewName, viewOn, this.createBsonDocumentList(pipeline), this.writeConcern).collation(createViewOptions.getCollation()), this.readConcern, clientSession, callback);
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        Assertions.notNull((String)"pipeline", pipeline);
        ArrayList<BsonDocument> bsonDocumentPipeline = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline can not contain a null value");
            }
            bsonDocumentPipeline.add(bson.toBsonDocument(BsonDocument.class, this.codecRegistry));
        }
        return bsonDocumentPipeline;
    }

    @Nullable
    private BsonDocument toBsonDocument(@Nullable Bson document) {
        return document == null ? null : document.toBsonDocument(BsonDocument.class, this.codecRegistry);
    }
}

