/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.MongoIterableImpl;
import com.mongodb.async.client.OperationExecutor;
import com.mongodb.async.client.WriteOperationThenCursorReadOperation;
import com.mongodb.client.model.AggregationLevel;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.FindOptions;
import com.mongodb.internal.operation.AsyncOperations;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class AggregateIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements AggregateIterable<TResult> {
    private final AsyncOperations<TDocument> operations;
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final CodecRegistry codecRegistry;
    private final List<? extends Bson> pipeline;
    private final AggregationLevel aggregationLevel;
    private Boolean allowDiskUse;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private Boolean useCursor;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private String comment;
    private Bson hint;

    AggregateIterableImpl(@Nullable ClientSession clientSession, String databaseName, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, List<? extends Bson> pipeline, AggregationLevel aggregationLevel, boolean retryReads) {
        this(clientSession, new MongoNamespace(databaseName, "ignored"), documentClass, resultClass, codecRegistry, readPreference, readConcern, writeConcern, executor, pipeline, aggregationLevel, retryReads);
    }

    AggregateIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, List<? extends Bson> pipeline, AggregationLevel aggregationLevel, boolean retryReads) {
        super(clientSession, executor, readConcern, readPreference, retryReads);
        this.operations = new AsyncOperations(namespace, documentClass, readPreference, codecRegistry, writeConcern, false, retryReads);
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
        this.aggregationLevel = (AggregationLevel)Assertions.notNull((String)"aggregationLevel", (Object)aggregationLevel);
    }

    @Override
    public void toCollection(SingleResultCallback<Void> callback) {
        if (this.getOutCollection() == null) {
            throw new IllegalStateException("The last stage of the aggregation pipeline must be $out");
        }
        this.getExecutor().execute(this.operations.aggregateToCollection(this.pipeline, this.maxTimeMS, this.allowDiskUse, this.bypassDocumentValidation, this.collation, this.hint, this.comment, this.aggregationLevel), this.getReadConcern(), this.getClientSession(), callback);
    }

    @Override
    public AggregateIterable<TResult> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AggregateIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<TResult> useCursor(@Nullable Boolean useCursor) {
        this.useCursor = useCursor;
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<TResult> bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public AggregateIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public AggregateIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public AggregateIterable<TResult> hint(@Nullable Bson hint) {
        this.hint = hint;
        return this;
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation() {
        BsonValue outCollection = this.getOutCollection();
        if (outCollection != null) {
            AsyncWriteOperation aggregateToCollectionOperation = this.operations.aggregateToCollection(this.pipeline, this.maxTimeMS, this.allowDiskUse, this.bypassDocumentValidation, this.collation, this.hint, this.comment, this.aggregationLevel);
            FindOptions findOptions = new FindOptions().collation(this.collation);
            Integer batchSize = this.getBatchSize();
            if (batchSize != null) {
                findOptions.batchSize(batchSize.intValue());
            }
            AsyncReadOperation findOperation = this.operations.find(new MongoNamespace(this.namespace.getDatabaseName(), outCollection.asString().getValue()), (Bson)new BsonDocument(), this.resultClass, findOptions);
            return new WriteOperationThenCursorReadOperation((AsyncWriteOperation<Void>)aggregateToCollectionOperation, findOperation);
        }
        return this.operations.aggregate(this.pipeline, this.resultClass, this.maxTimeMS, this.maxAwaitTimeMS, this.getBatchSize(), this.collation, this.hint, this.comment, this.allowDiskUse, this.useCursor, this.aggregationLevel);
    }

    @Nullable
    private BsonValue getOutCollection() {
        if (this.pipeline.size() == 0) {
            return null;
        }
        Bson lastStage = (Bson)Assertions.notNull((String)"last stage", (Object)this.pipeline.get(this.pipeline.size() - 1));
        return lastStage.toBsonDocument(this.documentClass, this.codecRegistry).get((Object)"$out");
    }
}

