/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.DistinctIterable;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationIterable;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.DistinctOperation;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class DistinctIterableImpl<TDocument, TResult>
implements DistinctIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentclass;
    private final Class<TResult> resultClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final AsyncOperationExecutor executor;
    private final String fieldName;
    private Bson filter;
    private long maxTimeMS;

    DistinctIterableImpl(MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, AsyncOperationExecutor executor, String fieldName, Bson filter) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentclass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.fieldName = (String)Assertions.notNull((String)"mapFunction", (Object)fieldName);
        this.filter = filter;
    }

    @Override
    public DistinctIterable<TResult> filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public DistinctIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public DistinctIterable<TResult> batchSize(int batchSize) {
        return this;
    }

    @Override
    public void first(SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"callback", callback);
        this.execute().first(callback);
    }

    @Override
    public void forEach(Block<? super TResult> block, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"block", block);
        Assertions.notNull((String)"callback", callback);
        this.execute().forEach(block, callback);
    }

    @Override
    public <A extends Collection<? super TResult>> void into(A target, SingleResultCallback<A> callback) {
        Assertions.notNull((String)"target", target);
        Assertions.notNull((String)"callback", callback);
        this.execute().into(target, callback);
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<TResult>> callback) {
        Assertions.notNull((String)"callback", callback);
        this.execute().batchCursor(callback);
    }

    private MongoIterable<TResult> execute() {
        DistinctOperation operation = new DistinctOperation(this.namespace, this.fieldName, (Decoder)this.codecRegistry.get(this.resultClass)).filter(this.filter == null ? null : this.filter.toBsonDocument(this.documentclass, this.codecRegistry)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
        return new OperationIterable(operation, this.readPreference, this.executor);
    }
}

