/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.AggregateIterableImpl;
import com.mongodb.async.client.DistinctIterable;
import com.mongodb.async.client.DistinctIterableImpl;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.FindIterableImpl;
import com.mongodb.async.client.ListIndexesIterable;
import com.mongodb.async.client.ListIndexesIterableImpl;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.async.client.MapReduceIterableImpl;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateIndexOperation;
import com.mongodb.operation.DropCollectionOperation;
import com.mongodb.operation.DropIndexOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.RenameCollectionOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.configuration.CodecRegistry;

class MongoCollectionImpl<T>
implements MongoCollection<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final AsyncOperationExecutor executor;

    MongoCollectionImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, AsyncOperationExecutor executor) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.clazz = (Class)Assertions.notNull((String)"clazz", clazz);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<T> getDefaultClass() {
        return this.clazz;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public <C> MongoCollection<C> withDefaultClass(Class<C> clazz) {
        return new MongoCollectionImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, this.codecRegistry, readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, this.codecRegistry, this.readPreference, writeConcern, this.executor);
    }

    @Override
    public void count(SingleResultCallback<Long> callback) {
        this.count(new BsonDocument(), new CountOptions(), callback);
    }

    @Override
    public void count(Object filter, SingleResultCallback<Long> callback) {
        this.count(filter, new CountOptions(), callback);
    }

    @Override
    public void count(Object filter, CountOptions options, SingleResultCallback<Long> callback) {
        CountOperation operation = new CountOperation(this.namespace).filter(this.asBson(filter)).skip(options.getSkip()).limit(options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        if (options.getHint() != null) {
            operation.hint((BsonValue)this.asBson(options.getHint()));
        } else if (options.getHintString() != null) {
            operation.hint((BsonValue)new BsonString(options.getHintString()));
        }
        this.executor.execute((AsyncReadOperation)operation, this.readPreference, callback);
    }

    @Override
    public <C> DistinctIterable<C> distinct(String fieldName, Class<C> clazz) {
        return new DistinctIterableImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor, fieldName);
    }

    @Override
    public FindIterable<T> find() {
        return this.find(new BsonDocument(), this.clazz);
    }

    @Override
    public <C> FindIterable<C> find(Class<C> clazz) {
        return this.find(new BsonDocument(), clazz);
    }

    @Override
    public FindIterable<T> find(Object filter) {
        return this.find(filter, this.clazz);
    }

    @Override
    public <C> FindIterable<C> find(Object filter, Class<C> clazz) {
        return new FindIterableImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor, filter, new FindOptions());
    }

    @Override
    public AggregateIterable<Document> aggregate(List<?> pipeline) {
        return this.aggregate(pipeline, Document.class);
    }

    @Override
    public <C> AggregateIterable<C> aggregate(List<?> pipeline, Class<C> clazz) {
        return new AggregateIterableImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor, pipeline);
    }

    @Override
    public MapReduceIterable<Document> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, Document.class);
    }

    @Override
    public <C> MapReduceIterable<C> mapReduce(String mapFunction, String reduceFunction, Class<C> clazz) {
        return new MapReduceIterableImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor, mapFunction, reduceFunction);
    }

    @Override
    public void bulkWrite(List<? extends WriteModel<? extends T>> requests, SingleResultCallback<BulkWriteResult> callback) {
        this.bulkWrite(requests, new BulkWriteOptions(), callback);
    }

    @Override
    public void bulkWrite(List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options, SingleResultCallback<BulkWriteResult> callback) {
        ArrayList<InsertRequest> writeRequests = new ArrayList<InsertRequest>(requests.size());
        for (WriteModel<T> writeModel : requests) {
            InsertRequest writeRequest;
            if (writeModel instanceof InsertOneModel) {
                InsertOneModel insertOneModel = (InsertOneModel)writeModel;
                if (this.getCodec() instanceof CollectibleCodec) {
                    ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(insertOneModel.getDocument());
                }
                writeRequest = new InsertRequest(this.asBson(insertOneModel.getDocument()));
            } else if (writeModel instanceof ReplaceOneModel) {
                ReplaceOneModel replaceOneModel = (ReplaceOneModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(replaceOneModel.getFilter()), this.asBson(replaceOneModel.getReplacement()), WriteRequest.Type.REPLACE).upsert(replaceOneModel.getOptions().isUpsert());
            } else if (writeModel instanceof UpdateOneModel) {
                UpdateOneModel updateOneModel = (UpdateOneModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(updateOneModel.getFilter()), this.asBson(updateOneModel.getUpdate()), WriteRequest.Type.UPDATE).multi(false).upsert(updateOneModel.getOptions().isUpsert());
            } else if (writeModel instanceof UpdateManyModel) {
                UpdateManyModel updateManyModel = (UpdateManyModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(updateManyModel.getFilter()), this.asBson(updateManyModel.getUpdate()), WriteRequest.Type.UPDATE).multi(true).upsert(updateManyModel.getOptions().isUpsert());
            } else if (writeModel instanceof DeleteOneModel) {
                DeleteOneModel deleteOneModel = (DeleteOneModel)writeModel;
                writeRequest = new DeleteRequest(this.asBson(deleteOneModel.getFilter())).multi(false);
            } else if (writeModel instanceof DeleteManyModel) {
                DeleteManyModel deleteManyModel = (DeleteManyModel)writeModel;
                writeRequest = new DeleteRequest(this.asBson(deleteManyModel.getFilter())).multi(true);
            } else {
                throw new UnsupportedOperationException(String.format("WriteModel of type %s is not supported", writeModel.getClass()));
            }
            writeRequests.add(writeRequest);
        }
        this.executor.execute((AsyncWriteOperation)new MixedBulkWriteOperation(this.namespace, writeRequests, options.isOrdered(), this.writeConcern), callback);
    }

    @Override
    public void insertOne(T document, final SingleResultCallback<Void> callback) {
        if (this.getCodec() instanceof CollectibleCodec) {
            ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
        }
        this.executeSingleWriteRequest((WriteRequest)new InsertRequest(this.asBson(document)), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                callback.onResult(null, t);
            }
        });
    }

    @Override
    public void insertMany(List<? extends T> documents, SingleResultCallback<Void> callback) {
        this.insertMany(documents, new InsertManyOptions(), callback);
    }

    @Override
    public void insertMany(List<? extends T> documents, InsertManyOptions options, final SingleResultCallback<Void> callback) {
        ArrayList<InsertRequest> requests = new ArrayList<InsertRequest>(documents.size());
        for (T document : documents) {
            if (this.getCodec() instanceof CollectibleCodec) {
                ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
            }
            requests.add(new InsertRequest(this.asBson(document)));
        }
        this.executor.execute((AsyncWriteOperation)new MixedBulkWriteOperation(this.namespace, requests, options.isOrdered(), this.writeConcern), ErrorHandlingResultCallback.errorHandlingCallback((SingleResultCallback)new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                callback.onResult(null, t);
            }
        }));
    }

    @Override
    public void deleteOne(Object filter, SingleResultCallback<DeleteResult> callback) {
        this.delete(filter, false, callback);
    }

    @Override
    public void deleteMany(Object filter, SingleResultCallback<DeleteResult> callback) {
        this.delete(filter, true, callback);
    }

    @Override
    public void replaceOne(Object filter, T replacement, SingleResultCallback<UpdateResult> callback) {
        this.replaceOne(filter, replacement, new UpdateOptions(), callback);
    }

    @Override
    public void replaceOne(Object filter, T replacement, UpdateOptions options, final SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest((WriteRequest)new UpdateRequest(this.asBson(filter), this.asBson(replacement), WriteRequest.Type.REPLACE).upsert(options.isUpsert()), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)MongoCollectionImpl.this.toUpdateResult(result), null);
                }
            }
        });
    }

    @Override
    public void updateOne(Object filter, Object update, SingleResultCallback<UpdateResult> callback) {
        this.updateOne(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateOne(Object filter, Object update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.update(filter, update, options, false, callback);
    }

    @Override
    public void updateMany(Object filter, Object update, SingleResultCallback<UpdateResult> callback) {
        this.updateMany(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateMany(Object filter, Object update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.update(filter, update, options, true, callback);
    }

    @Override
    public void findOneAndDelete(Object filter, SingleResultCallback<T> callback) {
        this.findOneAndDelete(filter, new FindOneAndDeleteOptions(), callback);
    }

    @Override
    public void findOneAndDelete(Object filter, FindOneAndDeleteOptions options, SingleResultCallback<T> callback) {
        this.executor.execute((AsyncWriteOperation)new FindAndDeleteOperation(this.namespace, this.getCodec()).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())), callback);
    }

    @Override
    public void findOneAndReplace(Object filter, T replacement, SingleResultCallback<T> callback) {
        this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions(), callback);
    }

    @Override
    public void findOneAndReplace(Object filter, T replacement, FindOneAndReplaceOptions options, SingleResultCallback<T> callback) {
        this.executor.execute((AsyncWriteOperation)new FindAndReplaceOperation(this.namespace, this.getCodec(), this.asBson(replacement)).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())).returnOriginal(options.getReturnOriginal()).upsert(options.isUpsert()), callback);
    }

    @Override
    public void findOneAndUpdate(Object filter, Object update, SingleResultCallback<T> callback) {
        this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions(), callback);
    }

    @Override
    public void findOneAndUpdate(Object filter, Object update, FindOneAndUpdateOptions options, SingleResultCallback<T> callback) {
        this.executor.execute((AsyncWriteOperation)new FindAndUpdateOperation(this.namespace, this.getCodec(), this.asBson(update)).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())).returnOriginal(options.getReturnOriginal()).upsert(options.isUpsert()), callback);
    }

    @Override
    public void dropCollection(SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new DropCollectionOperation(this.namespace), callback);
    }

    @Override
    public void createIndex(Object key, SingleResultCallback<Void> callback) {
        this.createIndex(key, new CreateIndexOptions(), callback);
    }

    @Override
    public void createIndex(Object key, CreateIndexOptions options, SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new CreateIndexOperation(this.getNamespace(), this.asBson(key)).name(options.getName()).background(options.isBackground()).unique(options.isUnique()).sparse(options.isSparse()).expireAfterSeconds(options.getExpireAfterSeconds()).version(options.getVersion()).weights(this.asBson(options.getWeights())).defaultLanguage(options.getDefaultLanguage()).languageOverride(options.getLanguageOverride()).textIndexVersion(options.getTextIndexVersion()).twoDSphereIndexVersion(options.getTwoDSphereIndexVersion()).bits(options.getBits()).min(options.getMin()).max(options.getMax()).bucketSize(options.getBucketSize()), callback);
    }

    @Override
    public ListIndexesIterable<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <C> ListIndexesIterable<C> listIndexes(Class<C> clazz) {
        return new ListIndexesIterableImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor);
    }

    @Override
    public void dropIndex(String indexName, SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new DropIndexOperation(this.namespace, indexName), callback);
    }

    @Override
    public void dropIndexes(SingleResultCallback<Void> callback) {
        this.dropIndex("*", callback);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, SingleResultCallback<Void> callback) {
        this.renameCollection(newCollectionNamespace, new RenameCollectionOptions(), callback);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options, SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new RenameCollectionOperation(this.getNamespace(), newCollectionNamespace).dropTarget(options.isDropTarget()), callback);
    }

    private void delete(Object filter, boolean multi, final SingleResultCallback<DeleteResult> callback) {
        this.executeSingleWriteRequest((WriteRequest)new DeleteRequest(this.asBson(filter)).multi(multi), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (result.wasAcknowledged()) {
                    callback.onResult((Object)DeleteResult.acknowledged((long)result.getDeletedCount()), null);
                } else {
                    callback.onResult((Object)DeleteResult.unacknowledged(), null);
                }
            }
        });
    }

    private void update(Object filter, Object update, UpdateOptions updateOptions, boolean multi, final SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest((WriteRequest)new UpdateRequest(this.asBson(filter), this.asBson(update), WriteRequest.Type.UPDATE).upsert(updateOptions.isUpsert()).multi(multi), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)MongoCollectionImpl.this.toUpdateResult(result), null);
                }
            }
        });
    }

    private void executeSingleWriteRequest(WriteRequest request, final SingleResultCallback<BulkWriteResult> callback) {
        this.executor.execute((AsyncWriteOperation)new MixedBulkWriteOperation(this.namespace, Arrays.asList(request), true, this.writeConcern), (SingleResultCallback)new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t instanceof MongoBulkWriteException) {
                    MongoBulkWriteException e = (MongoBulkWriteException)t;
                    if (e.getWriteErrors().isEmpty()) {
                        callback.onResult(null, (Throwable)new MongoWriteConcernException(e.getWriteConcernError(), e.getServerAddress()));
                    } else {
                        callback.onResult(null, (Throwable)new MongoWriteException(new WriteError((WriteError)e.getWriteErrors().get(0)), e.getServerAddress()));
                    }
                } else {
                    callback.onResult((Object)result, t);
                }
            }
        });
    }

    private UpdateResult toUpdateResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            Long modifiedCount = result.isModifiedCountAvailable() ? Long.valueOf(result.getModifiedCount()) : null;
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)result.getUpserts().get(0)).getId();
            return UpdateResult.acknowledged((long)result.getMatchedCount(), (Long)modifiedCount, (BsonValue)upsertedId);
        }
        return UpdateResult.unacknowledged();
    }

    private Codec<T> getCodec() {
        return this.getCodec(this.clazz);
    }

    private <C> Codec<C> getCodec(Class<C> clazz) {
        return this.codecRegistry.get(clazz);
    }

    private BsonDocument asBson(Object document) {
        return BsonDocumentWrapper.asBsonDocument((Object)document, (CodecRegistry)this.codecRegistry);
    }
}

