/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ListDatabasesIterable;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationIterable;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.ListDatabasesOperation;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;

final class ListDatabasesIterableImpl<T>
implements ListDatabasesIterable<T> {
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final AsyncOperationExecutor executor;
    private long maxTimeMS;

    ListDatabasesIterableImpl(Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, AsyncOperationExecutor executor) {
        this.clazz = (Class)Assertions.notNull((String)"clazz", clazz);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public ListDatabasesIterable<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public void first(SingleResultCallback<T> callback) {
        this.execute(this.createListDatabasesOperation()).first(callback);
    }

    @Override
    public void forEach(Block<? super T> block, SingleResultCallback<Void> callback) {
        this.execute().forEach(block, callback);
    }

    @Override
    public <A extends Collection<? super T>> void into(A target, SingleResultCallback<A> callback) {
        this.execute().into(target, callback);
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    @Override
    public ListDatabasesIterableImpl<T> batchSize(int batchSize) {
        return this;
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.execute().batchCursor(callback);
    }

    private MongoIterable<T> execute() {
        return this.execute(this.createListDatabasesOperation());
    }

    private MongoIterable<T> execute(ListDatabasesOperation<T> operation) {
        return new OperationIterable(operation, this.readPreference, this.executor);
    }

    private <C> Codec<C> getCodec(Class<C> clazz) {
        return this.codecRegistry.get(clazz);
    }

    private ListDatabasesOperation<T> createListDatabasesOperation() {
        return new ListDatabasesOperation(this.getCodec(this.clazz)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }
}

