/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.ErrorHandlingResultCallback;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AwaitingWriteOperationIterable;
import com.mongodb.async.client.FindFluent;
import com.mongodb.async.client.FindFluentImpl;
import com.mongodb.async.client.ListIndexesFluent;
import com.mongodb.async.client.ListIndexesFluentImpl;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationIterable;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.model.AggregateOptions;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DistinctOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.MapReduceOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AggregateToCollectionOperation;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateIndexOperation;
import com.mongodb.operation.DistinctOperation;
import com.mongodb.operation.DropCollectionOperation;
import com.mongodb.operation.DropIndexOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.MapReduceStatistics;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.RenameCollectionOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonJavaScript;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistry;

class MongoCollectionImpl<T>
implements MongoCollection<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final AsyncOperationExecutor executor;

    MongoCollectionImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, AsyncOperationExecutor executor) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.clazz = (Class)Assertions.notNull((String)"clazz", clazz);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<T> getDefaultClass() {
        return this.clazz;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public <C> MongoCollection<C> withDefaultClass(Class<C> clazz) {
        return new MongoCollectionImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, this.codecRegistry, readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, this.codecRegistry, this.readPreference, writeConcern, this.executor);
    }

    @Override
    public void count(SingleResultCallback<Long> callback) {
        this.count(new BsonDocument(), new CountOptions(), callback);
    }

    @Override
    public void count(Object filter, SingleResultCallback<Long> callback) {
        this.count(filter, new CountOptions(), callback);
    }

    @Override
    public void count(Object filter, CountOptions options, SingleResultCallback<Long> callback) {
        CountOperation operation = new CountOperation(this.namespace).filter(this.asBson(filter)).skip(options.getSkip()).limit(options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        if (options.getHint() != null) {
            operation.hint((BsonValue)this.asBson(options.getHint()));
        } else if (options.getHintString() != null) {
            operation.hint((BsonValue)new BsonString(options.getHintString()));
        }
        this.executor.execute((AsyncReadOperation)operation, this.readPreference, callback);
    }

    @Override
    public void distinct(String fieldName, Object filter, SingleResultCallback<List<Object>> callback) {
        this.distinct(fieldName, filter, new DistinctOptions(), callback);
    }

    @Override
    public void distinct(String fieldName, Object filter, DistinctOptions options, final SingleResultCallback<List<Object>> callback) {
        DistinctOperation operation = new DistinctOperation(this.namespace, fieldName).filter(this.asBson(filter)).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        this.executor.execute((AsyncReadOperation)operation, this.readPreference, ErrorHandlingResultCallback.errorHandlingCallback((SingleResultCallback)new SingleResultCallback<BsonArray>(){

            public void onResult(BsonArray result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, (Throwable)MongoException.fromThrowable((Throwable)t));
                } else {
                    try {
                        ArrayList<Object> distinctList = new ArrayList<Object>();
                        for (BsonValue value : result) {
                            BsonDocument bsonDocument = new BsonDocument("value", value);
                            Document document = (Document)MongoCollectionImpl.this.getCodec(Document.class).decode((BsonReader)new BsonDocumentReader(bsonDocument), DecoderContext.builder().build());
                            distinctList.add(document.get((Object)"value"));
                        }
                        callback.onResult(distinctList, null);
                    }
                    catch (Throwable tr) {
                        callback.onResult(null, (Throwable)new MongoException("Error when decoding distinct results", tr));
                    }
                }
            }
        }));
    }

    @Override
    public FindFluent<T> find() {
        return this.find(new BsonDocument(), this.clazz);
    }

    @Override
    public <C> FindFluent<C> find(Class<C> clazz) {
        return this.find(new BsonDocument(), clazz);
    }

    @Override
    public FindFluent<T> find(Object filter) {
        return this.find(filter, this.clazz);
    }

    @Override
    public <C> FindFluent<C> find(Object filter, Class<C> clazz) {
        return new FindFluentImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor, filter, new FindOptions());
    }

    @Override
    public MongoIterable<Document> aggregate(List<?> pipeline) {
        return this.aggregate(pipeline, new AggregateOptions(), Document.class);
    }

    @Override
    public <C> MongoIterable<C> aggregate(List<?> pipeline, Class<C> clazz) {
        return this.aggregate(pipeline, new AggregateOptions(), clazz);
    }

    @Override
    public MongoIterable<Document> aggregate(List<?> pipeline, AggregateOptions options) {
        return this.aggregate(pipeline, options, Document.class);
    }

    @Override
    public <C> MongoIterable<C> aggregate(List<?> pipeline, AggregateOptions options, Class<C> clazz) {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(pipeline);
        BsonValue outCollection = this.getAggregateOutCollection(aggregateList);
        if (outCollection != null) {
            AggregateToCollectionOperation operation = new AggregateToCollectionOperation(this.namespace, aggregateList).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options.getAllowDiskUse());
            FindFluentImpl<C> delegated = new FindFluentImpl<C>(new MongoNamespace(this.namespace.getDatabaseName(), outCollection.asString().getValue()), clazz, this.codecRegistry, ReadPreference.primary(), this.executor, new BsonDocument(), new FindOptions());
            return new AwaitingWriteOperationIterable(operation, this.executor, delegated);
        }
        return new OperationIterable(new AggregateOperation(this.namespace, aggregateList, this.getCodec(clazz)).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options.getAllowDiskUse()).batchSize(options.getBatchSize()).useCursor(options.getUseCursor()), this.readPreference, this.executor);
    }

    @Override
    public void aggregateToCollection(List<?> pipeline, SingleResultCallback<Void> callback) {
        this.aggregateToCollection(pipeline, new AggregateOptions(), callback);
    }

    @Override
    public void aggregateToCollection(List<?> pipeline, AggregateOptions options, SingleResultCallback<Void> callback) {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(pipeline);
        BsonValue outCollection = this.getAggregateOutCollection(aggregateList);
        if (outCollection == null) {
            throw new IllegalArgumentException("The last stage of the aggregation pipeline must be $out");
        }
        this.executor.execute((AsyncWriteOperation)new AggregateToCollectionOperation(this.namespace, aggregateList).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options.getAllowDiskUse()), callback);
    }

    private BsonValue getAggregateOutCollection(List<BsonDocument> aggregateList) {
        return aggregateList.size() == 0 ? null : aggregateList.get(aggregateList.size() - 1).get((Object)"$out");
    }

    @Override
    public MongoIterable<Document> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, new MapReduceOptions());
    }

    @Override
    public MongoIterable<Document> mapReduce(String mapFunction, String reduceFunction, MapReduceOptions options) {
        return this.mapReduce(mapFunction, reduceFunction, options, Document.class);
    }

    @Override
    public <C> MongoIterable<C> mapReduce(String mapFunction, String reduceFunction, Class<C> clazz) {
        return this.mapReduce(mapFunction, reduceFunction, new MapReduceOptions(), clazz);
    }

    @Override
    public <C> MongoIterable<C> mapReduce(String mapFunction, String reduceFunction, MapReduceOptions options, Class<C> clazz) {
        if (options.isInline()) {
            MapReduceWithInlineResultsOperation operation = new MapReduceWithInlineResultsOperation(this.getNamespace(), new BsonJavaScript(mapFunction), new BsonJavaScript(reduceFunction), this.getCodec(clazz)).filter(this.asBson(options.getFilter())).limit(options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).jsMode(options.isJsMode()).scope(this.asBson(options.getScope())).sort(this.asBson(options.getSort())).verbose(options.isVerbose());
            if (options.getFinalizeFunction() != null) {
                operation.finalizeFunction(new BsonJavaScript(options.getFinalizeFunction()));
            }
            return new OperationIterable(operation, this.readPreference, this.executor);
        }
        MapReduceToCollectionOperation operation = this.createMapReduceToCollectionOperation(mapFunction, reduceFunction, options);
        String databaseName = options.getDatabaseName() != null ? options.getDatabaseName() : this.namespace.getDatabaseName();
        FindFluentImpl<C> delegated = new FindFluentImpl<C>(new MongoNamespace(databaseName, options.getCollectionName()), clazz, this.codecRegistry, ReadPreference.primary(), this.executor, new BsonDocument(), new FindOptions());
        return new AwaitingWriteOperationIterable(operation, this.executor, delegated);
    }

    @Override
    public void mapReduceToCollection(String mapFunction, String reduceFunction, MapReduceOptions options, final SingleResultCallback<Void> callback) {
        if (options.isInline()) {
            throw new IllegalArgumentException("The options must specify a non-inline result");
        }
        this.executor.execute((AsyncWriteOperation)this.createMapReduceToCollectionOperation(mapFunction, reduceFunction, options), (SingleResultCallback)new SingleResultCallback<MapReduceStatistics>(){

            public void onResult(MapReduceStatistics result, Throwable t) {
                callback.onResult(null, t);
            }
        });
    }

    private MapReduceToCollectionOperation createMapReduceToCollectionOperation(String mapFunction, String reduceFunction, MapReduceOptions options) {
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(this.getNamespace(), new BsonJavaScript(mapFunction), new BsonJavaScript(reduceFunction), options.getCollectionName()).filter(this.asBson(options.getFilter())).limit(options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).jsMode(options.isJsMode()).scope(this.asBson(options.getScope())).sort(this.asBson(options.getSort())).verbose(options.isVerbose()).action(options.getAction().getValue()).nonAtomic(options.isNonAtomic()).sharded(options.isSharded()).databaseName(options.getDatabaseName());
        if (options.getFinalizeFunction() != null) {
            operation.finalizeFunction(new BsonJavaScript(options.getFinalizeFunction()));
        }
        return operation;
    }

    @Override
    public void bulkWrite(List<? extends WriteModel<? extends T>> requests, SingleResultCallback<BulkWriteResult> callback) {
        this.bulkWrite(requests, new BulkWriteOptions(), callback);
    }

    @Override
    public void bulkWrite(List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options, SingleResultCallback<BulkWriteResult> callback) {
        ArrayList<InsertRequest> writeRequests = new ArrayList<InsertRequest>(requests.size());
        for (WriteModel<T> writeModel : requests) {
            InsertRequest writeRequest;
            if (writeModel instanceof InsertOneModel) {
                InsertOneModel insertOneModel = (InsertOneModel)writeModel;
                if (this.getCodec() instanceof CollectibleCodec) {
                    ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(insertOneModel.getDocument());
                }
                writeRequest = new InsertRequest(this.asBson(insertOneModel.getDocument()));
            } else if (writeModel instanceof ReplaceOneModel) {
                ReplaceOneModel replaceOneModel = (ReplaceOneModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(replaceOneModel.getFilter()), this.asBson(replaceOneModel.getReplacement()), WriteRequest.Type.REPLACE).upsert(replaceOneModel.getOptions().isUpsert());
            } else if (writeModel instanceof UpdateOneModel) {
                UpdateOneModel updateOneModel = (UpdateOneModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(updateOneModel.getFilter()), this.asBson(updateOneModel.getUpdate()), WriteRequest.Type.UPDATE).multi(false).upsert(updateOneModel.getOptions().isUpsert());
            } else if (writeModel instanceof UpdateManyModel) {
                UpdateManyModel updateManyModel = (UpdateManyModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(updateManyModel.getFilter()), this.asBson(updateManyModel.getUpdate()), WriteRequest.Type.UPDATE).multi(true).upsert(updateManyModel.getOptions().isUpsert());
            } else if (writeModel instanceof DeleteOneModel) {
                DeleteOneModel deleteOneModel = (DeleteOneModel)writeModel;
                writeRequest = new DeleteRequest(this.asBson(deleteOneModel.getFilter())).multi(false);
            } else if (writeModel instanceof DeleteManyModel) {
                DeleteManyModel deleteManyModel = (DeleteManyModel)writeModel;
                writeRequest = new DeleteRequest(this.asBson(deleteManyModel.getFilter())).multi(true);
            } else {
                throw new UnsupportedOperationException(String.format("WriteModel of type %s is not supported", writeModel.getClass()));
            }
            writeRequests.add(writeRequest);
        }
        this.executor.execute((AsyncWriteOperation)new MixedBulkWriteOperation(this.namespace, writeRequests, options.isOrdered(), this.writeConcern), callback);
    }

    @Override
    public void insertOne(T document, final SingleResultCallback<Void> callback) {
        if (this.getCodec() instanceof CollectibleCodec) {
            ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
        }
        this.executeSingleWriteRequest((WriteRequest)new InsertRequest(this.asBson(document)), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                callback.onResult(null, t);
            }
        });
    }

    @Override
    public void insertMany(List<? extends T> documents, SingleResultCallback<Void> callback) {
        this.insertMany(documents, new InsertManyOptions(), callback);
    }

    @Override
    public void insertMany(List<? extends T> documents, InsertManyOptions options, final SingleResultCallback<Void> callback) {
        ArrayList<InsertRequest> requests = new ArrayList<InsertRequest>(documents.size());
        for (T document : documents) {
            if (this.getCodec() instanceof CollectibleCodec) {
                ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
            }
            requests.add(new InsertRequest(this.asBson(document)));
        }
        this.executor.execute((AsyncWriteOperation)new MixedBulkWriteOperation(this.namespace, requests, options.isOrdered(), this.writeConcern), ErrorHandlingResultCallback.errorHandlingCallback((SingleResultCallback)new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                callback.onResult(null, t);
            }
        }));
    }

    @Override
    public void deleteOne(Object filter, SingleResultCallback<DeleteResult> callback) {
        this.delete(filter, false, callback);
    }

    @Override
    public void deleteMany(Object filter, SingleResultCallback<DeleteResult> callback) {
        this.delete(filter, true, callback);
    }

    @Override
    public void replaceOne(Object filter, T replacement, SingleResultCallback<UpdateResult> callback) {
        this.replaceOne(filter, replacement, new UpdateOptions(), callback);
    }

    @Override
    public void replaceOne(Object filter, T replacement, UpdateOptions options, final SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest((WriteRequest)new UpdateRequest(this.asBson(filter), this.asBson(replacement), WriteRequest.Type.REPLACE).upsert(options.isUpsert()), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)MongoCollectionImpl.this.toUpdateResult(result), null);
                }
            }
        });
    }

    @Override
    public void updateOne(Object filter, Object update, SingleResultCallback<UpdateResult> callback) {
        this.updateOne(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateOne(Object filter, Object update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.update(filter, update, options, false, callback);
    }

    @Override
    public void updateMany(Object filter, Object update, SingleResultCallback<UpdateResult> callback) {
        this.updateMany(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateMany(Object filter, Object update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.update(filter, update, options, true, callback);
    }

    @Override
    public void findOneAndDelete(Object filter, SingleResultCallback<T> callback) {
        this.findOneAndDelete(filter, new FindOneAndDeleteOptions(), callback);
    }

    @Override
    public void findOneAndDelete(Object filter, FindOneAndDeleteOptions options, SingleResultCallback<T> callback) {
        this.executor.execute((AsyncWriteOperation)new FindAndDeleteOperation(this.namespace, this.getCodec()).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())), callback);
    }

    @Override
    public void findOneAndReplace(Object filter, T replacement, SingleResultCallback<T> callback) {
        this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions(), callback);
    }

    @Override
    public void findOneAndReplace(Object filter, T replacement, FindOneAndReplaceOptions options, SingleResultCallback<T> callback) {
        this.executor.execute((AsyncWriteOperation)new FindAndReplaceOperation(this.namespace, this.getCodec(), this.asBson(replacement)).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())).returnOriginal(options.getReturnOriginal()).upsert(options.isUpsert()), callback);
    }

    @Override
    public void findOneAndUpdate(Object filter, Object update, SingleResultCallback<T> callback) {
        this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions(), callback);
    }

    @Override
    public void findOneAndUpdate(Object filter, Object update, FindOneAndUpdateOptions options, SingleResultCallback<T> callback) {
        this.executor.execute((AsyncWriteOperation)new FindAndUpdateOperation(this.namespace, this.getCodec(), this.asBson(update)).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())).returnOriginal(options.getReturnOriginal()).upsert(options.isUpsert()), callback);
    }

    @Override
    public void dropCollection(SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new DropCollectionOperation(this.namespace), callback);
    }

    @Override
    public void createIndex(Object key, SingleResultCallback<Void> callback) {
        this.createIndex(key, new CreateIndexOptions(), callback);
    }

    @Override
    public void createIndex(Object key, CreateIndexOptions options, SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new CreateIndexOperation(this.getNamespace(), this.asBson(key)).name(options.getName()).background(options.isBackground()).unique(options.isUnique()).sparse(options.isSparse()).expireAfterSeconds(options.getExpireAfterSeconds()).version(options.getVersion()).weights(this.asBson(options.getWeights())).defaultLanguage(options.getDefaultLanguage()).languageOverride(options.getLanguageOverride()).textIndexVersion(options.getTextIndexVersion()).twoDSphereIndexVersion(options.getTwoDSphereIndexVersion()).bits(options.getBits()).min(options.getMin()).max(options.getMax()).bucketSize(options.getBucketSize()), callback);
    }

    @Override
    public ListIndexesFluent<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <C> ListIndexesFluent<C> listIndexes(Class<C> clazz) {
        return new ListIndexesFluentImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor);
    }

    @Override
    public void dropIndex(String indexName, SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new DropIndexOperation(this.namespace, indexName), callback);
    }

    @Override
    public void dropIndexes(SingleResultCallback<Void> callback) {
        this.dropIndex("*", callback);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, SingleResultCallback<Void> callback) {
        this.renameCollection(newCollectionNamespace, new RenameCollectionOptions(), callback);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options, SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new RenameCollectionOperation(this.getNamespace(), newCollectionNamespace).dropTarget(options.isDropTarget()), callback);
    }

    private void delete(Object filter, boolean multi, final SingleResultCallback<DeleteResult> callback) {
        this.executeSingleWriteRequest((WriteRequest)new DeleteRequest(this.asBson(filter)).multi(multi), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (result.wasAcknowledged()) {
                    callback.onResult((Object)DeleteResult.acknowledged((long)result.getDeletedCount()), null);
                } else {
                    callback.onResult((Object)DeleteResult.unacknowledged(), null);
                }
            }
        });
    }

    private void update(Object filter, Object update, UpdateOptions updateOptions, boolean multi, final SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest((WriteRequest)new UpdateRequest(this.asBson(filter), this.asBson(update), WriteRequest.Type.UPDATE).upsert(updateOptions.isUpsert()).multi(multi), new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)MongoCollectionImpl.this.toUpdateResult(result), null);
                }
            }
        });
    }

    private void executeSingleWriteRequest(WriteRequest request, final SingleResultCallback<BulkWriteResult> callback) {
        this.executor.execute((AsyncWriteOperation)new MixedBulkWriteOperation(this.namespace, Arrays.asList(request), true, this.writeConcern), (SingleResultCallback)new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t instanceof MongoBulkWriteException) {
                    MongoBulkWriteException e = (MongoBulkWriteException)t;
                    if (e.getWriteErrors().isEmpty()) {
                        callback.onResult(null, (Throwable)new MongoWriteConcernException(e.getWriteConcernError(), e.getServerAddress()));
                    } else {
                        callback.onResult(null, (Throwable)new MongoWriteException(new WriteError((WriteError)e.getWriteErrors().get(0)), e.getServerAddress()));
                    }
                } else {
                    callback.onResult((Object)result, t);
                }
            }
        });
    }

    private UpdateResult toUpdateResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            Long modifiedCount = result.isModifiedCountAvailable() ? Long.valueOf(result.getModifiedCount()) : null;
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)result.getUpserts().get(0)).getId();
            return UpdateResult.acknowledged((long)result.getMatchedCount(), (Long)modifiedCount, (BsonValue)upsertedId);
        }
        return UpdateResult.unacknowledged();
    }

    private Codec<T> getCodec() {
        return this.getCodec(this.clazz);
    }

    private <C> Codec<C> getCodec(Class<C> clazz) {
        return this.codecRegistry.get(clazz);
    }

    private BsonDocument asBson(Object document) {
        return BsonDocumentWrapper.asBsonDocument((Object)document, (CodecRegistry)this.codecRegistry);
    }

    private <D> List<BsonDocument> createBsonDocumentList(List<D> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (D obj : pipeline) {
            aggregateList.add(this.asBson(obj));
        }
        return aggregateList;
    }
}

