/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncWriteOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class AwaitingWriteOperationIterable<T, W>
implements MongoIterable<T> {
    private final MongoIterable<T> delegated;
    private final List<SingleResultCallback<Void>> callbacks = new ArrayList<SingleResultCallback<Void>>();
    private boolean writeCompleted;
    private Throwable thrown;

    AwaitingWriteOperationIterable(AsyncWriteOperation<W> writeOperation, AsyncOperationExecutor executor, MongoIterable<T> delegated) {
        this.delegated = delegated;
        executor.execute(writeOperation, new SingleResultCallback<W>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResult(W result, Throwable t) {
                AwaitingWriteOperationIterable awaitingWriteOperationIterable = AwaitingWriteOperationIterable.this;
                synchronized (awaitingWriteOperationIterable) {
                    AwaitingWriteOperationIterable.this.writeCompleted = true;
                    AwaitingWriteOperationIterable.this.thrown = t;
                    for (SingleResultCallback cur : AwaitingWriteOperationIterable.this.callbacks) {
                        cur.onResult(null, t);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void first(final SingleResultCallback<T> callback) {
        boolean localWriteCompleted;
        AwaitingWriteOperationIterable awaitingWriteOperationIterable = this;
        synchronized (awaitingWriteOperationIterable) {
            localWriteCompleted = this.writeCompleted;
            if (!localWriteCompleted) {
                this.callbacks.add(new SingleResultCallback<Void>(){

                    public void onResult(Void result, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            AwaitingWriteOperationIterable.this.delegated.first(callback);
                        }
                    }
                });
            }
        }
        if (localWriteCompleted) {
            if (this.thrown != null) {
                callback.onResult(null, this.thrown);
            } else {
                this.delegated.first(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(final Block<? super T> block, final SingleResultCallback<Void> callback) {
        boolean localWriteCompleted;
        AwaitingWriteOperationIterable awaitingWriteOperationIterable = this;
        synchronized (awaitingWriteOperationIterable) {
            localWriteCompleted = this.writeCompleted;
            if (!localWriteCompleted) {
                this.callbacks.add(new SingleResultCallback<Void>(){

                    public void onResult(Void result, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            AwaitingWriteOperationIterable.this.delegated.forEach(block, (SingleResultCallback<Void>)callback);
                        }
                    }
                });
            }
        }
        if (localWriteCompleted) {
            if (this.thrown != null) {
                callback.onResult(null, this.thrown);
            } else {
                this.delegated.forEach(block, callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Collection<? super T>> void into(final A target, final SingleResultCallback<A> callback) {
        boolean localWriteCompleted;
        AwaitingWriteOperationIterable awaitingWriteOperationIterable = this;
        synchronized (awaitingWriteOperationIterable) {
            localWriteCompleted = this.writeCompleted;
            if (!localWriteCompleted) {
                this.callbacks.add(new SingleResultCallback<Void>(){

                    public void onResult(Void result, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            AwaitingWriteOperationIterable.this.delegated.into(target, callback);
                        }
                    }
                });
            }
        }
        if (localWriteCompleted) {
            if (this.thrown != null) {
                callback.onResult(null, this.thrown);
            } else {
                this.delegated.into(target, callback);
            }
        }
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchCursor(final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        boolean localWriteCompleted;
        AwaitingWriteOperationIterable awaitingWriteOperationIterable = this;
        synchronized (awaitingWriteOperationIterable) {
            localWriteCompleted = this.writeCompleted;
            if (!localWriteCompleted) {
                this.callbacks.add(new SingleResultCallback<Void>(){

                    public void onResult(Void result, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            AwaitingWriteOperationIterable.this.delegated.batchCursor(callback);
                        }
                    }
                });
            }
        }
        if (localWriteCompleted) {
            if (this.thrown != null) {
                callback.onResult(null, this.thrown);
            } else {
                this.delegated.batchCursor(callback);
            }
        }
    }
}

