/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.MongoAwsKmsProviderOptions;
import com.mongodb.crypt.capi.MongoLocalKmsProviderOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.assertions.Assertions;

public class MongoCryptOptions {
    private final MongoAwsKmsProviderOptions awsKmsProviderOptions;
    private final MongoLocalKmsProviderOptions localKmsProviderOptions;
    private final BsonDocument kmsProviderOptions;
    private final Map<String, BsonDocument> localSchemaMap;
    private final boolean needsKmsCredentialsStateEnabled;
    private final Map<String, BsonDocument> encryptedFieldsMap;
    private final BsonDocument extraOptions;
    private final boolean bypassQueryAnalysis;
    private final List<String> searchPaths;

    public static Builder builder() {
        return new Builder();
    }

    public MongoAwsKmsProviderOptions getAwsKmsProviderOptions() {
        return this.awsKmsProviderOptions;
    }

    public MongoLocalKmsProviderOptions getLocalKmsProviderOptions() {
        return this.localKmsProviderOptions;
    }

    public BsonDocument getKmsProviderOptions() {
        return this.kmsProviderOptions;
    }

    public Map<String, BsonDocument> getLocalSchemaMap() {
        return this.localSchemaMap;
    }

    public boolean isNeedsKmsCredentialsStateEnabled() {
        return this.needsKmsCredentialsStateEnabled;
    }

    public Map<String, BsonDocument> getEncryptedFieldsMap() {
        return this.encryptedFieldsMap;
    }

    public boolean isBypassQueryAnalysis() {
        return this.bypassQueryAnalysis;
    }

    public BsonDocument getExtraOptions() {
        return this.extraOptions;
    }

    public List<String> getSearchPaths() {
        return this.searchPaths;
    }

    private MongoCryptOptions(Builder builder) {
        Assertions.isTrue((String)"at least one KMS provider is configured", (builder.awsKmsProviderOptions != null || builder.localKmsProviderOptions != null || builder.kmsProviderOptions != null ? 1 : 0) != 0);
        this.awsKmsProviderOptions = builder.awsKmsProviderOptions;
        this.localKmsProviderOptions = builder.localKmsProviderOptions;
        this.kmsProviderOptions = builder.kmsProviderOptions;
        this.localSchemaMap = builder.localSchemaMap;
        this.needsKmsCredentialsStateEnabled = builder.needsKmsCredentialsStateEnabled;
        this.encryptedFieldsMap = builder.encryptedFieldsMap;
        this.bypassQueryAnalysis = builder.bypassQueryAnalysis;
        this.extraOptions = builder.extraOptions;
        this.searchPaths = builder.searchPaths;
    }

    public static class Builder {
        private MongoAwsKmsProviderOptions awsKmsProviderOptions;
        private MongoLocalKmsProviderOptions localKmsProviderOptions;
        private BsonDocument kmsProviderOptions = null;
        private Map<String, BsonDocument> localSchemaMap = null;
        private boolean needsKmsCredentialsStateEnabled;
        private Map<String, BsonDocument> encryptedFieldsMap = null;
        private boolean bypassQueryAnalysis;
        private BsonDocument extraOptions = new BsonDocument();
        private List<String> searchPaths = Collections.emptyList();

        private Builder() {
        }

        public Builder awsKmsProviderOptions(MongoAwsKmsProviderOptions awsKmsProviderOptions) {
            this.awsKmsProviderOptions = awsKmsProviderOptions;
            return this;
        }

        public Builder localKmsProviderOptions(MongoLocalKmsProviderOptions localKmsProviderOptions) {
            this.localKmsProviderOptions = localKmsProviderOptions;
            return this;
        }

        public Builder kmsProviderOptions(BsonDocument kmsProviderOptions) {
            this.kmsProviderOptions = kmsProviderOptions;
            return this;
        }

        public Builder localSchemaMap(Map<String, BsonDocument> localSchemaMap) {
            this.localSchemaMap = localSchemaMap;
            return this;
        }

        public Builder needsKmsCredentialsStateEnabled(boolean needsKmsCredentialsStateEnabled) {
            this.needsKmsCredentialsStateEnabled = needsKmsCredentialsStateEnabled;
            return this;
        }

        public Builder encryptedFieldsMap(Map<String, BsonDocument> encryptedFieldsMap) {
            this.encryptedFieldsMap = encryptedFieldsMap;
            return this;
        }

        public Builder bypassQueryAnalysis(boolean bypassQueryAnalysis) {
            this.bypassQueryAnalysis = bypassQueryAnalysis;
            return this;
        }

        public Builder extraOptions(BsonDocument extraOptions) {
            this.extraOptions = extraOptions;
            return this;
        }

        public Builder searchPaths(List<String> searchPaths) {
            this.searchPaths = searchPaths;
            return this;
        }

        public MongoCryptOptions build() {
            return new MongoCryptOptions(this);
        }
    }
}

